/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.oracle;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.units.Duration;
import java.math.RoundingMode;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class OracleConfig {
    private boolean synonymsEnabled;
    private boolean remarksReportingEnabled;
    private Integer defaultNumberScale;
    private RoundingMode numberRoundingMode = RoundingMode.UNNECESSARY;
    private boolean connectionPoolEnabled = true;
    private int connectionPoolMinSize = 1;
    private int connectionPoolMaxSize = 30;
    private Duration inactiveConnectionTimeout = new Duration(20.0, TimeUnit.MINUTES);

    @NotNull
    public boolean isSynonymsEnabled() {
        return this.synonymsEnabled;
    }

    @Config(value="oracle.synonyms.enabled")
    public OracleConfig setSynonymsEnabled(boolean enabled) {
        this.synonymsEnabled = enabled;
        return this;
    }

    public boolean isRemarksReportingEnabled() {
        return this.remarksReportingEnabled;
    }

    @Config(value="oracle.remarks-reporting.enabled")
    public OracleConfig setRemarksReportingEnabled(boolean enabled) {
        this.remarksReportingEnabled = enabled;
        return this;
    }

    public Optional<@Min(value=0L) @Max(value=38L) Integer> getDefaultNumberScale() {
        return Optional.ofNullable(this.defaultNumberScale);
    }

    @Config(value="oracle.number.default-scale")
    @ConfigDescription(value="Default Trino DECIMAL scale for Oracle NUMBER data type")
    public OracleConfig setDefaultNumberScale(Integer defaultNumberScale) {
        this.defaultNumberScale = defaultNumberScale;
        return this;
    }

    @NotNull
    public RoundingMode getNumberRoundingMode() {
        return this.numberRoundingMode;
    }

    @Config(value="oracle.number.rounding-mode")
    public OracleConfig setNumberRoundingMode(RoundingMode numberRoundingMode) {
        this.numberRoundingMode = numberRoundingMode;
        return this;
    }

    @NotNull
    public boolean isConnectionPoolEnabled() {
        return this.connectionPoolEnabled;
    }

    @Config(value="oracle.connection-pool.enabled")
    public OracleConfig setConnectionPoolEnabled(boolean connectionPoolEnabled) {
        this.connectionPoolEnabled = connectionPoolEnabled;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getConnectionPoolMinSize() {
        return this.connectionPoolMinSize;
    }

    @Config(value="oracle.connection-pool.min-size")
    public OracleConfig setConnectionPoolMinSize(int connectionPoolMinSize) {
        this.connectionPoolMinSize = connectionPoolMinSize;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getConnectionPoolMaxSize() {
        return this.connectionPoolMaxSize;
    }

    @Config(value="oracle.connection-pool.max-size")
    public OracleConfig setConnectionPoolMaxSize(int connectionPoolMaxSize) {
        this.connectionPoolMaxSize = connectionPoolMaxSize;
        return this;
    }

    @NotNull
    public Duration getInactiveConnectionTimeout() {
        return this.inactiveConnectionTimeout;
    }

    @Config(value="oracle.connection-pool.inactive-timeout")
    @ConfigDescription(value="How long a connection in the pool can remain idle before it is closed")
    public OracleConfig setInactiveConnectionTimeout(Duration inactiveConnectionTimeout) {
        this.inactiveConnectionTimeout = inactiveConnectionTimeout;
        return this;
    }

    @AssertTrue(message="Pool min size cannot be larger than max size")
    public @AssertTrue(message="Pool min size cannot be larger than max size") boolean isPoolSizedProperly() {
        return this.getConnectionPoolMaxSize() >= this.getConnectionPoolMinSize();
    }
}

