/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.memory;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.airlift.json.JsonCodec;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.spi.HostAddress;
import java.util.Objects;

public class MemoryDataFragment {
    private static final JsonCodec<MemoryDataFragment> MEMORY_DATA_FRAGMENT_CODEC = JsonCodec.jsonCodec(MemoryDataFragment.class);
    private final HostAddress hostAddress;
    private final long rows;

    @JsonCreator
    public MemoryDataFragment(@JsonProperty(value="hostAddress") HostAddress hostAddress, @JsonProperty(value="rows") long rows) {
        this.hostAddress = Objects.requireNonNull(hostAddress, "hostAddress is null");
        Preconditions.checkArgument((rows >= 0L ? 1 : 0) != 0, (Object)"Rows number cannot be negative");
        this.rows = rows;
    }

    @JsonProperty
    public HostAddress getHostAddress() {
        return this.hostAddress;
    }

    @JsonProperty
    public long getRows() {
        return this.rows;
    }

    public Slice toSlice() {
        return Slices.wrappedBuffer((byte[])MEMORY_DATA_FRAGMENT_CODEC.toJsonBytes((Object)this));
    }

    public static MemoryDataFragment fromSlice(Slice fragment) {
        return (MemoryDataFragment)MEMORY_DATA_FRAGMENT_CODEC.fromJson(fragment.getBytes());
    }

    public static MemoryDataFragment merge(MemoryDataFragment a, MemoryDataFragment b) {
        Preconditions.checkArgument((boolean)a.getHostAddress().equals((Object)b.getHostAddress()), (Object)"Cannot merge fragments from different hosts");
        return new MemoryDataFragment(a.getHostAddress(), a.getRows() + b.getRows());
    }
}

