/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.avro;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.hive.formats.UnionToRowCoercionUtils;
import io.trino.hive.formats.avro.AvroTypeException;
import io.trino.hive.formats.avro.AvroTypeManager;
import io.trino.hive.formats.avro.AvroTypeUtils;
import io.trino.hive.formats.avro.model.ArrayReadAction;
import io.trino.hive.formats.avro.model.AvroReadAction;
import io.trino.hive.formats.avro.model.BooleanRead;
import io.trino.hive.formats.avro.model.BytesRead;
import io.trino.hive.formats.avro.model.DefaultValueFieldRecordFieldReadAction;
import io.trino.hive.formats.avro.model.DoubleRead;
import io.trino.hive.formats.avro.model.EnumReadAction;
import io.trino.hive.formats.avro.model.FixedRead;
import io.trino.hive.formats.avro.model.FloatRead;
import io.trino.hive.formats.avro.model.IntRead;
import io.trino.hive.formats.avro.model.LongRead;
import io.trino.hive.formats.avro.model.MapReadAction;
import io.trino.hive.formats.avro.model.NullRead;
import io.trino.hive.formats.avro.model.ReadErrorReadAction;
import io.trino.hive.formats.avro.model.ReadFieldAction;
import io.trino.hive.formats.avro.model.ReadingUnionReadAction;
import io.trino.hive.formats.avro.model.RecordFieldReadAction;
import io.trino.hive.formats.avro.model.RecordReadAction;
import io.trino.hive.formats.avro.model.SkipFieldRecordFieldReadAction;
import io.trino.hive.formats.avro.model.StringRead;
import io.trino.hive.formats.avro.model.WrittenUnionReadAction;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.ArrayBlockBuilder;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.MapBlockBuilder;
import io.trino.spi.block.RowBlockBuilder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.IntFunction;
import java.util.stream.IntStream;
import org.apache.avro.Resolver;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.FastReaderBuilder;
import org.apache.avro.io.parsing.ResolvingGrammarGenerator;
import org.apache.avro.util.internal.Accessor;

public class AvroPageDataReader
implements DatumReader<Optional<Page>> {
    private static final long MAX_ARRAY_SIZE = 0x7FFFFFF7L;
    private final Schema readerSchema;
    private Schema writerSchema;
    private final PageBuilder pageBuilder;
    private RowBlockBuildingDecoder rowBlockBuildingDecoder;
    private final AvroTypeManager typeManager;

    public AvroPageDataReader(Schema readerSchema, AvroTypeManager typeManager) throws AvroTypeException {
        this.writerSchema = this.readerSchema = Objects.requireNonNull(readerSchema, "readerSchema is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        try {
            Type readerSchemaType = AvroTypeUtils.typeFromAvro(this.readerSchema, typeManager);
            Verify.verify((boolean)(readerSchemaType instanceof RowType), (String)"Root Avro type must be a row", (Object[])new Object[0]);
            this.pageBuilder = new PageBuilder(readerSchemaType.getTypeParameters());
            this.initialize();
        }
        catch (org.apache.avro.AvroTypeException e) {
            throw new AvroTypeException(e);
        }
    }

    private void initialize() throws AvroTypeException {
        Verify.verify((this.readerSchema.getType() == Schema.Type.RECORD ? 1 : 0) != 0, (String)"Avro schema for page reader must be record", (Object[])new Object[0]);
        Verify.verify((this.writerSchema.getType() == Schema.Type.RECORD ? 1 : 0) != 0, (String)"File Avro schema for page reader must be record", (Object[])new Object[0]);
        this.rowBlockBuildingDecoder = new RowBlockBuildingDecoder(this.writerSchema, this.readerSchema, this.typeManager);
    }

    public void setSchema(Schema schema) {
        Objects.requireNonNull(schema, "schema is null");
        if (schema != this.writerSchema) {
            this.writerSchema = schema;
            try {
                this.initialize();
            }
            catch (org.apache.avro.AvroTypeException e) {
                throw new UncheckedAvroTypeException(new AvroTypeException(e));
            }
            catch (AvroTypeException e) {
                throw new UncheckedAvroTypeException(e);
            }
        }
    }

    public Optional<Page> read(Optional<Page> ignoredReuse, Decoder decoder) throws IOException {
        Optional<Page> page = Optional.empty();
        this.rowBlockBuildingDecoder.decodeIntoPageBuilder(decoder, this.pageBuilder);
        if (this.pageBuilder.isFull()) {
            page = Optional.of(this.pageBuilder.build());
            this.pageBuilder.reset();
        }
        return page;
    }

    public Optional<Page> flush() {
        if (!this.pageBuilder.isEmpty()) {
            Optional<Page> lastPage = Optional.of(this.pageBuilder.build());
            this.pageBuilder.reset();
            return lastPage;
        }
        return Optional.empty();
    }

    private static BlockBuildingDecoder createBlockBuildingDecoderForAction(AvroReadAction action, AvroTypeManager typeManager) throws AvroTypeException {
        Optional<BiConsumer<BlockBuilder, Object>> consumer = typeManager.overrideBuildingFunctionForSchema(action.readSchema());
        if (consumer.isPresent()) {
            return new UserDefinedBlockBuildingDecoder(action.readSchema(), action.writeSchema(), consumer.get());
        }
        AvroReadAction avroReadAction = action;
        Objects.requireNonNull(avroReadAction);
        AvroReadAction avroReadAction2 = avroReadAction;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{NullRead.class, BooleanRead.class, IntRead.class, LongRead.class, FloatRead.class, DoubleRead.class, BytesRead.class, FixedRead.class, StringRead.class, ArrayReadAction.class, MapReadAction.class, EnumReadAction.class, RecordReadAction.class, WrittenUnionReadAction.class, ReadingUnionReadAction.class, ReadErrorReadAction.class}, (Object)avroReadAction2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                NullRead __ = (NullRead)avroReadAction2;
                yield NullBlockBuildingDecoder.INSTANCE;
            }
            case 1 -> {
                BooleanRead __ = (BooleanRead)avroReadAction2;
                yield BooleanBlockBuildingDecoder.INSTANCE;
            }
            case 2 -> {
                IntRead __ = (IntRead)avroReadAction2;
                yield IntBlockBuildingDecoder.INSTANCE;
            }
            case 3 -> {
                LongRead longRead = (LongRead)avroReadAction2;
                yield new LongBlockBuildingDecoder(longRead.getLongDecoder());
            }
            case 4 -> {
                FloatRead floatRead = (FloatRead)avroReadAction2;
                yield new FloatBlockBuildingDecoder(floatRead.getFloatDecoder());
            }
            case 5 -> {
                DoubleRead doubleRead = (DoubleRead)avroReadAction2;
                yield new DoubleBlockBuildingDecoder(doubleRead.getDoubleDecoder());
            }
            case 6 -> {
                BytesRead __ = (BytesRead)avroReadAction2;
                yield BytesBlockBuildingDecoder.INSTANCE;
            }
            case 7 -> {
                FixedRead __ = (FixedRead)avroReadAction2;
                yield new FixedBlockBuildingDecoder(action.readSchema().getFixedSize());
            }
            case 8 -> {
                StringRead __ = (StringRead)avroReadAction2;
                yield StringBlockBuildingDecoder.INSTANCE;
            }
            case 9 -> {
                ArrayReadAction arrayReadAction = (ArrayReadAction)avroReadAction2;
                yield new ArrayBlockBuildingDecoder(arrayReadAction, typeManager);
            }
            case 10 -> {
                MapReadAction mapReadAction = (MapReadAction)avroReadAction2;
                yield new MapBlockBuildingDecoder(mapReadAction, typeManager);
            }
            case 11 -> {
                EnumReadAction enumReadAction = (EnumReadAction)avroReadAction2;
                yield new EnumBlockBuildingDecoder(enumReadAction);
            }
            case 12 -> {
                RecordReadAction recordReadAction = (RecordReadAction)avroReadAction2;
                yield new RowBlockBuildingDecoder(recordReadAction, typeManager);
            }
            case 13 -> {
                WrittenUnionReadAction writtenUnionReadAction = (WrittenUnionReadAction)avroReadAction2;
                if (writtenUnionReadAction.readSchema().getType() == Schema.Type.UNION && !AvroTypeUtils.isSimpleNullableUnion(writtenUnionReadAction.readSchema())) {
                    yield new WriterUnionCoercedIntoRowBlockBuildingDecoder(writtenUnionReadAction, typeManager);
                }
                yield new WriterUnionBlockBuildingDecoder(writtenUnionReadAction, typeManager);
            }
            case 14 -> {
                ReadingUnionReadAction readingUnionReadAction = (ReadingUnionReadAction)avroReadAction2;
                if (AvroTypeUtils.isSimpleNullableUnion(readingUnionReadAction.readSchema())) {
                    yield AvroPageDataReader.createBlockBuildingDecoderForAction(readingUnionReadAction.actualAction(), typeManager);
                }
                yield new ReaderUnionCoercedIntoRowBlockBuildingDecoder(readingUnionReadAction, typeManager);
            }
            case 15 -> {
                ReadErrorReadAction readErrorReadAction = (ReadErrorReadAction)avroReadAction2;
                yield new TypeErrorThrower(readErrorReadAction);
            }
        };
    }

    public static LongIoFunction<Decoder> getLongDecoderFunction(Schema writerSchema) {
        return switch (writerSchema.getType()) {
            case Schema.Type.INT -> Decoder::readInt;
            case Schema.Type.LONG -> Decoder::readLong;
            default -> throw new IllegalArgumentException("Cannot promote type %s to long".formatted(writerSchema.getType()));
        };
    }

    public static FloatIoFunction<Decoder> getFloatDecoderFunction(Schema writerSchema) {
        return switch (writerSchema.getType()) {
            case Schema.Type.INT -> Decoder::readInt;
            case Schema.Type.LONG -> Decoder::readLong;
            case Schema.Type.FLOAT -> Decoder::readFloat;
            default -> throw new IllegalArgumentException("Cannot promote type %s to float".formatted(writerSchema.getType()));
        };
    }

    public static DoubleIoFunction<Decoder> getDoubleDecoderFunction(Schema writerSchema) {
        return switch (writerSchema.getType()) {
            case Schema.Type.INT -> Decoder::readInt;
            case Schema.Type.LONG -> Decoder::readLong;
            case Schema.Type.FLOAT -> Decoder::readFloat;
            case Schema.Type.DOUBLE -> Decoder::readDouble;
            default -> throw new IllegalArgumentException("Cannot promote type %s to double".formatted(writerSchema.getType()));
        };
    }

    private static IoConsumer<BlockBuilder> getDefaultBlockBuilder(Schema fieldSchema, byte[] defaultBytes, AvroTypeManager typeManager) throws AvroTypeException {
        BlockBuildingDecoder buildingDecoder = AvroPageDataReader.createBlockBuildingDecoderForAction(AvroReadAction.fromAction(Resolver.resolve((Schema)fieldSchema, (Schema)fieldSchema)), typeManager);
        BinaryDecoder reuse = DecoderFactory.get().binaryDecoder(defaultBytes, null);
        return blockBuilder -> buildingDecoder.decodeIntoBlock((Decoder)DecoderFactory.get().binaryDecoder(defaultBytes, reuse), (BlockBuilder)blockBuilder);
    }

    public static byte[] getDefaultByes(Schema.Field field) throws AvroTypeException {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            BinaryEncoder e = EncoderFactory.get().binaryEncoder((OutputStream)out, null);
            ResolvingGrammarGenerator.encode((Encoder)e, (Schema)field.schema(), (JsonNode)Accessor.defaultValue((Schema.Field)field));
            e.flush();
            return out.toByteArray();
        }
        catch (IOException exception) {
            throw new AvroTypeException("Unable to encode to bytes for default value in field " + String.valueOf(field), exception);
        }
    }

    public static class RowBlockBuildingDecoder
    extends BlockBuildingDecoder {
        private final RowBuildingAction[] buildSteps;

        private RowBlockBuildingDecoder(Schema writeSchema, Schema readSchema, AvroTypeManager typeManager) throws AvroTypeException {
            this(AvroReadAction.fromAction(Resolver.resolve((Schema)writeSchema, (Schema)readSchema, (GenericData)new GenericData())), typeManager);
        }

        private RowBlockBuildingDecoder(AvroReadAction action, AvroTypeManager typeManager) throws AvroTypeException {
            if (!(action instanceof RecordReadAction)) {
                throw new AvroTypeException("Write and Read Schemas must be records when building a row block building decoder. Illegal action: " + String.valueOf(action));
            }
            RecordReadAction recordReadAction = (RecordReadAction)action;
            this.buildSteps = new RowBuildingAction[recordReadAction.fieldReadActions().size()];
            int i = 0;
            for (RecordFieldReadAction fieldAction : recordReadAction.fieldReadActions()) {
                RecordFieldReadAction recordFieldReadAction;
                Objects.requireNonNull(fieldAction);
                int n = 0;
                this.buildSteps[i] = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DefaultValueFieldRecordFieldReadAction.class, ReadFieldAction.class, SkipFieldRecordFieldReadAction.class}, (Object)recordFieldReadAction, n)) {
                    default -> throw new MatchException(null, null);
                    case 0 -> {
                        DefaultValueFieldRecordFieldReadAction defaultValueFieldRecordFieldReadAction = (DefaultValueFieldRecordFieldReadAction)recordFieldReadAction;
                        yield new ConstantBlockAction(AvroPageDataReader.getDefaultBlockBuilder(defaultValueFieldRecordFieldReadAction.fieldSchema(), defaultValueFieldRecordFieldReadAction.defaultBytes(), typeManager), defaultValueFieldRecordFieldReadAction.outputChannel());
                    }
                    case 1 -> {
                        ReadFieldAction readFieldAction = (ReadFieldAction)recordFieldReadAction;
                        yield new BuildIntoBlockAction(AvroPageDataReader.createBlockBuildingDecoderForAction(readFieldAction.readAction(), typeManager), readFieldAction.outputChannel());
                    }
                    case 2 -> {
                        SkipFieldRecordFieldReadAction skipFieldRecordFieldReadAction = (SkipFieldRecordFieldReadAction)recordFieldReadAction;
                        yield new SkipSchemaBuildingAction(skipFieldRecordFieldReadAction.skipAction());
                    }
                };
                ++i;
            }
        }

        @Override
        protected void decodeIntoBlock(Decoder decoder, BlockBuilder builder) throws IOException {
            ((RowBlockBuilder)builder).buildEntry(fieldBuilders -> this.decodeIntoBlockProvided(decoder, fieldBuilders::get));
        }

        protected void decodeIntoPageBuilder(Decoder decoder, PageBuilder builder) throws IOException {
            builder.declarePosition();
            this.decodeIntoBlockProvided(decoder, arg_0 -> ((PageBuilder)builder).getBlockBuilder(arg_0));
        }

        protected void decodeIntoBlockProvided(Decoder decoder, IntFunction<BlockBuilder> fieldBlockBuilder) throws IOException {
            block5: for (RowBuildingAction buildStep : this.buildSteps) {
                RowBuildingAction rowBuildingAction;
                Objects.requireNonNull(buildStep);
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SkipSchemaBuildingAction.class, BuildIntoBlockAction.class, ConstantBlockAction.class}, (Object)rowBuildingAction, n)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        SkipSchemaBuildingAction skipSchemaBuildingAction = (SkipSchemaBuildingAction)rowBuildingAction;
                        skipSchemaBuildingAction.skip(decoder);
                        continue block5;
                    }
                    case 1: {
                        BuildIntoBlockAction buildIntoBlockAction = (BuildIntoBlockAction)rowBuildingAction;
                        buildIntoBlockAction.decode(decoder, fieldBlockBuilder);
                        continue block5;
                    }
                    case 2: {
                        ConstantBlockAction constantBlockAction = (ConstantBlockAction)rowBuildingAction;
                        constantBlockAction.addConstant(fieldBlockBuilder);
                    }
                }
            }
        }

        static sealed interface RowBuildingAction
        permits BuildIntoBlockAction, ConstantBlockAction, SkipSchemaBuildingAction {
        }

        protected static final class ConstantBlockAction
        implements RowBuildingAction {
            private final IoConsumer<BlockBuilder> addConstantFunction;
            private final int outputChannel;

            public ConstantBlockAction(IoConsumer<BlockBuilder> addConstantFunction, int outputChannel) {
                this.addConstantFunction = Objects.requireNonNull(addConstantFunction, "addConstantFunction is null");
                Preconditions.checkArgument((outputChannel >= 0 ? 1 : 0) != 0, (Object)"outputChannel must be positive");
                this.outputChannel = outputChannel;
            }

            public void addConstant(IntFunction<BlockBuilder> channelSelector) throws IOException {
                this.addConstantFunction.accept(channelSelector.apply(this.outputChannel));
            }
        }

        private static final class BuildIntoBlockAction
        implements RowBuildingAction {
            private final BlockBuildingDecoder delegate;
            private final int outputChannel;

            public BuildIntoBlockAction(BlockBuildingDecoder delegate, int outputChannel) {
                this.delegate = Objects.requireNonNull(delegate, "delegate is null");
                Preconditions.checkArgument((outputChannel >= 0 ? 1 : 0) != 0, (Object)"outputChannel must be positive");
                this.outputChannel = outputChannel;
            }

            public void decode(Decoder decoder, IntFunction<BlockBuilder> channelSelector) throws IOException {
                this.delegate.decodeIntoBlock(decoder, channelSelector.apply(this.outputChannel));
            }
        }

        public static final class SkipSchemaBuildingAction
        implements RowBuildingAction {
            private final SkipAction skipAction;

            SkipSchemaBuildingAction(SkipAction skipAction) {
                this.skipAction = Objects.requireNonNull(skipAction, "skipAction is null");
            }

            public void skip(Decoder decoder) throws IOException {
                this.skipAction.skip(decoder);
            }

            public static SkipAction createSkipActionForSchema(Schema schema) {
                return switch (schema.getType()) {
                    default -> throw new MatchException(null, null);
                    case Schema.Type.NULL -> Decoder::readNull;
                    case Schema.Type.BOOLEAN -> Decoder::readBoolean;
                    case Schema.Type.INT -> Decoder::readInt;
                    case Schema.Type.LONG -> Decoder::readLong;
                    case Schema.Type.FLOAT -> Decoder::readFloat;
                    case Schema.Type.DOUBLE -> Decoder::readDouble;
                    case Schema.Type.STRING -> Decoder::skipString;
                    case Schema.Type.BYTES -> Decoder::skipBytes;
                    case Schema.Type.ENUM -> Decoder::readEnum;
                    case Schema.Type.FIXED -> {
                        int size = schema.getFixedSize();
                        yield decoder -> decoder.skipFixed(size);
                    }
                    case Schema.Type.ARRAY -> new ArraySkipAction(schema.getElementType());
                    case Schema.Type.MAP -> new MapSkipAction(schema.getValueType());
                    case Schema.Type.RECORD -> new RecordSkipAction(schema.getFields());
                    case Schema.Type.UNION -> new UnionSkipAction(schema.getTypes());
                };
            }

            @FunctionalInterface
            public static interface SkipAction {
                public void skip(Decoder var1) throws IOException;
            }

            private static class ArraySkipAction
            implements SkipAction {
                private final SkipAction elementSkipAction;

                public ArraySkipAction(Schema elementSchema) {
                    this.elementSkipAction = SkipSchemaBuildingAction.createSkipActionForSchema(Objects.requireNonNull(elementSchema, "elementSchema is null"));
                }

                @Override
                public void skip(Decoder decoder) throws IOException {
                    long i = decoder.skipArray();
                    while (i != 0L) {
                        for (long j = 0L; j < i; ++j) {
                            this.elementSkipAction.skip(decoder);
                        }
                        i = decoder.skipArray();
                    }
                }
            }

            private static class MapSkipAction
            implements SkipAction {
                private final SkipAction valueSkipAction;

                public MapSkipAction(Schema valueSchema) {
                    this.valueSkipAction = SkipSchemaBuildingAction.createSkipActionForSchema(Objects.requireNonNull(valueSchema, "valueSchema is null"));
                }

                @Override
                public void skip(Decoder decoder) throws IOException {
                    long i = decoder.skipMap();
                    while (i != 0L) {
                        for (long j = 0L; j < i; ++j) {
                            decoder.skipString();
                            this.valueSkipAction.skip(decoder);
                        }
                        i = decoder.skipMap();
                    }
                }
            }

            private static class RecordSkipAction
            implements SkipAction {
                private final SkipAction[] fieldSkips;

                public RecordSkipAction(List<Schema.Field> fields) {
                    this.fieldSkips = new SkipAction[Objects.requireNonNull(fields, "fields is null").size()];
                    for (int i = 0; i < fields.size(); ++i) {
                        this.fieldSkips[i] = SkipSchemaBuildingAction.createSkipActionForSchema(fields.get(i).schema());
                    }
                }

                @Override
                public void skip(Decoder decoder) throws IOException {
                    for (SkipAction fieldSkipAction : this.fieldSkips) {
                        fieldSkipAction.skip(decoder);
                    }
                }
            }

            private static class UnionSkipAction
            implements SkipAction {
                private final SkipAction[] skipActions;

                private UnionSkipAction(List<Schema> types) {
                    this.skipActions = new SkipAction[Objects.requireNonNull(types, "types is null").size()];
                    for (int i = 0; i < types.size(); ++i) {
                        this.skipActions[i] = SkipSchemaBuildingAction.createSkipActionForSchema(types.get(i));
                    }
                }

                @Override
                public void skip(Decoder decoder) throws IOException {
                    this.skipActions[decoder.readIndex()].skip(decoder);
                }
            }
        }
    }

    protected static class UncheckedAvroTypeException
    extends RuntimeException {
        private final AvroTypeException avroTypeException;

        public UncheckedAvroTypeException(AvroTypeException cause) {
            super(Objects.requireNonNull(cause, "cause is null"));
            this.avroTypeException = cause;
        }

        public AvroTypeException getAvroTypeException() {
            return this.avroTypeException;
        }
    }

    private static class UserDefinedBlockBuildingDecoder
    extends BlockBuildingDecoder {
        private final BiConsumer<BlockBuilder, Object> userBuilderFunction;
        private final DatumReader<Object> datumReader;

        public UserDefinedBlockBuildingDecoder(Schema readerSchema, Schema writerSchema, BiConsumer<BlockBuilder, Object> userBuilderFunction) throws AvroTypeException {
            Objects.requireNonNull(readerSchema, "readerSchema is null");
            Objects.requireNonNull(writerSchema, "writerSchema is null");
            try {
                FastReaderBuilder fastReaderBuilder = new FastReaderBuilder(new GenericData());
                this.datumReader = fastReaderBuilder.createDatumReader(writerSchema, readerSchema);
            }
            catch (IOException ioException) {
                throw new AvroTypeException("Unable to decode default value in schema " + String.valueOf(readerSchema), ioException);
            }
            this.userBuilderFunction = Objects.requireNonNull(userBuilderFunction, "userBuilderFunction is null");
        }

        @Override
        protected void decodeIntoBlock(Decoder decoder, BlockBuilder builder) throws IOException {
            this.userBuilderFunction.accept(builder, this.datumReader.read(null, decoder));
        }
    }

    private static class NullBlockBuildingDecoder
    extends BlockBuildingDecoder {
        private static final NullBlockBuildingDecoder INSTANCE = new NullBlockBuildingDecoder();

        private NullBlockBuildingDecoder() {
        }

        @Override
        protected void decodeIntoBlock(Decoder decoder, BlockBuilder builder) throws IOException {
            decoder.readNull();
            builder.appendNull();
        }
    }

    private static class BooleanBlockBuildingDecoder
    extends BlockBuildingDecoder {
        private static final BooleanBlockBuildingDecoder INSTANCE = new BooleanBlockBuildingDecoder();

        private BooleanBlockBuildingDecoder() {
        }

        @Override
        protected void decodeIntoBlock(Decoder decoder, BlockBuilder builder) throws IOException {
            BooleanType.BOOLEAN.writeBoolean(builder, decoder.readBoolean());
        }
    }

    private static class IntBlockBuildingDecoder
    extends BlockBuildingDecoder {
        private static final IntBlockBuildingDecoder INSTANCE = new IntBlockBuildingDecoder();

        private IntBlockBuildingDecoder() {
        }

        @Override
        protected void decodeIntoBlock(Decoder decoder, BlockBuilder builder) throws IOException {
            IntegerType.INTEGER.writeLong(builder, (long)decoder.readInt());
        }
    }

    private static class LongBlockBuildingDecoder
    extends BlockBuildingDecoder {
        private final LongIoFunction<Decoder> extractLong;

        public LongBlockBuildingDecoder(LongIoFunction<Decoder> extractLong) {
            this.extractLong = Objects.requireNonNull(extractLong, "extractLong is null");
        }

        @Override
        protected void decodeIntoBlock(Decoder decoder, BlockBuilder builder) throws IOException {
            BigintType.BIGINT.writeLong(builder, this.extractLong.apply(decoder));
        }
    }

    @FunctionalInterface
    public static interface LongIoFunction<A> {
        public long apply(A var1) throws IOException;
    }

    private static class FloatBlockBuildingDecoder
    extends BlockBuildingDecoder {
        private final FloatIoFunction<Decoder> extractFloat;

        public FloatBlockBuildingDecoder(FloatIoFunction<Decoder> extractFloat) {
            this.extractFloat = Objects.requireNonNull(extractFloat, "extractFloat is null");
        }

        @Override
        protected void decodeIntoBlock(Decoder decoder, BlockBuilder builder) throws IOException {
            RealType.REAL.writeLong(builder, (long)Float.floatToRawIntBits(this.extractFloat.apply(decoder)));
        }
    }

    @FunctionalInterface
    public static interface FloatIoFunction<A> {
        public float apply(A var1) throws IOException;
    }

    private static class DoubleBlockBuildingDecoder
    extends BlockBuildingDecoder {
        private final DoubleIoFunction<Decoder> extractDouble;

        public DoubleBlockBuildingDecoder(DoubleIoFunction<Decoder> extractDouble) {
            this.extractDouble = Objects.requireNonNull(extractDouble, "extractDouble is null");
        }

        @Override
        protected void decodeIntoBlock(Decoder decoder, BlockBuilder builder) throws IOException {
            DoubleType.DOUBLE.writeDouble(builder, this.extractDouble.apply(decoder));
        }
    }

    @FunctionalInterface
    public static interface DoubleIoFunction<A> {
        public double apply(A var1) throws IOException;
    }

    private static class BytesBlockBuildingDecoder
    extends BlockBuildingDecoder {
        private static final BytesBlockBuildingDecoder INSTANCE = new BytesBlockBuildingDecoder();

        private BytesBlockBuildingDecoder() {
        }

        @Override
        protected void decodeIntoBlock(Decoder decoder, BlockBuilder builder) throws IOException {
            long size = decoder.readLong();
            if (size > 0x7FFFFFF7L) {
                throw new IOException("Unable to read avro Bytes with size greater than %s. Found Bytes size: %s".formatted(0x7FFFFFF7L, size));
            }
            byte[] bytes = new byte[(int)size];
            decoder.readFixed(bytes);
            VarbinaryType.VARBINARY.writeSlice(builder, Slices.wrappedBuffer((byte[])bytes));
        }
    }

    private static class FixedBlockBuildingDecoder
    extends BlockBuildingDecoder {
        private final int expectedSize;

        public FixedBlockBuildingDecoder(int expectedSize) {
            Verify.verify((expectedSize >= 0 ? 1 : 0) != 0, (String)"expected size must be greater than or equal to 0", (Object[])new Object[0]);
            this.expectedSize = expectedSize;
        }

        @Override
        protected void decodeIntoBlock(Decoder decoder, BlockBuilder builder) throws IOException {
            byte[] slice = new byte[this.expectedSize];
            decoder.readFixed(slice);
            VarbinaryType.VARBINARY.writeSlice(builder, Slices.wrappedBuffer((byte[])slice));
        }
    }

    private static class StringBlockBuildingDecoder
    extends BlockBuildingDecoder {
        private static final StringBlockBuildingDecoder INSTANCE = new StringBlockBuildingDecoder();

        private StringBlockBuildingDecoder() {
        }

        @Override
        protected void decodeIntoBlock(Decoder decoder, BlockBuilder builder) throws IOException {
            long size = decoder.readLong();
            if (size > 0x7FFFFFF7L) {
                throw new IOException("Unable to read avro String with size greater than %s. Found String size: %s".formatted(0x7FFFFFF7L, size));
            }
            byte[] bytes = new byte[(int)size];
            decoder.readFixed(bytes);
            VarcharType.VARCHAR.writeSlice(builder, Slices.wrappedBuffer((byte[])bytes));
        }
    }

    private static class ArrayBlockBuildingDecoder
    extends BlockBuildingDecoder {
        private final BlockBuildingDecoder elementBlockBuildingDecoder;

        public ArrayBlockBuildingDecoder(ArrayReadAction arrayReadAction, AvroTypeManager typeManager) throws AvroTypeException {
            Objects.requireNonNull(arrayReadAction, "arrayReadAction is null");
            this.elementBlockBuildingDecoder = AvroPageDataReader.createBlockBuildingDecoderForAction(arrayReadAction.elementReadAction(), typeManager);
        }

        @Override
        protected void decodeIntoBlock(Decoder decoder, BlockBuilder builder) throws IOException {
            ((ArrayBlockBuilder)builder).buildEntry(elementBuilder -> {
                long elementsInBlock = decoder.readArrayStart();
                if (elementsInBlock > 0L) {
                    do {
                        int i = 0;
                        while ((long)i < elementsInBlock) {
                            this.elementBlockBuildingDecoder.decodeIntoBlock(decoder, elementBuilder);
                            ++i;
                        }
                    } while ((elementsInBlock = decoder.arrayNext()) > 0L);
                }
            });
        }
    }

    private static class MapBlockBuildingDecoder
    extends BlockBuildingDecoder {
        private final BlockBuildingDecoder keyBlockBuildingDecoder = new StringBlockBuildingDecoder();
        private final BlockBuildingDecoder valueBlockBuildingDecoder;

        public MapBlockBuildingDecoder(MapReadAction mapReadAction, AvroTypeManager typeManager) throws AvroTypeException {
            Objects.requireNonNull(mapReadAction, "mapReadAction is null");
            this.valueBlockBuildingDecoder = AvroPageDataReader.createBlockBuildingDecoderForAction(mapReadAction.valueReadAction(), typeManager);
        }

        @Override
        protected void decodeIntoBlock(Decoder decoder, BlockBuilder builder) throws IOException {
            ((MapBlockBuilder)builder).buildEntry((keyBuilder, valueBuilder) -> {
                long entriesInBlock = decoder.readMapStart();
                if (entriesInBlock > 0L) {
                    do {
                        int i = 0;
                        while ((long)i < entriesInBlock) {
                            this.keyBlockBuildingDecoder.decodeIntoBlock(decoder, keyBuilder);
                            this.valueBlockBuildingDecoder.decodeIntoBlock(decoder, valueBuilder);
                            ++i;
                        }
                    } while ((entriesInBlock = decoder.mapNext()) > 0L);
                }
            });
        }
    }

    private static class EnumBlockBuildingDecoder
    extends BlockBuildingDecoder {
        private final List<Slice> symbols;

        public EnumBlockBuildingDecoder(EnumReadAction enumReadAction) {
            Objects.requireNonNull(enumReadAction, "action is null");
            this.symbols = enumReadAction.getSymbolIndex();
        }

        @Override
        protected void decodeIntoBlock(Decoder decoder, BlockBuilder builder) throws IOException {
            VarcharType.VARCHAR.writeSlice(builder, this.symbols.get(decoder.readEnum()));
        }
    }

    private static class WriterUnionCoercedIntoRowBlockBuildingDecoder
    extends WriterUnionBlockBuildingDecoder {
        private final boolean readUnionEquiv;
        private final int[] indexToChannel;
        private final int totalChannels;

        public WriterUnionCoercedIntoRowBlockBuildingDecoder(WrittenUnionReadAction writtenUnionReadAction, AvroTypeManager avroTypeManager) throws AvroTypeException {
            super(writtenUnionReadAction, avroTypeManager);
            this.readUnionEquiv = writtenUnionReadAction.unionEqiv();
            List readSchemas = writtenUnionReadAction.readSchema().getTypes();
            Preconditions.checkArgument((readSchemas.size() == writtenUnionReadAction.writeOptionReadActions().size() ? 1 : 0) != 0, (Object)"each read schema must have resolvedAction For it");
            this.indexToChannel = WriterUnionCoercedIntoRowBlockBuildingDecoder.getIndexToChannel(readSchemas);
            this.totalChannels = (int)IntStream.of(this.indexToChannel).filter(i -> i >= 0).count();
        }

        @Override
        protected void decodeIntoBlock(Decoder decoder, BlockBuilder builder) throws IOException {
            int index = decoder.readIndex();
            if (this.readUnionEquiv) {
                if (this.indexToChannel[index] < 0) {
                    NullBlockBuildingDecoder.INSTANCE.decodeIntoBlock(decoder, builder);
                } else {
                    WriterUnionCoercedIntoRowBlockBuildingDecoder.makeSingleRowWithTagAndAllFieldsNullButOne(this.indexToChannel[index], this.totalChannels, this.blockBuildingDecoders[index], decoder, builder);
                }
            } else {
                this.decodeIntoBlock(index, decoder, builder);
            }
        }

        protected static void makeSingleRowWithTagAndAllFieldsNullButOne(int outputChannel, int totalChannels, BlockBuildingDecoder blockBuildingDecoder, Decoder decoder, BlockBuilder builder) throws IOException {
            ((RowBlockBuilder)builder).buildEntry(fieldBuilders -> {
                UnionToRowCoercionUtils.UNION_FIELD_TAG_TYPE.writeLong((BlockBuilder)fieldBuilders.getFirst(), (long)outputChannel);
                for (int channel = 1; channel <= totalChannels; ++channel) {
                    if (channel == outputChannel + 1) {
                        blockBuildingDecoder.decodeIntoBlock(decoder, (BlockBuilder)fieldBuilders.get(channel));
                        continue;
                    }
                    ((BlockBuilder)fieldBuilders.get(channel)).appendNull();
                }
            });
        }

        protected static int[] getIndexToChannel(List<Schema> schemas) {
            int[] indexToChannel = new int[schemas.size()];
            int outputChannel = 0;
            for (int i = 0; i < indexToChannel.length; ++i) {
                indexToChannel[i] = schemas.get(i).getType() == Schema.Type.NULL ? -1 : outputChannel++;
            }
            return indexToChannel;
        }
    }

    private static class WriterUnionBlockBuildingDecoder
    extends BlockBuildingDecoder {
        protected final BlockBuildingDecoder[] blockBuildingDecoders;

        public WriterUnionBlockBuildingDecoder(WrittenUnionReadAction writtenUnionReadAction, AvroTypeManager typeManager) throws AvroTypeException {
            Objects.requireNonNull(writtenUnionReadAction, "writerUnion is null");
            this.blockBuildingDecoders = new BlockBuildingDecoder[writtenUnionReadAction.writeOptionReadActions().size()];
            for (int i = 0; i < writtenUnionReadAction.writeOptionReadActions().size(); ++i) {
                this.blockBuildingDecoders[i] = AvroPageDataReader.createBlockBuildingDecoderForAction(writtenUnionReadAction.writeOptionReadActions().get(i), typeManager);
            }
        }

        @Override
        protected void decodeIntoBlock(Decoder decoder, BlockBuilder builder) throws IOException {
            this.decodeIntoBlock(decoder.readIndex(), decoder, builder);
        }

        protected void decodeIntoBlock(int blockBuilderIndex, Decoder decoder, BlockBuilder builder) throws IOException {
            this.blockBuildingDecoders[blockBuilderIndex].decodeIntoBlock(decoder, builder);
        }
    }

    private static abstract class BlockBuildingDecoder {
        private BlockBuildingDecoder() {
        }

        protected abstract void decodeIntoBlock(Decoder var1, BlockBuilder var2) throws IOException;
    }

    private static class ReaderUnionCoercedIntoRowBlockBuildingDecoder
    extends BlockBuildingDecoder {
        private final BlockBuildingDecoder delegateBuilder;
        private final int outputChannel;
        private final int totalChannels;

        public ReaderUnionCoercedIntoRowBlockBuildingDecoder(ReadingUnionReadAction readingUnionReadAction, AvroTypeManager avroTypeManager) throws AvroTypeException {
            Objects.requireNonNull(readingUnionReadAction, "readerUnion is null");
            Objects.requireNonNull(avroTypeManager, "avroTypeManger is null");
            int[] indexToChannel = WriterUnionCoercedIntoRowBlockBuildingDecoder.getIndexToChannel(readingUnionReadAction.readSchema().getTypes());
            this.outputChannel = indexToChannel[readingUnionReadAction.firstMatch()];
            this.delegateBuilder = AvroPageDataReader.createBlockBuildingDecoderForAction(readingUnionReadAction.actualAction(), avroTypeManager);
            this.totalChannels = (int)IntStream.of(indexToChannel).filter(i -> i >= 0).count();
        }

        @Override
        protected void decodeIntoBlock(Decoder decoder, BlockBuilder builder) throws IOException {
            if (this.outputChannel < 0) {
                NullBlockBuildingDecoder.INSTANCE.decodeIntoBlock(decoder, builder);
            } else {
                WriterUnionCoercedIntoRowBlockBuildingDecoder.makeSingleRowWithTagAndAllFieldsNullButOne(this.outputChannel, this.totalChannels, this.delegateBuilder, decoder, builder);
            }
        }
    }

    private static class TypeErrorThrower
    extends BlockBuildingDecoder {
        private final ReadErrorReadAction action;

        public TypeErrorThrower(ReadErrorReadAction action) {
            this.action = Objects.requireNonNull(action, "action is null");
        }

        @Override
        protected void decodeIntoBlock(Decoder decoder, BlockBuilder builder) throws IOException {
            throw new IOException(new AvroTypeException("Resolution action returned with error " + String.valueOf(this.action)));
        }
    }

    @FunctionalInterface
    public static interface IoConsumer<A> {
        public void accept(A var1) throws IOException;
    }
}

