/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.line;

import com.google.common.base.Preconditions;
import io.trino.hive.formats.line.LineBuffer;
import io.trino.hive.formats.line.LineReader;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Objects;
import java.util.Queue;
import java.util.function.Supplier;

public class FooterAwareLineReader
implements LineReader {
    private final LineReader delegate;
    private final Queue<LineBuffer> buffer;
    private LineBuffer nextBuffer;

    public FooterAwareLineReader(LineReader delegate, int footerCount, Supplier<LineBuffer> lineBufferSupplier) throws IOException {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.buffer = new ArrayDeque<LineBuffer>(footerCount);
        Preconditions.checkArgument((footerCount > 0 ? 1 : 0) != 0, (Object)"footerCount must be at least 1");
        this.nextBuffer = lineBufferSupplier.get();
        for (int i = 0; i < footerCount; ++i) {
            this.bufferValue(lineBufferSupplier.get());
        }
    }

    @Override
    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    @Override
    public long getRetainedSize() {
        return this.delegate.getRetainedSize();
    }

    @Override
    public long getBytesRead() {
        return this.delegate.getBytesRead();
    }

    @Override
    public long getReadTimeNanos() {
        return this.delegate.getReadTimeNanos();
    }

    @Override
    public boolean readLine(LineBuffer lineBuffer) throws IOException {
        lineBuffer.reset();
        if (this.nextBuffer != null) {
            this.bufferValue(this.nextBuffer);
        }
        this.nextBuffer = this.buffer.poll();
        if (this.nextBuffer != null) {
            FooterAwareLineReader.copyValue(this.nextBuffer, lineBuffer);
        }
        return this.nextBuffer != null;
    }

    @Override
    public void close() throws IOException {
        this.nextBuffer = null;
        this.buffer.clear();
        this.delegate.close();
    }

    private void bufferValue(LineBuffer lineBuffer) throws IOException {
        if (this.delegate.readLine(lineBuffer)) {
            this.buffer.add(lineBuffer);
        } else {
            this.close();
        }
    }

    private static void copyValue(LineBuffer source, LineBuffer destination) throws IOException {
        destination.reset();
        destination.write(source.getBuffer(), 0, source.getLength());
    }
}

