/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hdfs.rubix;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.OptionalBinder;
import com.qubole.rubix.prestosql.CachingPrestoDistributedFileSystem;
import io.airlift.configuration.ConfigBinder;
import io.trino.hdfs.DynamicConfigurationProvider;
import io.trino.hdfs.authentication.HdfsAuthenticationConfig;
import io.trino.hdfs.rubix.RubixConfig;
import io.trino.hdfs.rubix.RubixConfigurationInitializer;
import io.trino.hdfs.rubix.RubixHdfsInitializer;
import io.trino.hdfs.rubix.RubixInitializer;
import java.util.Objects;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;

public class RubixModule
implements Module {
    public void configure(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(RubixConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(HdfsAuthenticationConfig.class);
        binder.bind(RubixConfigurationInitializer.class).in(Scopes.SINGLETON);
        binder.bind(RubixInitializer.class).in(Scopes.SINGLETON);
        binder.bind(RubixStarter.class).asEagerSingleton();
        OptionalBinder.newOptionalBinder((Binder)binder, RubixHdfsInitializer.class).setDefault().to(DefaultRubixHdfsInitializer.class).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)binder, DynamicConfigurationProvider.class).addBinding().to(RubixConfigurationInitializer.class).in(Scopes.SINGLETON);
    }

    private static class RubixStarter {
        @Inject
        private RubixStarter(RubixInitializer rubixInitializer, Set<DynamicConfigurationProvider> configProviders) {
            Preconditions.checkArgument((configProviders.size() == 1 ? 1 : 0) != 0, (Object)"Rubix cache does not work with dynamic configuration providers");
            rubixInitializer.initializeRubix();
        }
    }

    @VisibleForTesting
    static class DefaultRubixHdfsInitializer
    implements RubixHdfsInitializer {
        private static final String RUBIX_DISTRIBUTED_FS_CLASS_NAME = CachingPrestoDistributedFileSystem.class.getName();
        private final boolean hdfsImpersonationEnabled;

        @Inject
        public DefaultRubixHdfsInitializer(HdfsAuthenticationConfig authenticationConfig) {
            this.hdfsImpersonationEnabled = Objects.requireNonNull(authenticationConfig, "authenticationConfig is null").isHdfsImpersonationEnabled();
        }

        @Override
        public void initializeConfiguration(Configuration config) {
            Preconditions.checkArgument((!this.hdfsImpersonationEnabled ? 1 : 0) != 0, (Object)"HDFS impersonation is not compatible with Hive caching");
            config.set("fs.hdfs.impl", RUBIX_DISTRIBUTED_FS_CLASS_NAME);
        }
    }
}

