/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hdfs;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.storage.Storage;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import io.airlift.log.Logger;
import io.opentelemetry.api.OpenTelemetry;
import io.trino.hadoop.HadoopNative;
import io.trino.hdfs.FileSystemFinalizerService;
import io.trino.hdfs.FileSystemUtils;
import io.trino.hdfs.HdfsConfig;
import io.trino.hdfs.HdfsConfiguration;
import io.trino.hdfs.HdfsContext;
import io.trino.hdfs.OpenTelemetryAwareFileSystem;
import io.trino.hdfs.TrinoFileSystemCache;
import io.trino.hdfs.authentication.GenericExceptionAction;
import io.trino.hdfs.authentication.HdfsAuthentication;
import io.trino.hdfs.gcs.GcsStorageFactory;
import io.trino.spi.Plugin;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.security.ConnectorIdentity;
import jakarta.annotation.PreDestroy;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemCache;
import org.apache.hadoop.fs.FileSystemManager;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;

public class HdfsEnvironment {
    private static final Logger log;
    private final OpenTelemetry openTelemetry;
    private final HdfsConfiguration hdfsConfiguration;
    private final HdfsAuthentication hdfsAuthentication;
    private final Optional<FsPermission> newDirectoryPermissions;
    private final boolean newFileInheritOwnership;
    private final boolean verifyChecksum;
    private final Optional<GcsStorageFactory> gcsStorageFactory;

    @VisibleForTesting
    public HdfsEnvironment(HdfsConfiguration hdfsConfiguration, HdfsConfig config, HdfsAuthentication hdfsAuthentication) {
        this(OpenTelemetry.noop(), hdfsConfiguration, config, hdfsAuthentication, Optional.empty());
    }

    @Inject
    public HdfsEnvironment(OpenTelemetry openTelemetry, HdfsConfiguration hdfsConfiguration, HdfsConfig config, HdfsAuthentication hdfsAuthentication, Optional<GcsStorageFactory> gcsStorageFactory) {
        this.openTelemetry = Objects.requireNonNull(openTelemetry, "openTelemetry is null");
        this.hdfsConfiguration = Objects.requireNonNull(hdfsConfiguration, "hdfsConfiguration is null");
        this.newFileInheritOwnership = config.isNewFileInheritOwnership();
        this.verifyChecksum = config.isVerifyChecksum();
        this.hdfsAuthentication = Objects.requireNonNull(hdfsAuthentication, "hdfsAuthentication is null");
        this.newDirectoryPermissions = config.getNewDirectoryFsPermissions();
        this.gcsStorageFactory = Objects.requireNonNull(gcsStorageFactory, "gcsStorageFactory is null");
    }

    @PreDestroy
    public void shutdown() throws IOException {
        if (!this.getClass().getClassLoader().equals(Plugin.class.getClassLoader())) {
            FileSystemFinalizerService.shutdown();
            HdfsEnvironment.stopFileSystemStatsThread();
            TrinoFileSystemCache.INSTANCE.closeAll();
        }
    }

    public Configuration getConfiguration(HdfsContext context, Path path) {
        return this.hdfsConfiguration.getConfiguration(context, path.toUri());
    }

    public FileSystem getFileSystem(HdfsContext context, Path path) throws IOException {
        return this.getFileSystem(context.getIdentity(), path, this.getConfiguration(context, path));
    }

    public FileSystem getFileSystem(ConnectorIdentity identity, Path path, Configuration configuration) throws IOException {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.getClass().getClassLoader());){
            FileSystem fileSystem = this.hdfsAuthentication.doAs(identity, () -> {
                FileSystem fileSystem = path.getFileSystem(configuration);
                fileSystem.setVerifyChecksum(this.verifyChecksum);
                FileSystem patt0$temp = FileSystemUtils.getRawFileSystem(fileSystem);
                if (patt0$temp instanceof OpenTelemetryAwareFileSystem) {
                    OpenTelemetryAwareFileSystem fs = (OpenTelemetryAwareFileSystem)patt0$temp;
                    fs.setOpenTelemetry(this.openTelemetry);
                }
                return fileSystem;
            });
            return fileSystem;
        }
    }

    public Optional<FsPermission> getNewDirectoryPermissions() {
        return this.newDirectoryPermissions;
    }

    public boolean isNewFileInheritOwnership() {
        return this.newFileInheritOwnership;
    }

    public <R, E extends Exception> R doAs(ConnectorIdentity identity, GenericExceptionAction<R, E> action) throws E {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.getClass().getClassLoader());){
            R r = this.hdfsAuthentication.doAs(identity, action);
            return r;
        }
    }

    public Storage createGcsStorage(HdfsContext context, Path path) {
        return this.gcsStorageFactory.orElseThrow(() -> new IllegalStateException("GcsStorageFactory not set")).create(this, context, path);
    }

    private static void stopFileSystemStatsThread() {
        try {
            Field field = FileSystem.Statistics.class.getDeclaredField("STATS_DATA_CLEANER");
            field.setAccessible(true);
            ((Thread)field.get(null)).interrupt();
        }
        catch (ReflectiveOperationException | RuntimeException e) {
            log.error((Throwable)e, "Error stopping file system stats thread");
        }
    }

    static {
        HadoopNative.requireHadoopNative();
        FileSystemManager.registerCache((FileSystemCache)TrinoFileSystemCache.INSTANCE);
        log = Logger.get(HdfsEnvironment.class);
    }
}

