/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.hdfs;

import com.google.common.base.Preconditions;
import io.airlift.stats.TimeStat;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoInput;
import io.trino.filesystem.TrinoInputFile;
import io.trino.filesystem.TrinoInputStream;
import io.trino.filesystem.hdfs.HadoopPaths;
import io.trino.filesystem.hdfs.HdfsFileSystem;
import io.trino.filesystem.hdfs.HdfsInput;
import io.trino.filesystem.hdfs.HdfsTrinoInputStream;
import io.trino.hdfs.CallStats;
import io.trino.hdfs.HdfsContext;
import io.trino.hdfs.HdfsEnvironment;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.time.Instant;
import java.util.Objects;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

class HdfsInputFile
implements TrinoInputFile {
    private final Location location;
    private final HdfsEnvironment environment;
    private final HdfsContext context;
    private final Path file;
    private final CallStats openFileCallStat;
    private Long length;
    private FileStatus status;

    public HdfsInputFile(Location location, Long length, HdfsEnvironment environment, HdfsContext context, CallStats openFileCallStat) {
        this.location = Objects.requireNonNull(location, "location is null");
        this.environment = Objects.requireNonNull(environment, "environment is null");
        this.context = Objects.requireNonNull(context, "context is null");
        this.openFileCallStat = Objects.requireNonNull(openFileCallStat, "openFileCallStat is null");
        this.file = HadoopPaths.hadoopPath(location);
        this.length = length;
        Preconditions.checkArgument((length == null || length >= 0L ? 1 : 0) != 0, (Object)"length is negative");
        location.verifyValidFileLocation();
    }

    public TrinoInput newInput() throws IOException {
        return new HdfsInput(this.openFile(), this);
    }

    public TrinoInputStream newStream() throws IOException {
        return new HdfsTrinoInputStream(this.location, this.openFile());
    }

    public long length() throws IOException {
        if (this.length == null) {
            this.length = this.lazyStatus().getLen();
        }
        return this.length;
    }

    public Instant lastModified() throws IOException {
        return Instant.ofEpochMilli(this.lazyStatus().getModificationTime());
    }

    public boolean exists() throws IOException {
        FileSystem fileSystem = this.environment.getFileSystem(this.context, this.file);
        return this.environment.doAs(this.context.getIdentity(), () -> fileSystem.exists(this.file));
    }

    public Location location() {
        return this.location;
    }

    public String toString() {
        return this.location().toString();
    }

    private FSDataInputStream openFile() throws IOException {
        this.openFileCallStat.newCall();
        FileSystem fileSystem = this.environment.getFileSystem(this.context, this.file);
        return this.environment.doAs(this.context.getIdentity(), () -> {
            FSDataInputStream fSDataInputStream;
            block9: {
                TimeStat.BlockTimer ignored = this.openFileCallStat.time();
                try {
                    fSDataInputStream = fileSystem.open(this.file);
                    if (ignored == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        this.openFileCallStat.recordException(e);
                        if (e instanceof FileNotFoundException) {
                            throw HdfsFileSystem.withCause(new FileNotFoundException(this.toString()), e);
                        }
                        throw new IOException("Open file %s failed: %s".formatted(this.location, e.getMessage()), e);
                    }
                }
                ignored.close();
            }
            return fSDataInputStream;
        });
    }

    private FileStatus lazyStatus() throws IOException {
        if (this.status == null) {
            FileSystem fileSystem = this.environment.getFileSystem(this.context, this.file);
            try {
                this.status = this.environment.doAs(this.context.getIdentity(), () -> fileSystem.getFileStatus(this.file));
            }
            catch (FileNotFoundException e) {
                throw HdfsFileSystem.withCause(new FileNotFoundException(this.toString()), e);
            }
            catch (IOException e) {
                throw new IOException("Get status for file %s failed: %s".formatted(this.location, e.getMessage()), e);
            }
        }
        return this.status;
    }
}

