/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hdfs.authentication;

import io.trino.hdfs.authentication.ForHdfs;
import io.trino.hdfs.authentication.GenericExceptionAction;
import io.trino.hdfs.authentication.HadoopAuthentication;
import io.trino.hdfs.authentication.HdfsAuthentication;
import io.trino.hdfs.authentication.UserGroupInformationUtils;
import io.trino.hdfs.authentication.UserNameProvider;
import io.trino.spi.security.ConnectorIdentity;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.hadoop.security.UserGroupInformation;

public class ImpersonatingHdfsAuthentication
implements HdfsAuthentication {
    private final HadoopAuthentication hadoopAuthentication;
    private final UserNameProvider userNameProvider;

    @Inject
    public ImpersonatingHdfsAuthentication(@ForHdfs HadoopAuthentication hadoopAuthentication, @ForHdfs UserNameProvider userNameProvider) {
        this.hadoopAuthentication = Objects.requireNonNull(hadoopAuthentication);
        this.userNameProvider = Objects.requireNonNull(userNameProvider);
    }

    @Override
    public <R, E extends Exception> R doAs(ConnectorIdentity identity, GenericExceptionAction<R, E> action) throws E {
        return UserGroupInformationUtils.executeActionInDoAs(this.createProxyUser(this.userNameProvider.get(identity)), action);
    }

    private UserGroupInformation createProxyUser(String user) {
        return UserGroupInformation.createProxyUser((String)user, (UserGroupInformation)this.hadoopAuthentication.getUserGroupInformation());
    }
}

