/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hdfs.authentication;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.LegacyConfig;
import io.airlift.configuration.validation.FileExists;
import java.util.Optional;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.NotNull;

public class HdfsKerberosConfig {
    private String hdfsTrinoPrincipal;
    private String hdfsTrinoKeytab;
    private String hdfsTrinoCredentialCacheLocation;

    @NotNull
    public String getHdfsTrinoPrincipal() {
        return this.hdfsTrinoPrincipal;
    }

    @Config(value="hive.hdfs.trino.principal")
    @LegacyConfig(value={"hive.hdfs.presto.principal"})
    @ConfigDescription(value="Trino principal used to access HDFS")
    public HdfsKerberosConfig setHdfsTrinoPrincipal(String hdfsTrinoPrincipal) {
        this.hdfsTrinoPrincipal = hdfsTrinoPrincipal;
        return this;
    }

    public @NotNull Optional<@FileExists String> getHdfsTrinoKeytab() {
        return Optional.ofNullable(this.hdfsTrinoKeytab);
    }

    @Config(value="hive.hdfs.trino.keytab")
    @LegacyConfig(value={"hive.hdfs.presto.keytab"})
    @ConfigDescription(value="Trino keytab used to access HDFS")
    public HdfsKerberosConfig setHdfsTrinoKeytab(String hdfsTrinoKeytab) {
        this.hdfsTrinoKeytab = hdfsTrinoKeytab;
        return this;
    }

    public @NotNull Optional<@FileExists String> getHdfsTrinoCredentialCacheLocation() {
        return Optional.ofNullable(this.hdfsTrinoCredentialCacheLocation);
    }

    @Config(value="hive.hdfs.trino.credential-cache.location")
    @ConfigDescription(value="Trino credential-cache location used to access HDFS")
    public HdfsKerberosConfig setHdfsTrinoCredentialCacheLocation(String hdfsTrinoCredentialCacheLocation) {
        this.hdfsTrinoCredentialCacheLocation = hdfsTrinoCredentialCacheLocation;
        return this;
    }

    @AssertTrue(message="Exactly one of `hive.hdfs.trino.keytab` or `hive.hdfs.trino.credential-cache.location` must be specified")
    public @AssertTrue(message="Exactly one of `hive.hdfs.trino.keytab` or `hive.hdfs.trino.credential-cache.location` must be specified") boolean isConfigValid() {
        return this.getHdfsTrinoKeytab().isPresent() ^ this.getHdfsTrinoCredentialCacheLocation().isPresent();
    }
}

