/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hdfs;

import io.trino.hadoop.HadoopNative;
import io.trino.hdfs.HdfsConfig;
import io.trino.hdfs.HdfsConfiguration;
import io.trino.hdfs.HdfsContext;
import io.trino.hdfs.TrinoFileSystemCache;
import io.trino.hdfs.authentication.GenericExceptionAction;
import io.trino.hdfs.authentication.HdfsAuthentication;
import io.trino.spi.security.ConnectorIdentity;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemCache;
import org.apache.hadoop.fs.FileSystemManager;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;

public class HdfsEnvironment {
    private final HdfsConfiguration hdfsConfiguration;
    private final HdfsAuthentication hdfsAuthentication;
    private final Optional<FsPermission> newDirectoryPermissions;
    private final boolean newFileInheritOwnership;
    private final boolean verifyChecksum;

    @Inject
    public HdfsEnvironment(HdfsConfiguration hdfsConfiguration, HdfsConfig config, HdfsAuthentication hdfsAuthentication) {
        this.hdfsConfiguration = Objects.requireNonNull(hdfsConfiguration, "hdfsConfiguration is null");
        this.newFileInheritOwnership = config.isNewFileInheritOwnership();
        this.verifyChecksum = config.isVerifyChecksum();
        this.hdfsAuthentication = Objects.requireNonNull(hdfsAuthentication, "hdfsAuthentication is null");
        this.newDirectoryPermissions = config.getNewDirectoryFsPermissions();
    }

    public Configuration getConfiguration(HdfsContext context, Path path) {
        return this.hdfsConfiguration.getConfiguration(context, path.toUri());
    }

    public FileSystem getFileSystem(HdfsContext context, Path path) throws IOException {
        return this.getFileSystem(context.getIdentity(), path, this.getConfiguration(context, path));
    }

    public FileSystem getFileSystem(ConnectorIdentity identity, Path path, Configuration configuration) throws IOException {
        return this.hdfsAuthentication.doAs(identity, () -> {
            FileSystem fileSystem = path.getFileSystem(configuration);
            fileSystem.setVerifyChecksum(this.verifyChecksum);
            return fileSystem;
        });
    }

    public Optional<FsPermission> getNewDirectoryPermissions() {
        return this.newDirectoryPermissions;
    }

    public boolean isNewFileInheritOwnership() {
        return this.newFileInheritOwnership;
    }

    public <R, E extends Exception> R doAs(ConnectorIdentity identity, GenericExceptionAction<R, E> action) throws E {
        return this.hdfsAuthentication.doAs(identity, action);
    }

    public void doAs(ConnectorIdentity identity, Runnable action) {
        this.hdfsAuthentication.doAs(identity, action);
    }

    static {
        HadoopNative.requireHadoopNative();
        FileSystemManager.registerCache((FileSystemCache)TrinoFileSystemCache.INSTANCE);
    }
}

