/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hdfs;

import com.google.common.collect.ImmutableSet;
import io.trino.hadoop.ConfigurationInstantiator;
import io.trino.hdfs.ConfigurationUtils;
import io.trino.hdfs.DynamicConfigurationProvider;
import io.trino.hdfs.HdfsConfiguration;
import io.trino.hdfs.HdfsConfigurationInitializer;
import io.trino.hdfs.HdfsContext;
import java.net.URI;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;

public class DynamicHdfsConfiguration
implements HdfsConfiguration {
    private static final Configuration INITIAL_CONFIGURATION = ConfigurationUtils.getInitialConfiguration();
    private final ThreadLocal<Configuration> hadoopConfiguration = new ThreadLocal<Configuration>(){

        @Override
        protected Configuration initialValue() {
            Configuration configuration = ConfigurationInstantiator.newEmptyConfiguration();
            ConfigurationUtils.copy(INITIAL_CONFIGURATION, configuration);
            DynamicHdfsConfiguration.this.initializer.initializeConfiguration(configuration);
            return configuration;
        }
    };
    private final HdfsConfigurationInitializer initializer;
    private final Set<DynamicConfigurationProvider> dynamicProviders;

    @Inject
    public DynamicHdfsConfiguration(HdfsConfigurationInitializer initializer, Set<DynamicConfigurationProvider> dynamicProviders) {
        this.initializer = Objects.requireNonNull(initializer, "initializer is null");
        this.dynamicProviders = ImmutableSet.copyOf((Collection)Objects.requireNonNull(dynamicProviders, "dynamicProviders is null"));
    }

    @Override
    public Configuration getConfiguration(HdfsContext context, URI uri) {
        if (this.dynamicProviders.isEmpty()) {
            return this.hadoopConfiguration.get();
        }
        Configuration config = ConfigurationUtils.copy(this.hadoopConfiguration.get());
        for (DynamicConfigurationProvider provider : this.dynamicProviders) {
            provider.updateConfiguration(config, context, uri);
        }
        return config;
    }
}

