/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.functions.python;

import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.trino.plugin.base.util.JsonTypeUtil;
import io.trino.plugin.functions.python.TimeZoneOffset;
import io.trino.plugin.functions.python.TrinoType;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.ArrayValueBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.MapValueBuilder;
import io.trino.spi.block.RowValueBuilder;
import io.trino.spi.block.SqlMap;
import io.trino.spi.block.SqlRow;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Int128;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.LongTimeWithTimeZone;
import io.trino.spi.type.LongTimestamp;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeWithTimeZoneType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Timestamps;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeUtils;
import io.trino.spi.type.VarcharType;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Objects;

final class TrinoTypes {
    private TrinoTypes() {
    }

    public static void validateReturnType(Type type) {
        Type type2 = type;
        Objects.requireNonNull(type2);
        Type type3 = type2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RowType.class, ArrayType.class, MapType.class, VarcharType.class}, (Type)type3, n)) {
            case 0: {
                RowType rowType = (RowType)type3;
                for (RowType.Field field : rowType.getFields()) {
                    TrinoTypes.validateReturnType(field.getType());
                }
                break;
            }
            case 1: {
                ArrayType arrayType = (ArrayType)type3;
                TrinoTypes.validateReturnType(arrayType.getElementType());
                break;
            }
            case 2: {
                MapType mapType = (MapType)type3;
                TrinoTypes.validateReturnType(mapType.getKeyType());
                TrinoTypes.validateReturnType(mapType.getValueType());
                break;
            }
            case 3: {
                VarcharType varcharType = (VarcharType)type3;
                if (varcharType.isUnbounded()) break;
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Type VARCHAR(x) not supported as return type. Use VARCHAR instead.");
            }
        }
    }

    public static Slice toRowTypeDescriptor(List<Type> types) {
        if (types.isEmpty()) {
            DynamicSliceOutput output = new DynamicSliceOutput(8);
            output.writeInt(TrinoType.ROW.id());
            output.writeInt(0);
            return output.slice();
        }
        return TrinoTypes.toTypeDescriptor((Type)RowType.anonymous(types));
    }

    public static Slice toTypeDescriptor(Type type) {
        DynamicSliceOutput output = new DynamicSliceOutput(64);
        TrinoTypes.toTypeDescriptor(type, (SliceOutput)output);
        return output.slice();
    }

    private static void toTypeDescriptor(Type type, SliceOutput output) {
        Type type2 = type;
        Objects.requireNonNull(type2);
        Type type3 = type2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RowType.class, ArrayType.class, MapType.class}, (Type)type3, n)) {
            case 0: {
                RowType rowType = (RowType)type3;
                output.writeInt(TrinoType.ROW.id());
                output.writeInt(rowType.getFields().size());
                for (RowType.Field field : rowType.getFields()) {
                    TrinoTypes.toTypeDescriptor(field.getType(), output);
                }
                break;
            }
            case 1: {
                ArrayType arrayType = (ArrayType)type3;
                output.writeInt(TrinoType.ARRAY.id());
                TrinoTypes.toTypeDescriptor(arrayType.getElementType(), output);
                break;
            }
            case 2: {
                MapType mapType = (MapType)type3;
                output.writeInt(TrinoType.MAP.id());
                TrinoTypes.toTypeDescriptor(mapType.getKeyType(), output);
                TrinoTypes.toTypeDescriptor(mapType.getValueType(), output);
                break;
            }
            default: {
                output.writeInt(TrinoTypes.singletonType(type).id());
            }
        }
    }

    private static TrinoType singletonType(Type type) {
        return switch (type.getBaseName()) {
            case "boolean" -> TrinoType.BOOLEAN;
            case "bigint" -> TrinoType.BIGINT;
            case "integer" -> TrinoType.INTEGER;
            case "smallint" -> TrinoType.SMALLINT;
            case "tinyint" -> TrinoType.TINYINT;
            case "double" -> TrinoType.DOUBLE;
            case "real" -> TrinoType.REAL;
            case "decimal" -> TrinoType.DECIMAL;
            case "varchar" -> TrinoType.VARCHAR;
            case "varbinary" -> TrinoType.VARBINARY;
            case "date" -> TrinoType.DATE;
            case "time" -> TrinoType.TIME;
            case "time with time zone" -> TrinoType.TIME_WITH_TIME_ZONE;
            case "timestamp" -> TrinoType.TIMESTAMP;
            case "timestamp with time zone" -> TrinoType.TIMESTAMP_WITH_TIME_ZONE;
            case "interval year to month" -> TrinoType.INTERVAL_YEAR_TO_MONTH;
            case "interval day to second" -> TrinoType.INTERVAL_DAY_TO_SECOND;
            case "json" -> TrinoType.JSON;
            case "uuid" -> TrinoType.UUID;
            case "ipaddress" -> TrinoType.IPADDRESS;
            default -> throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported type: " + String.valueOf(type));
        };
    }

    public static Slice javaToBinary(List<Type> types, Object[] values) {
        DynamicSliceOutput output = new DynamicSliceOutput(64);
        output.writeByte(1);
        for (int i = 0; i < types.size(); ++i) {
            TrinoTypes.javaToBinary(types.get(i), values[i], (SliceOutput)output);
        }
        return output.slice();
    }

    private static void javaToBinary(Type type, Object value, SliceOutput output) {
        if (value == null) {
            output.writeByte(0);
            return;
        }
        output.writeByte(1);
        Type type2 = type;
        Objects.requireNonNull(type2);
        Type type3 = type2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RowType.class, ArrayType.class, MapType.class, DecimalType.class, TimeWithTimeZoneType.class, TimestampType.class, TimestampWithTimeZoneType.class}, (Type)type3, n)) {
            case 0: {
                RowType rowType = (RowType)type3;
                TrinoTypes.rowBlockToBinary((SqlRow)value, output, rowType);
                break;
            }
            case 1: {
                ArrayType arrayType = (ArrayType)type3;
                TrinoTypes.arrayBlockToBinary((Block)value, output, arrayType);
                break;
            }
            case 2: {
                MapType mapType = (MapType)type3;
                TrinoTypes.mapBlockToBinary((SqlMap)value, output, mapType);
                break;
            }
            case 3: {
                DecimalType decimalType = (DecimalType)type3;
                String decimalString = decimalType.isShort() ? Decimals.toString((long)((Long)value), (int)decimalType.getScale()) : Decimals.toString((Int128)((Int128)value), (int)decimalType.getScale());
                TrinoTypes.writeVariableSlice(Slices.utf8Slice((String)decimalString), output);
                break;
            }
            case 4: {
                TimeWithTimeZoneType timeType = (TimeWithTimeZoneType)type3;
                if (timeType.isShort()) {
                    long time = (Long)value;
                    output.writeLong(TrinoTypes.nanosToMicros(DateTimeEncoding.unpackTimeNanos((long)time)));
                    output.writeShort(DateTimeEncoding.unpackOffsetMinutes((long)time));
                    break;
                }
                LongTimeWithTimeZone time = (LongTimeWithTimeZone)value;
                output.writeLong(TrinoTypes.picosToMicros(time.getPicoseconds()));
                output.writeShort(time.getOffsetMinutes());
                break;
            }
            case 5: {
                TimestampType timestampType = (TimestampType)type3;
                output.writeLong(timestampType.isShort() ? (Long)value : TrinoTypes.timestampToMicros((LongTimestamp)value));
                break;
            }
            case 6: {
                TimestampWithTimeZoneType timestampType = (TimestampWithTimeZoneType)type3;
                if (timestampType.isShort()) {
                    long packed = (Long)value;
                    long millis = DateTimeEncoding.unpackMillisUtc((long)packed);
                    output.writeLong(millis * 1000L);
                    output.writeShort((int)TimeZoneOffset.zoneOffsetMinutes(millis, DateTimeEncoding.unpackZoneKey((long)packed).getKey()));
                    break;
                }
                LongTimestampWithTimeZone timestamp = (LongTimestampWithTimeZone)value;
                long micros = timestamp.getEpochMillis() * 1000L;
                output.writeLong(micros + TrinoTypes.picosToMicros(timestamp.getPicosOfMilli()));
                output.writeShort((int)TimeZoneOffset.zoneOffsetMinutes(timestamp.getEpochMillis(), timestamp.getTimeZoneKey()));
                break;
            }
            default: {
                TrinoTypes.javaToBinarySimple(type, value, output);
            }
        }
    }

    private static void javaToBinarySimple(Type type, Object value, SliceOutput output) {
        switch (type.getBaseName()) {
            case "boolean": {
                output.writeByte((Boolean)value != false ? 1 : 0);
                break;
            }
            case "bigint": {
                output.writeLong(((Long)value).longValue());
                break;
            }
            case "integer": {
                output.writeInt(Math.toIntExact((Long)value));
                break;
            }
            case "smallint": {
                output.writeShort(Math.toIntExact((Long)value));
                break;
            }
            case "tinyint": {
                output.writeByte(Math.toIntExact((Long)value));
                break;
            }
            case "double": {
                output.writeDouble(((Double)value).doubleValue());
                break;
            }
            case "real": {
                output.writeInt(Math.toIntExact((Long)value));
                break;
            }
            case "date": {
                output.writeInt(Math.toIntExact((Long)value));
                break;
            }
            case "time": {
                output.writeLong(TrinoTypes.picosToMicros((Long)value));
                break;
            }
            case "interval year to month": {
                output.writeInt(Math.toIntExact((Long)value));
                break;
            }
            case "interval day to second": {
                output.writeLong(((Long)value).longValue());
                break;
            }
            case "uuid": 
            case "ipaddress": {
                output.writeBytes((Slice)value);
                break;
            }
            case "varchar": 
            case "varbinary": 
            case "json": {
                TrinoTypes.writeVariableSlice((Slice)value, output);
                break;
            }
            default: {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported type: " + String.valueOf(type));
            }
        }
    }

    private static void blockToBinary(Type type, Block block, int position, SliceOutput output) {
        if (block.isNull(position)) {
            output.writeByte(0);
            return;
        }
        output.writeByte(1);
        Type type2 = type;
        Objects.requireNonNull(type2);
        Type type3 = type2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RowType.class, ArrayType.class, MapType.class, BooleanType.class, BigintType.class, IntegerType.class, SmallintType.class, TinyintType.class, DoubleType.class, RealType.class, DecimalType.class, DateType.class, TimeType.class, TimeWithTimeZoneType.class, TimestampType.class, TimestampWithTimeZoneType.class}, (Type)type3, n)) {
            case 0: {
                RowType rowType = (RowType)type3;
                TrinoTypes.rowBlockToBinary(rowType.getObject(block, position), output, rowType);
                break;
            }
            case 1: {
                ArrayType arrayType = (ArrayType)type3;
                TrinoTypes.arrayBlockToBinary(arrayType.getObject(block, position), output, arrayType);
                break;
            }
            case 2: {
                MapType mapType = (MapType)type3;
                TrinoTypes.mapBlockToBinary(mapType.getObject(block, position), output, mapType);
                break;
            }
            case 3: {
                BooleanType booleanType = (BooleanType)type3;
                output.writeBoolean(booleanType.getBoolean(block, position));
                break;
            }
            case 4: {
                BigintType bigintType = (BigintType)type3;
                output.writeLong(bigintType.getLong(block, position));
                break;
            }
            case 5: {
                IntegerType integerType = (IntegerType)type3;
                output.writeInt(integerType.getInt(block, position));
                break;
            }
            case 6: {
                SmallintType smallintType = (SmallintType)type3;
                output.writeShort((int)smallintType.getShort(block, position));
                break;
            }
            case 7: {
                TinyintType tinyintType = (TinyintType)type3;
                output.writeByte((int)tinyintType.getByte(block, position));
                break;
            }
            case 8: {
                DoubleType doubleType = (DoubleType)type3;
                output.writeDouble(doubleType.getDouble(block, position));
                break;
            }
            case 9: {
                RealType realType = (RealType)type3;
                output.writeFloat(realType.getFloat(block, position));
                break;
            }
            case 10: {
                DecimalType decimalType = (DecimalType)type3;
                String decimalString = decimalType.isShort() ? Decimals.toString((long)decimalType.getLong(block, position), (int)decimalType.getScale()) : Decimals.toString((Int128)((Int128)decimalType.getObject(block, position)), (int)decimalType.getScale());
                TrinoTypes.writeVariableSlice(Slices.utf8Slice((String)decimalString), output);
                break;
            }
            case 11: {
                DateType dateType = (DateType)type3;
                output.writeInt(dateType.getInt(block, position));
                break;
            }
            case 12: {
                TimeType timeType = (TimeType)type3;
                output.writeLong(TrinoTypes.picosToMicros(timeType.getLong(block, position)));
                break;
            }
            case 13: {
                TimeWithTimeZoneType timeType = (TimeWithTimeZoneType)type3;
                if (timeType.isShort()) {
                    long time = timeType.getLong(block, position);
                    output.writeLong(TrinoTypes.nanosToMicros(DateTimeEncoding.unpackTimeNanos((long)time)));
                    output.writeShort(DateTimeEncoding.unpackOffsetMinutes((long)time));
                    break;
                }
                LongTimeWithTimeZone time = (LongTimeWithTimeZone)timeType.getObject(block, position);
                output.writeLong(TrinoTypes.picosToMicros(time.getPicoseconds()));
                output.writeShort(time.getOffsetMinutes());
                break;
            }
            case 14: {
                TimestampType timestampType = (TimestampType)type3;
                output.writeLong(timestampType.isShort() ? timestampType.getLong(block, position) : TrinoTypes.timestampToMicros((LongTimestamp)timestampType.getObject(block, position)));
                break;
            }
            case 15: {
                TimestampWithTimeZoneType timestampType = (TimestampWithTimeZoneType)type3;
                if (timestampType.isShort()) {
                    long packed = timestampType.getLong(block, position);
                    long millis = DateTimeEncoding.unpackMillisUtc((long)packed);
                    output.writeLong(millis * 1000L);
                    output.writeShort((int)TimeZoneOffset.zoneOffsetMinutes(millis, DateTimeEncoding.unpackZoneKey((long)packed).getKey()));
                    break;
                }
                LongTimestampWithTimeZone timestamp = (LongTimestampWithTimeZone)timestampType.getObject(block, position);
                long micros = timestamp.getEpochMillis() * 1000L;
                output.writeLong(micros + TrinoTypes.picosToMicros(timestamp.getPicosOfMilli()));
                output.writeShort((int)TimeZoneOffset.zoneOffsetMinutes(timestamp.getEpochMillis(), timestamp.getTimeZoneKey()));
                break;
            }
            default: {
                TrinoTypes.blockToBinarySimple(type, block, position, output);
            }
        }
    }

    private static void blockToBinarySimple(Type type, Block block, int position, SliceOutput output) {
        switch (type.getBaseName()) {
            case "interval year to month": {
                output.writeInt(Math.toIntExact(type.getLong(block, position)));
                break;
            }
            case "interval day to second": {
                output.writeLong(type.getLong(block, position));
                break;
            }
            case "uuid": 
            case "ipaddress": {
                output.writeBytes(type.getSlice(block, position));
                break;
            }
            case "varchar": 
            case "varbinary": 
            case "json": {
                TrinoTypes.writeVariableSlice(type.getSlice(block, position), output);
                break;
            }
            default: {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported type: " + String.valueOf(type));
            }
        }
    }

    private static void rowBlockToBinary(SqlRow row, SliceOutput output, RowType rowType) {
        for (int i = 0; i < rowType.getFields().size(); ++i) {
            TrinoTypes.blockToBinary(((RowType.Field)rowType.getFields().get(i)).getType(), (Block)row.getUnderlyingFieldBlock(i), row.getUnderlyingFieldPosition(i), output);
        }
    }

    private static void arrayBlockToBinary(Block value, SliceOutput output, ArrayType arrayType) {
        ValueBlock array = value.getUnderlyingValueBlock();
        output.writeInt(array.getPositionCount());
        for (int i = 0; i < array.getPositionCount(); ++i) {
            TrinoTypes.blockToBinary(arrayType.getElementType(), (Block)array, i, output);
        }
    }

    private static void mapBlockToBinary(SqlMap map, SliceOutput output, MapType mapType) {
        output.writeInt(map.getSize());
        for (int i = 0; i < map.getSize(); ++i) {
            TrinoTypes.blockToBinary(mapType.getKeyType(), (Block)map.getUnderlyingKeyBlock(), map.getUnderlyingKeyPosition(i), output);
            TrinoTypes.blockToBinary(mapType.getValueType(), (Block)map.getUnderlyingValueBlock(), map.getUnderlyingValuePosition(i), output);
        }
    }

    public static Object binaryToJava(Type type, SliceInput input) {
        if (!input.readBoolean()) {
            return null;
        }
        Type type2 = type;
        Objects.requireNonNull(type2);
        Type type3 = type2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RowType.class, ArrayType.class, MapType.class, DecimalType.class, TimeType.class, TimeWithTimeZoneType.class, TimestampType.class, TimestampWithTimeZoneType.class}, (Type)type3, n)) {
            case 0 -> {
                RowType rowType = (RowType)type3;
                yield TrinoTypes.rowBinaryToJava(rowType, input);
            }
            case 1 -> {
                ArrayType arrayType = (ArrayType)type3;
                yield TrinoTypes.binaryArrayToJava(arrayType, input);
            }
            case 2 -> {
                MapType mapType = (MapType)type3;
                yield TrinoTypes.binaryMapToJava(mapType, input);
            }
            case 3 -> {
                DecimalType decimalType = (DecimalType)type3;
                BigDecimal decimal = new BigDecimal(input.readSlice(input.readInt()).toStringUtf8());
                if (decimalType.isShort()) {
                    yield Decimals.encodeShortScaledValue((BigDecimal)decimal, (int)decimalType.getScale(), (RoundingMode)RoundingMode.HALF_UP);
                }
                yield Decimals.encodeScaledValue((BigDecimal)decimal, (int)decimalType.getScale(), (RoundingMode)RoundingMode.HALF_UP);
            }
            case 4 -> {
                TimeType timeType = (TimeType)type3;
                long micros = TrinoTypes.roundMicros(input.readLong(), timeType.getPrecision()) % 86400000000L;
                yield micros * 1000000L;
            }
            case 5 -> {
                TimeWithTimeZoneType timeType = (TimeWithTimeZoneType)type3;
                long micros = TrinoTypes.roundMicros(input.readLong(), timeType.getPrecision()) % 86400000000L;
                short offset = input.readShort();
                if (timeType.isShort()) {
                    yield DateTimeEncoding.packTimeWithTimeZone((long)(micros * 1000L), (int)offset);
                }
                yield new LongTimeWithTimeZone(micros * 1000000L, (int)offset);
            }
            case 6 -> {
                TimestampType timestampType = (TimestampType)type3;
                long micros = TrinoTypes.roundMicros(input.readLong(), timestampType.getPrecision());
                if (timestampType.isShort()) {
                    yield micros;
                }
                yield new LongTimestamp(micros, 0);
            }
            case 7 -> {
                TimestampWithTimeZoneType timestampType = (TimestampWithTimeZoneType)type3;
                long micros = TrinoTypes.roundMicros(input.readLong(), timestampType.getPrecision());
                TimeZoneKey zoneKey = TimeZoneKey.getTimeZoneKeyForOffset((long)input.readShort());
                if (timestampType.isShort()) {
                    long millis = Timestamps.roundDiv((long)micros, (long)1000L);
                    yield DateTimeEncoding.packDateTimeWithZone((long)millis, (TimeZoneKey)zoneKey);
                }
                long millis = micros / 1000L;
                int picos = (int)(micros % 1000L) * 1000000;
                yield LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)millis, (int)picos, (TimeZoneKey)zoneKey);
            }
            default -> TrinoTypes.binaryToJavaSimple(type, input);
        };
    }

    private static Object rowBinaryToJava(RowType rowType, SliceInput input) {
        return RowValueBuilder.buildRowValue((RowType)rowType, fieldBuilders -> {
            for (int i = 0; i < rowType.getFields().size(); ++i) {
                Type fieldType = ((RowType.Field)rowType.getFields().get(i)).getType();
                Object value = TrinoTypes.binaryToJava(fieldType, input);
                TypeUtils.writeNativeValue((Type)fieldType, (BlockBuilder)((BlockBuilder)fieldBuilders.get(i)), (Object)value);
            }
        });
    }

    private static Object binaryArrayToJava(ArrayType arrayType, SliceInput input) {
        int count = input.readInt();
        return ArrayValueBuilder.buildArrayValue((ArrayType)arrayType, (int)count, builder -> {
            for (int i = 0; i < count; ++i) {
                Object element = TrinoTypes.binaryToJava(arrayType.getElementType(), input);
                TypeUtils.writeNativeValue((Type)arrayType.getElementType(), (BlockBuilder)builder, (Object)element);
            }
        });
    }

    private static Object binaryMapToJava(MapType mapType, SliceInput input) {
        int count = input.readInt();
        return MapValueBuilder.buildMapValue((MapType)mapType, (int)count, (keyBuilder, valueBuilder) -> {
            for (int i = 0; i < count; ++i) {
                Object key = TrinoTypes.binaryToJava(mapType.getKeyType(), input);
                Object value = TrinoTypes.binaryToJava(mapType.getValueType(), input);
                TypeUtils.writeNativeValue((Type)mapType.getKeyType(), (BlockBuilder)keyBuilder, (Object)key);
                TypeUtils.writeNativeValue((Type)mapType.getValueType(), (BlockBuilder)valueBuilder, (Object)value);
            }
        });
    }

    private static Object binaryToJavaSimple(Type type, SliceInput input) {
        return switch (type.getBaseName()) {
            case "boolean" -> input.readBoolean();
            case "bigint" -> Long.valueOf(input.readLong());
            case "integer" -> Long.valueOf(input.readInt());
            case "smallint" -> Long.valueOf(input.readShort());
            case "tinyint" -> Long.valueOf(input.readByte());
            case "double" -> Double.valueOf(input.readDouble());
            case "real" -> Long.valueOf(input.readInt());
            case "date" -> Long.valueOf(input.readInt());
            case "interval year to month" -> Long.valueOf(input.readInt());
            case "interval day to second" -> Long.valueOf(input.readLong());
            case "uuid", "ipaddress" -> input.readSlice(16);
            case "varchar", "varbinary" -> input.readSlice(input.readInt());
            case "json" -> TrinoTypes.toJson(input.readSlice(input.readInt()));
            default -> throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported type: " + String.valueOf(type));
        };
    }

    private static void writeVariableSlice(Slice value, SliceOutput output) {
        output.writeInt(value.length());
        output.writeBytes(value);
    }

    private static long roundMicros(long micros, int precision) {
        return precision < 6 ? Timestamps.round((long)micros, (int)(6 - precision)) : micros;
    }

    private static long nanosToMicros(long nanos) {
        return Timestamps.roundDiv((long)nanos, (long)1000L);
    }

    private static long picosToMicros(long picos) {
        return Timestamps.roundDiv((long)picos, (long)1000000L);
    }

    private static long timestampToMicros(LongTimestamp timestamp) {
        long micros = timestamp.getEpochMicros();
        if (timestamp.getPicosOfMicro() >= 500000) {
            ++micros;
        }
        return micros;
    }

    private static Slice toJson(Slice value) {
        try {
            return JsonTypeUtil.jsonParse((Slice)value);
        }
        catch (TrinoException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, "Python function returned invalid JSON value", (Throwable)e);
        }
    }
}

