/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.functions.python;

import io.trino.spi.type.TimeZoneKey;
import org.joda.time.DateTimeZone;

final class TimeZoneOffset {
    private static final DateTimeZone[] DATE_TIME_ZONES = new DateTimeZone[TimeZoneKey.MAX_TIME_ZONE_KEY + 1];
    private static final short[] FIXED_ZONE_OFFSET = new short[TimeZoneKey.MAX_TIME_ZONE_KEY + 1];
    private static final short VARIABLE_ZONE = Short.MAX_VALUE;

    private TimeZoneOffset() {
    }

    public static short zoneOffsetMinutes(long millis, short zoneKey) {
        if (FIXED_ZONE_OFFSET[zoneKey] == Short.MAX_VALUE) {
            return TimeZoneOffset.zoneOffsetMinutes(millis, DATE_TIME_ZONES[zoneKey]);
        }
        return FIXED_ZONE_OFFSET[zoneKey];
    }

    private static short zoneOffsetMinutes(long millis, DateTimeZone zone) {
        int value = zone.getOffset(millis) / 60000;
        if ((short)value != value) {
            throw new ArithmeticException("integer overflow");
        }
        return (short)value;
    }

    static {
        for (TimeZoneKey timeZoneKey : TimeZoneKey.getTimeZoneKeys()) {
            DateTimeZone zone;
            short zoneKey = timeZoneKey.getKey();
            TimeZoneOffset.DATE_TIME_ZONES[zoneKey] = zone = DateTimeZone.forID((String)timeZoneKey.getId());
            if (zone.isFixed() && zone.getOffset(0L) % 60000 == 0) {
                TimeZoneOffset.FIXED_ZONE_OFFSET[zoneKey] = TimeZoneOffset.zoneOffsetMinutes(0L, zone);
                continue;
            }
            TimeZoneOffset.FIXED_ZONE_OFFSET[zoneKey] = Short.MAX_VALUE;
        }
    }
}

