/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.functions.python;

import io.trino.plugin.functions.python.PythonEngine;
import io.trino.plugin.functions.python.TrinoTypes;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.LanguageFunctionEngine;
import io.trino.spi.function.ScalarFunctionAdapter;
import io.trino.spi.function.ScalarFunctionImplementation;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.type.Type;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

final class PythonFunctionEngine
implements LanguageFunctionEngine {
    private static final MethodHandle FACTORY_METHOD;
    private static final MethodHandle EXECUTE_METHOD;

    PythonFunctionEngine() {
    }

    public String getLanguage() {
        return "PYTHON";
    }

    public List<PropertyMetadata<?>> getFunctionProperties() {
        return List.of(PropertyMetadata.stringProperty((String)"handler", (String)"Name of the Python method to call", (String)"", (boolean)false));
    }

    public void validateScalarFunction(Type returnType, List<Type> argumentTypes, String definition, Map<String, Object> properties) {
        TrinoTypes.validateReturnType(returnType);
        String code = definition.stripIndent();
        String handler = (String)properties.get("handler");
        if (handler.isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_PROPERTY, "Property 'handler' is required");
        }
        try (PythonEngine engine = new PythonEngine(code);){
            engine.setup(returnType, argumentTypes, handler);
        }
    }

    public ScalarFunctionImplementation getScalarFunctionImplementation(Type returnType, List<Type> argumentTypes, String definition, Map<String, Object> properties, InvocationConvention invocationConvention) {
        String code = definition.stripIndent();
        String handler = (String)properties.get("handler");
        Supplier<Object> factory = () -> PythonFunctionEngine.createEngine(returnType, argumentTypes, code, handler);
        ArrayList types = new ArrayList();
        types.add(Object.class);
        for (Type type : argumentTypes) {
            types.add(type.getJavaType());
        }
        MethodType methodType = MethodType.methodType(returnType.getJavaType(), types).wrap();
        MethodHandle target = EXECUTE_METHOD.asCollector(1, Object[].class, argumentTypes.size()).asType(methodType);
        InvocationConvention callingConvention = new InvocationConvention(Collections.nCopies(argumentTypes.size(), InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE), InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, false, true);
        MethodHandle adapted = ScalarFunctionAdapter.adapt((MethodHandle)target, (Type)returnType, argumentTypes, (InvocationConvention)callingConvention, (InvocationConvention)invocationConvention);
        return ScalarFunctionImplementation.builder().methodHandle(adapted).instanceFactory(FACTORY_METHOD.bindTo(factory)).build();
    }

    private static PythonEngine createEngine(Type returnType, List<Type> argumentTypes, String code, String handler) {
        PythonEngine engine = new PythonEngine(code);
        engine.setup(returnType, argumentTypes, handler);
        return engine;
    }

    static {
        try {
            FACTORY_METHOD = MethodHandles.lookup().findVirtual(Supplier.class, "get", MethodType.methodType(Object.class));
            EXECUTE_METHOD = MethodHandles.lookup().findVirtual(PythonEngine.class, "execute", MethodType.methodType(Object.class, Object[].class));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

