/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.example;

import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.json.JsonModule;
import io.trino.plugin.example.ExampleConnector;
import io.trino.plugin.example.ExampleHandleResolver;
import io.trino.plugin.example.ExampleModule;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.ConnectorHandleResolver;
import java.util.Map;
import java.util.Objects;

public class ExampleConnectorFactory
implements ConnectorFactory {
    public String getName() {
        return "example-http";
    }

    public ConnectorHandleResolver getHandleResolver() {
        return new ExampleHandleResolver();
    }

    public Connector create(String catalogName, Map<String, String> requiredConfig, ConnectorContext context) {
        Objects.requireNonNull(requiredConfig, "requiredConfig is null");
        Bootstrap app = new Bootstrap(new Module[]{new JsonModule(), new ExampleModule(context.getTypeManager())});
        Injector injector = app.strictConfig().doNotInitializeLogging().setRequiredConfigurationProperties(requiredConfig).initialize();
        return (Connector)injector.getInstance(ExampleConnector.class);
    }
}

