/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.example;

import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteSource;
import com.google.common.io.Resources;
import io.trino.plugin.example.ExampleColumnHandle;
import io.trino.plugin.example.ExampleRecordCursor;
import io.trino.plugin.example.ExampleSplit;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.connector.RecordSet;
import io.trino.spi.type.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Objects;

public class ExampleRecordSet
implements RecordSet {
    private final List<ExampleColumnHandle> columnHandles;
    private final List<Type> columnTypes;
    private final ByteSource byteSource;

    public ExampleRecordSet(ExampleSplit split, List<ExampleColumnHandle> columnHandles) {
        Objects.requireNonNull(split, "split is null");
        this.columnHandles = Objects.requireNonNull(columnHandles, "column handles is null");
        ImmutableList.Builder types = ImmutableList.builder();
        for (ExampleColumnHandle column : columnHandles) {
            types.add((Object)column.getColumnType());
        }
        this.columnTypes = types.build();
        try {
            this.byteSource = Resources.asByteSource((URL)split.getUri().toURL());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public List<Type> getColumnTypes() {
        return this.columnTypes;
    }

    public RecordCursor cursor() {
        return new ExampleRecordCursor(this.columnHandles, this.byteSource);
    }
}

