/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.elasticsearch;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.plugin.elasticsearch.ElasticsearchTableHandle;
import io.trino.plugin.elasticsearch.client.ElasticsearchClient;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.VariableWidthBlockBuilder;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.SourcePage;
import io.trino.spi.type.VarcharType;
import java.io.IOException;
import java.util.Objects;

public class PassthroughQueryPageSource
implements ConnectorPageSource {
    private final long readTimeNanos;
    private final String result;
    private boolean done;

    public PassthroughQueryPageSource(ElasticsearchClient client, ElasticsearchTableHandle table) {
        Objects.requireNonNull(client, "client is null");
        Objects.requireNonNull(table, "table is null");
        long start = System.nanoTime();
        this.result = client.executeQuery(table.index(), table.query().get());
        this.readTimeNanos = System.nanoTime() - start;
    }

    public long getCompletedBytes() {
        return this.result.length();
    }

    public long getReadTimeNanos() {
        return this.readTimeNanos;
    }

    public boolean isFinished() {
        return this.done;
    }

    public SourcePage getNextSourcePage() {
        if (this.done) {
            return null;
        }
        this.done = true;
        Slice slice = Slices.utf8Slice((String)this.result);
        VariableWidthBlockBuilder column = VarcharType.VARCHAR.createBlockBuilder(null, 0, slice.length());
        VarcharType.VARCHAR.writeSlice((BlockBuilder)column, slice);
        return SourcePage.create((Block)column.build());
    }

    public long getMemoryUsage() {
        return 0L;
    }

    public void close() throws IOException {
    }
}

