/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.elasticsearch;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.SizeOf;
import io.trino.spi.HostAddress;
import io.trino.spi.connector.ConnectorSplit;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public record ElasticsearchSplit(String index, int shard, Optional<String> address) implements ConnectorSplit
{
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(ElasticsearchSplit.class);

    public ElasticsearchSplit {
        Objects.requireNonNull(index, "index is null");
        Objects.requireNonNull(address, "address is null");
    }

    public List<HostAddress> getAddresses() {
        return (List)this.address.map(host -> ImmutableList.of((Object)HostAddress.fromString((String)host))).orElseGet(ImmutableList::of);
    }

    public Map<String, String> getSplitInfo() {
        return ImmutableMap.builder().put((Object)"index", (Object)this.index).put((Object)"address", (Object)this.address.orElse("")).buildOrThrow();
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf((String)this.index) + SizeOf.sizeOf(this.address, SizeOf::estimatedSizeOf);
    }
}

