/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.elasticsearch;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.elasticsearch.DecoderDescriptor;
import io.trino.plugin.elasticsearch.client.IndexMetadata;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Objects;

public record ElasticsearchColumnHandle(List<String> path, Type type, IndexMetadata.Type elasticsearchType, DecoderDescriptor decoderDescriptor, boolean supportsPredicates) implements ColumnHandle
{
    public ElasticsearchColumnHandle {
        path = ImmutableList.copyOf(path);
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(elasticsearchType, "elasticsearchType is null");
        Objects.requireNonNull(decoderDescriptor, "decoderDescriptor is null");
    }

    @JsonIgnore
    public String name() {
        return Joiner.on((char)'.').join(this.path);
    }

    @Override
    public String toString() {
        return this.name() + "::" + String.valueOf(this.type());
    }
}

