/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.elasticsearch;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.trino.plugin.elasticsearch.client.ElasticsearchClient;
import io.trino.plugin.elasticsearch.client.ElasticsearchNode;
import io.trino.spi.Node;
import io.trino.spi.NodeManager;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.VariableWidthBlockBuilder;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.FixedPageSource;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class NodesSystemTable
implements SystemTable {
    private static final ConnectorTableMetadata METADATA = new ConnectorTableMetadata(new SchemaTableName("system", "nodes"), (List)ImmutableList.builder().add((Object)new ColumnMetadata("trino_node_id", (Type)VarcharType.createUnboundedVarcharType())).add((Object)new ColumnMetadata("trino_node_address", (Type)VarcharType.createUnboundedVarcharType())).add((Object)new ColumnMetadata("elasticsearch_node_id", (Type)VarcharType.createUnboundedVarcharType())).add((Object)new ColumnMetadata("elasticsearch_node_address", (Type)VarcharType.createUnboundedVarcharType())).build());
    private final ElasticsearchClient client;
    private final Node currentNode;

    @Inject
    public NodesSystemTable(NodeManager nodeManager, ElasticsearchClient client) {
        Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.client = Objects.requireNonNull(client, "client is null");
        this.currentNode = nodeManager.getCurrentNode();
    }

    public SystemTable.Distribution getDistribution() {
        return SystemTable.Distribution.ALL_NODES;
    }

    public ConnectorTableMetadata getTableMetadata() {
        return METADATA;
    }

    public ConnectorPageSource pageSource(ConnectorTransactionHandle transaction, ConnectorSession session, TupleDomain<Integer> constraint) {
        Set<ElasticsearchNode> nodes = this.client.getNodes();
        VariableWidthBlockBuilder nodeId = VarcharType.VARCHAR.createBlockBuilder(null, nodes.size());
        VariableWidthBlockBuilder trinoAddress = VarcharType.VARCHAR.createBlockBuilder(null, nodes.size());
        VariableWidthBlockBuilder elasticsearchNodeId = VarcharType.VARCHAR.createBlockBuilder(null, nodes.size());
        VariableWidthBlockBuilder elasticsearchAddress = VarcharType.VARCHAR.createBlockBuilder(null, nodes.size());
        for (ElasticsearchNode node : nodes) {
            VarcharType.VARCHAR.writeString((BlockBuilder)nodeId, this.currentNode.getNodeIdentifier());
            VarcharType.VARCHAR.writeString((BlockBuilder)trinoAddress, this.currentNode.getHostAndPort().toString());
            VarcharType.VARCHAR.writeString((BlockBuilder)elasticsearchNodeId, node.getId());
            if (node.getAddress().isPresent()) {
                VarcharType.VARCHAR.writeString((BlockBuilder)elasticsearchAddress, node.getAddress().get());
                continue;
            }
            elasticsearchAddress.appendNull();
        }
        return new FixedPageSource((List)ImmutableList.of((Object)new Page(new Block[]{nodeId.build(), trinoAddress.build(), elasticsearchNodeId.build(), elasticsearchAddress.build()})));
    }
}

