/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.elasticsearch.decoders;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.airlift.slice.Slices;
import io.trino.plugin.elasticsearch.DecoderDescriptor;
import io.trino.plugin.elasticsearch.decoders.Decoder;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.VarbinaryType;
import java.util.Base64;
import java.util.Objects;
import java.util.function.Supplier;
import org.elasticsearch.search.SearchHit;

public class VarbinaryDecoder
implements Decoder {
    private final String path;

    public VarbinaryDecoder(String path) {
        this.path = Objects.requireNonNull(path, "path is null");
    }

    @Override
    public void decode(SearchHit hit, Supplier<Object> getter, BlockBuilder output) {
        Object value = getter.get();
        if (value == null) {
            output.appendNull();
        } else if (value instanceof String) {
            VarbinaryType.VARBINARY.writeSlice(output, Slices.wrappedBuffer((byte[])Base64.getDecoder().decode(value.toString())));
        } else {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, String.format("Expected a string value for field '%s' of type VARBINARY: %s [%s]", this.path, value, value.getClass().getSimpleName()));
        }
    }

    public static class Descriptor
    implements DecoderDescriptor {
        private final String path;

        @JsonCreator
        public Descriptor(String path) {
            this.path = path;
        }

        @JsonProperty
        public String getPath() {
            return this.path;
        }

        @Override
        public Decoder createDecoder() {
            return new VarbinaryDecoder(this.path);
        }
    }
}

