/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.elasticsearch.decoders;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.elasticsearch.DecoderDescriptor;
import io.trino.plugin.elasticsearch.ScanQueryPageSource;
import io.trino.plugin.elasticsearch.decoders.Decoder;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.RowBlockBuilder;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.elasticsearch.search.SearchHit;

public class RowDecoder
implements Decoder {
    private final String path;
    private final List<String> fieldNames;
    private final List<Decoder> decoders;

    public RowDecoder(String path, List<String> fieldNames, List<Decoder> decoders) {
        this.path = Objects.requireNonNull(path, "path is null");
        this.fieldNames = fieldNames;
        this.decoders = decoders;
    }

    @Override
    public void decode(SearchHit hit, Supplier<Object> getter, BlockBuilder output) {
        Object data = getter.get();
        if (data == null) {
            output.appendNull();
        } else if (data instanceof Map) {
            ((RowBlockBuilder)output).buildEntry(fieldBuilders -> {
                for (int i = 0; i < this.decoders.size(); ++i) {
                    String field = this.fieldNames.get(i);
                    this.decoders.get(i).decode(hit, () -> ScanQueryPageSource.getField((Map)data, field), (BlockBuilder)fieldBuilders.get(i));
                }
            });
        } else {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, String.format("Expected object for field '%s' of type ROW: %s [%s]", this.path, data, data.getClass().getSimpleName()));
        }
    }

    public static class NameAndDescriptor {
        private final String name;
        private final DecoderDescriptor descriptor;

        @JsonCreator
        public NameAndDescriptor(String name, DecoderDescriptor descriptor) {
            this.name = name;
            this.descriptor = descriptor;
        }

        @JsonProperty
        public String getName() {
            return this.name;
        }

        @JsonProperty
        public DecoderDescriptor getDescriptor() {
            return this.descriptor;
        }
    }

    public static class Descriptor
    implements DecoderDescriptor {
        private final String path;
        private final List<NameAndDescriptor> fields;

        @JsonCreator
        public Descriptor(String path, List<NameAndDescriptor> fields) {
            this.path = path;
            this.fields = fields;
        }

        @JsonProperty
        public String getPath() {
            return this.path;
        }

        @JsonProperty
        public List<NameAndDescriptor> getFields() {
            return this.fields;
        }

        @Override
        public Decoder createDecoder() {
            return new RowDecoder(this.path, (List)this.fields.stream().map(NameAndDescriptor::getName).collect(ImmutableList.toImmutableList()), (List)this.fields.stream().map(field -> field.getDescriptor().createDecoder()).collect(ImmutableList.toImmutableList()));
        }
    }
}

