/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.elasticsearch.client;

import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import io.airlift.log.Logger;
import io.airlift.stats.TimeStat;
import io.trino.plugin.elasticsearch.ElasticsearchConfig;
import java.io.IOException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.FailsafeException;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import net.jodah.failsafe.event.ExecutionAttemptedEvent;
import net.jodah.failsafe.event.ExecutionCompletedEvent;
import net.jodah.failsafe.function.CheckedSupplier;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.rest.RestStatus;

public class BackpressureRestClient {
    private static final Logger log = Logger.get(BackpressureRestClient.class);
    private final RestClient delegate;
    private final RetryPolicy<Response> retryPolicy;
    private final TimeStat backpressureStats;
    private final ThreadLocal<Stopwatch> stopwatch = ThreadLocal.withInitial(Stopwatch::createUnstarted);

    public BackpressureRestClient(RestClient delegate, ElasticsearchConfig config, TimeStat backpressureStats) {
        this.delegate = Objects.requireNonNull(delegate, "restClient is null");
        this.backpressureStats = Objects.requireNonNull(backpressureStats, "backpressureStats is null");
        Objects.requireNonNull(config, "config is null");
        this.retryPolicy = (RetryPolicy)((RetryPolicy)((RetryPolicy)new RetryPolicy().withMaxAttempts(-1).withMaxDuration(Duration.ofMillis(config.getMaxRetryTime().toMillis())).withBackoff(config.getBackoffInitDelay().toMillis(), config.getBackoffMaxDelay().toMillis(), ChronoUnit.MILLIS).withJitter(0.125).handleIf(BackpressureRestClient::isBackpressure)).onFailedAttempt(this::onFailedAttempt).onSuccess(this::onComplete)).onFailure(this::onComplete);
    }

    public void setHosts(HttpHost ... hosts) {
        this.delegate.setHosts(hosts);
    }

    public Response performRequest(String method, String endpoint, Header ... headers) throws IOException {
        return this.executeWithRetries((CheckedSupplier<Response>)((CheckedSupplier)() -> this.delegate.performRequest(method, endpoint, headers)));
    }

    public Response performRequest(String method, String endpoint, Map<String, String> params, HttpEntity entity, Header ... headers) throws IOException {
        return this.executeWithRetries((CheckedSupplier<Response>)((CheckedSupplier)() -> this.delegate.performRequest(method, endpoint, params, entity, headers)));
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    private static boolean isBackpressure(Throwable throwable) {
        return throwable instanceof ResponseException && ((ResponseException)throwable).getResponse().getStatusLine().getStatusCode() == RestStatus.TOO_MANY_REQUESTS.getStatus();
    }

    private void onComplete(ExecutionCompletedEvent<Response> executionCompletedEvent) {
        if (this.stopwatch.get().isRunning()) {
            long delayMillis = this.stopwatch.get().elapsed(TimeUnit.MILLISECONDS);
            log.debug("Adding %s milliseconds to backpressure stats", new Object[]{delayMillis});
            this.stopwatch.get().reset();
            this.backpressureStats.add((double)delayMillis, TimeUnit.MILLISECONDS);
        }
    }

    private Response executeWithRetries(CheckedSupplier<Response> supplier) throws IOException {
        try {
            return (Response)Failsafe.with((Policy[])new RetryPolicy[]{this.retryPolicy}).get(supplier);
        }
        catch (FailsafeException e) {
            Throwable throwable = e.getCause();
            Throwables.throwIfInstanceOf((Throwable)throwable, IOException.class);
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new RuntimeException("Unexpected cause from FailsafeException", throwable);
        }
    }

    private void onFailedAttempt(ExecutionAttemptedEvent<Response> executionAttemptedEvent) {
        log.debug("REST attempt failed: %s", new Object[]{executionAttemptedEvent.getLastFailure()});
        if (!this.stopwatch.get().isRunning()) {
            this.stopwatch.get().start();
        }
    }
}

