/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.elasticsearch;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import io.trino.spi.HostAddress;
import io.trino.spi.connector.ConnectorSplit;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openjdk.jol.info.ClassLayout;

public class ElasticsearchSplit
implements ConnectorSplit {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(ElasticsearchSplit.class).instanceSize();
    private final String index;
    private final int shard;
    private final Optional<String> address;

    @JsonCreator
    public ElasticsearchSplit(@JsonProperty(value="index") String index, @JsonProperty(value="shard") int shard, @JsonProperty(value="address") Optional<String> address) {
        this.index = Objects.requireNonNull(index, "index is null");
        this.shard = shard;
        this.address = Objects.requireNonNull(address, "address is null");
    }

    @JsonProperty
    public String getIndex() {
        return this.index;
    }

    @JsonProperty
    public int getShard() {
        return this.shard;
    }

    @JsonProperty
    public Optional<String> getAddress() {
        return this.address;
    }

    public boolean isRemotelyAccessible() {
        return true;
    }

    public List<HostAddress> getAddresses() {
        return (List)this.address.map(host -> ImmutableList.of((Object)HostAddress.fromString((String)host))).orElseGet(ImmutableList::of);
    }

    public Object getInfo() {
        return this;
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf((String)this.index) + SizeOf.sizeOf(this.address, SizeOf::estimatedSizeOf);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("index", (Object)this.index).add("shard", this.shard).toString();
    }
}

