/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.elasticsearch.decoders;

import io.airlift.slice.Slices;
import io.trino.plugin.elasticsearch.decoders.Decoder;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.VarcharType;
import java.util.Objects;
import java.util.function.Supplier;
import org.elasticsearch.search.SearchHit;

public class VarcharDecoder
implements Decoder {
    private final String path;

    public VarcharDecoder(String path) {
        this.path = Objects.requireNonNull(path, "path is null");
    }

    @Override
    public void decode(SearchHit hit, Supplier<Object> getter, BlockBuilder output) {
        Object value = getter.get();
        if (value == null) {
            output.appendNull();
        } else if (value instanceof String || value instanceof Number) {
            VarcharType.VARCHAR.writeSlice(output, Slices.utf8Slice((String)value.toString()));
        } else {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, String.format("Expected a string or numeric value for field '%s' of type VARCHAR: %s [%s]", this.path, value, value.getClass().getSimpleName()));
        }
    }
}

