/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.elasticsearch.decoders;

import io.trino.plugin.elasticsearch.decoders.Decoder;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.TimestampType;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.function.Supplier;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.search.SearchHit;

public class TimestampDecoder
implements Decoder {
    private final String path;

    public TimestampDecoder(String path) {
        this.path = Objects.requireNonNull(path, "path is null");
    }

    @Override
    public void decode(SearchHit hit, Supplier<Object> getter, BlockBuilder output) {
        DocumentField documentField = (DocumentField)hit.getFields().get(this.path);
        Object value = null;
        if (documentField != null) {
            if (documentField.getValues().size() > 1) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, String.format("Expected single value for column '%s', found: %s", this.path, documentField.getValues().size()));
            }
            value = documentField.getValue();
        } else {
            value = getter.get();
        }
        if (value == null) {
            output.appendNull();
        } else {
            LocalDateTime timestamp;
            if (value instanceof String) {
                timestamp = DateTimeFormatter.ISO_DATE_TIME.parse((CharSequence)((String)value), LocalDateTime::from);
            } else if (value instanceof Number) {
                timestamp = LocalDateTime.ofInstant(Instant.ofEpochMilli(((Number)value).longValue()), ZoneOffset.UTC);
            } else {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported representation for field '%s' of type TIMESTAMP: %s [%s]", this.path, value, value.getClass().getSimpleName()));
            }
            long epochMicros = timestamp.atOffset(ZoneOffset.UTC).toInstant().toEpochMilli() * 1000L;
            TimestampType.TIMESTAMP_MILLIS.writeLong(output, epochMicros);
        }
    }
}

