/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.elasticsearch.decoders;

import io.trino.plugin.elasticsearch.decoders.Decoder;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.RealType;
import java.util.Objects;
import java.util.function.Supplier;
import org.elasticsearch.search.SearchHit;

public class RealDecoder
implements Decoder {
    private final String path;

    public RealDecoder(String path) {
        this.path = Objects.requireNonNull(path, "path is null");
    }

    @Override
    public void decode(SearchHit hit, Supplier<Object> getter, BlockBuilder output) {
        float decoded;
        Object value = getter.get();
        if (value == null) {
            output.appendNull();
            return;
        }
        if (value instanceof Number) {
            decoded = ((Number)value).floatValue();
        } else if (value instanceof String) {
            try {
                decoded = Float.parseFloat((String)value);
            }
            catch (NumberFormatException e) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, String.format("Cannot parse value for field '%s' as REAL: %s", this.path, value));
            }
        } else {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, String.format("Expected a numeric value for field %s of type REAL: %s [%s]", this.path, value, value.getClass().getSimpleName()));
        }
        RealType.REAL.writeLong(output, (long)Float.floatToRawIntBits(decoded));
    }
}

