/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.elasticsearch.decoders;

import io.trino.plugin.elasticsearch.decoders.Decoder;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.DoubleType;
import java.util.Objects;
import java.util.function.Supplier;
import org.elasticsearch.search.SearchHit;

public class DoubleDecoder
implements Decoder {
    private final String path;

    public DoubleDecoder(String path) {
        this.path = Objects.requireNonNull(path, "path is null");
    }

    @Override
    public void decode(SearchHit hit, Supplier<Object> getter, BlockBuilder output) {
        double decoded;
        Object value = getter.get();
        if (value == null) {
            output.appendNull();
            return;
        }
        if (value instanceof Number) {
            decoded = ((Number)value).doubleValue();
        } else if (value instanceof String) {
            try {
                decoded = Double.parseDouble((String)value);
            }
            catch (NumberFormatException e) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, String.format("Cannot parse value for field '%s' as DOUBLE: %s", this.path, value));
            }
        } else {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, String.format("Expected a numeric value for field %s of type DOUBLE: %s [%s]", this.path, value, value.getClass().getSimpleName()));
        }
        DoubleType.DOUBLE.writeDouble(output, decoded);
    }
}

