/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.elasticsearch.decoders;

import io.trino.plugin.elasticsearch.decoders.Decoder;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.BigintType;
import java.util.Objects;
import java.util.function.Supplier;
import org.elasticsearch.search.SearchHit;

public class BigintDecoder
implements Decoder {
    private final String path;

    public BigintDecoder(String path) {
        this.path = Objects.requireNonNull(path, "path is null");
    }

    @Override
    public void decode(SearchHit hit, Supplier<Object> getter, BlockBuilder output) {
        Object value = getter.get();
        if (value == null) {
            output.appendNull();
        } else if (value instanceof Number) {
            BigintType.BIGINT.writeLong(output, ((Number)value).longValue());
        } else if (value instanceof String) {
            try {
                BigintType.BIGINT.writeLong(output, Long.parseLong((String)value));
            }
            catch (NumberFormatException e) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, String.format("Cannot parse value for field '%s' as BIGINT: %s", this.path, value));
            }
        } else {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, String.format("Expected a numeric value for field '%s' of type BIGINT: %s [%s]", this.path, value, value.getClass().getSimpleName()));
        }
    }
}

