/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.elasticsearch.decoders;

import io.trino.plugin.elasticsearch.decoders.Decoder;
import io.trino.spi.block.BlockBuilder;
import java.util.List;
import java.util.function.Supplier;
import org.elasticsearch.search.SearchHit;

public class ArrayDecoder
implements Decoder {
    private final Decoder elementDecoder;

    public ArrayDecoder(Decoder elementDecoder) {
        this.elementDecoder = elementDecoder;
    }

    @Override
    public void decode(SearchHit hit, Supplier<Object> getter, BlockBuilder output) {
        Object data = getter.get();
        if (data == null) {
            output.appendNull();
        } else if (data instanceof List) {
            BlockBuilder array = output.beginBlockEntry();
            ((List)data).forEach(element -> this.elementDecoder.decode(hit, () -> element, array));
            output.closeEntry();
        } else {
            BlockBuilder array = output.beginBlockEntry();
            this.elementDecoder.decode(hit, () -> data, array);
            output.closeEntry();
        }
    }
}

