/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.elasticsearch.client;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class NodesResponse {
    private final Map<String, Node> nodes;

    @JsonCreator
    public NodesResponse(@JsonProperty(value="nodes") Map<String, Node> nodes) {
        Objects.requireNonNull(nodes, "nodes is null");
        this.nodes = ImmutableMap.copyOf(nodes);
    }

    public Map<String, Node> getNodes() {
        return this.nodes;
    }

    public static class Http {
        private final String address;

        @JsonCreator
        public Http(@JsonProperty(value="publish_address") String address) {
            this.address = address;
        }

        public String getAddress() {
            return this.address;
        }

        public String toString() {
            return this.address;
        }
    }

    public static class Node {
        private final Set<String> roles;
        private final Optional<Http> http;

        @JsonCreator
        public Node(@JsonProperty(value="roles") Set<String> roles, @JsonProperty(value="http") Optional<Http> http) {
            this.roles = ImmutableSet.copyOf(roles);
            this.http = Objects.requireNonNull(http, "http is null");
        }

        public Set<String> getRoles() {
            return this.roles;
        }

        public Optional<String> getAddress() {
            return this.http.map(Http::getAddress);
        }
    }
}

