/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.elasticsearch;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import io.airlift.slice.Slice;
import io.trino.plugin.elasticsearch.ElasticsearchColumnHandle;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.ExistsQueryBuilder;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;

public final class ElasticsearchQueryBuilder {
    private ElasticsearchQueryBuilder() {
    }

    public static QueryBuilder buildSearchQuery(TupleDomain<ElasticsearchColumnHandle> constraint, Optional<String> query) {
        BoolQueryBuilder queryBuilder = new BoolQueryBuilder();
        if (constraint.getDomains().isPresent()) {
            for (Map.Entry entry : ((Map)constraint.getDomains().get()).entrySet()) {
                ElasticsearchColumnHandle column = (ElasticsearchColumnHandle)entry.getKey();
                Domain domain = (Domain)entry.getValue();
                Preconditions.checkArgument((!domain.isNone() ? 1 : 0) != 0, (String)"Unexpected NONE domain for %s", (Object)column.getName());
                if (domain.isAll()) continue;
                queryBuilder.filter((QueryBuilder)new BoolQueryBuilder().must(ElasticsearchQueryBuilder.buildPredicate(column.getName(), domain, column.getType())));
            }
        }
        query.map(QueryStringQueryBuilder::new).ifPresent(arg_0 -> ((BoolQueryBuilder)queryBuilder).must(arg_0));
        if (queryBuilder.hasClauses()) {
            return queryBuilder;
        }
        return new MatchAllQueryBuilder();
    }

    private static QueryBuilder buildPredicate(String columnName, Domain domain, Type type) {
        Preconditions.checkArgument((boolean)domain.getType().isOrderable(), (Object)"Domain type must be orderable");
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
        if (domain.getValues().isNone()) {
            boolQueryBuilder.mustNot((QueryBuilder)new ExistsQueryBuilder(columnName));
            return boolQueryBuilder;
        }
        if (domain.getValues().isAll()) {
            boolQueryBuilder.must((QueryBuilder)new ExistsQueryBuilder(columnName));
            return boolQueryBuilder;
        }
        return ElasticsearchQueryBuilder.buildTermQuery(boolQueryBuilder, columnName, domain, type);
    }

    private static QueryBuilder buildTermQuery(BoolQueryBuilder queryBuilder, String columnName, Domain domain, Type type) {
        for (Range range : domain.getValues().getRanges().getOrderedRanges()) {
            BoolQueryBuilder rangeQueryBuilder = new BoolQueryBuilder();
            HashSet<Object> valuesToInclude = new HashSet<Object>();
            Preconditions.checkState((!range.isAll() ? 1 : 0) != 0, (String)"Invalid range for column: %s", (Object)columnName);
            if (range.isSingleValue()) {
                valuesToInclude.add(range.getSingleValue());
            } else {
                if (!range.isLowUnbounded()) {
                    Object lowBound = ElasticsearchQueryBuilder.getValue(type, range.getLowBoundedValue());
                    if (range.isLowInclusive()) {
                        rangeQueryBuilder.filter((QueryBuilder)new RangeQueryBuilder(columnName).gte(lowBound));
                    } else {
                        rangeQueryBuilder.filter((QueryBuilder)new RangeQueryBuilder(columnName).gt(lowBound));
                    }
                }
                if (!range.isHighUnbounded()) {
                    Object highBound = ElasticsearchQueryBuilder.getValue(type, range.getHighBoundedValue());
                    if (range.isHighInclusive()) {
                        rangeQueryBuilder.filter((QueryBuilder)new RangeQueryBuilder(columnName).lte(highBound));
                    } else {
                        rangeQueryBuilder.filter((QueryBuilder)new RangeQueryBuilder(columnName).lt(highBound));
                    }
                }
            }
            if (valuesToInclude.size() == 1) {
                rangeQueryBuilder.filter((QueryBuilder)new TermQueryBuilder(columnName, ElasticsearchQueryBuilder.getValue(type, Iterables.getOnlyElement(valuesToInclude))));
            }
            queryBuilder.should((QueryBuilder)rangeQueryBuilder);
        }
        return queryBuilder;
    }

    private static Object getValue(Type type, Object value) {
        if (type.equals(BooleanType.BOOLEAN) || type.equals(TinyintType.TINYINT) || type.equals(SmallintType.SMALLINT) || type.equals(IntegerType.INTEGER) || type.equals(BigintType.BIGINT) || type.equals(DoubleType.DOUBLE)) {
            return value;
        }
        if (type.equals(RealType.REAL)) {
            return Float.valueOf(Float.intBitsToFloat(Math.toIntExact((Long)value)));
        }
        if (type.equals(VarcharType.VARCHAR)) {
            return ((Slice)value).toStringUtf8();
        }
        if (type.equals(TimestampType.TIMESTAMP_MILLIS)) {
            return Instant.ofEpochMilli(Math.floorDiv((long)((Long)value), 1000)).atZone(ZoneOffset.UTC).toLocalDateTime().format(DateTimeFormatter.ISO_DATE_TIME);
        }
        throw new IllegalArgumentException("Unhandled type: " + type);
    }
}

