/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.elasticsearch;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.elasticsearch.CountQueryPageSource;
import io.trino.plugin.elasticsearch.ElasticsearchColumnHandle;
import io.trino.plugin.elasticsearch.ElasticsearchSplit;
import io.trino.plugin.elasticsearch.ElasticsearchTableHandle;
import io.trino.plugin.elasticsearch.PassthroughQueryPageSource;
import io.trino.plugin.elasticsearch.ScanQueryPageSource;
import io.trino.plugin.elasticsearch.client.ElasticsearchClient;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.predicate.TupleDomain;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;

public class ElasticsearchPageSourceProvider
implements ConnectorPageSourceProvider {
    private final ElasticsearchClient client;

    @Inject
    public ElasticsearchPageSourceProvider(ElasticsearchClient client) {
        this.client = Objects.requireNonNull(client, "client is null");
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, ConnectorTableHandle table, List<ColumnHandle> columns, TupleDomain<ColumnHandle> dynamicFilter) {
        Objects.requireNonNull(split, "split is null");
        Objects.requireNonNull(table, "table is null");
        ElasticsearchTableHandle elasticsearchTable = (ElasticsearchTableHandle)table;
        ElasticsearchSplit elasticsearchSplit = (ElasticsearchSplit)split;
        if (elasticsearchTable.getType().equals((Object)ElasticsearchTableHandle.Type.QUERY)) {
            return new PassthroughQueryPageSource(this.client, elasticsearchTable);
        }
        if (columns.isEmpty()) {
            return new CountQueryPageSource(this.client, elasticsearchTable, elasticsearchSplit);
        }
        return new ScanQueryPageSource(this.client, elasticsearchTable, elasticsearchSplit, (List)columns.stream().map(ElasticsearchColumnHandle.class::cast).collect(ImmutableList.toImmutableList()));
    }
}

