/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.elasticsearch;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.BaseEncoding;
import io.airlift.json.ObjectMapperProvider;
import io.trino.plugin.elasticsearch.BuiltinColumns;
import io.trino.plugin.elasticsearch.ElasticsearchColumnHandle;
import io.trino.plugin.elasticsearch.ElasticsearchConfig;
import io.trino.plugin.elasticsearch.ElasticsearchTableHandle;
import io.trino.plugin.elasticsearch.client.ElasticsearchClient;
import io.trino.plugin.elasticsearch.client.IndexMetadata;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTableProperties;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.ConstraintApplicationResult;
import io.trino.spi.connector.LimitApplicationResult;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SchemaTablePrefix;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class ElasticsearchMetadata
implements ConnectorMetadata {
    private static final ObjectMapper JSON_PARSER = new ObjectMapperProvider().get();
    private static final String PASSTHROUGH_QUERY_SUFFIX = "$query";
    private static final String PASSTHROUGH_QUERY_RESULT_COLUMN_NAME = "result";
    private static final ColumnMetadata PASSTHROUGH_QUERY_RESULT_COLUMN_METADATA = ColumnMetadata.builder().setName("result").setType((Type)VarcharType.VARCHAR).setNullable(true).setHidden(false).build();
    private static final Map<String, ColumnHandle> PASSTHROUGH_QUERY_COLUMNS = ImmutableMap.of((Object)"result", (Object)new ElasticsearchColumnHandle("result", (Type)VarcharType.VARCHAR, false));
    private final Type ipAddressType;
    private final ElasticsearchClient client;
    private final String schemaName;

    @Inject
    public ElasticsearchMetadata(TypeManager typeManager, ElasticsearchClient client, ElasticsearchConfig config) {
        Objects.requireNonNull(typeManager, "typeManager is null");
        this.ipAddressType = typeManager.getType(new TypeSignature("ipaddress", new TypeSignatureParameter[0]));
        this.client = Objects.requireNonNull(client, "client is null");
        Objects.requireNonNull(config, "config is null");
        this.schemaName = config.getDefaultSchema();
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return ImmutableList.of((Object)this.schemaName);
    }

    public ElasticsearchTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        Objects.requireNonNull(tableName, "tableName is null");
        if (tableName.getSchemaName().equals(this.schemaName)) {
            String[] parts = tableName.getTableName().split(":", 2);
            String table = parts[0];
            Optional<String> query = Optional.empty();
            ElasticsearchTableHandle.Type type = ElasticsearchTableHandle.Type.SCAN;
            if (parts.length == 2) {
                if (table.endsWith(PASSTHROUGH_QUERY_SUFFIX)) {
                    byte[] decoded;
                    table = table.substring(0, table.length() - PASSTHROUGH_QUERY_SUFFIX.length());
                    try {
                        decoded = BaseEncoding.base32().decode((CharSequence)parts[1].toUpperCase(Locale.ENGLISH));
                    }
                    catch (IllegalArgumentException e) {
                        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, String.format("Elasticsearch query for '%s' is not base32-encoded correctly", table), (Throwable)e);
                    }
                    String queryJson = new String(decoded, StandardCharsets.UTF_8);
                    try {
                        JSON_PARSER.readTree(queryJson);
                    }
                    catch (JsonProcessingException e) {
                        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, String.format("Elasticsearch query for '%s' is not valid JSON", table), (Throwable)e);
                    }
                    query = Optional.of(queryJson);
                    type = ElasticsearchTableHandle.Type.QUERY;
                } else {
                    query = Optional.of(parts[1]);
                }
            }
            if (this.client.indexExists(table) && !this.client.getIndexMetadata(table).getSchema().getFields().isEmpty()) {
                return new ElasticsearchTableHandle(type, this.schemaName, table, query);
            }
        }
        return null;
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle table) {
        ElasticsearchTableHandle handle = (ElasticsearchTableHandle)table;
        if (ElasticsearchMetadata.isPassthroughQuery(handle)) {
            return new ConnectorTableMetadata(new SchemaTableName(handle.getSchema(), handle.getIndex()), (List)ImmutableList.of((Object)PASSTHROUGH_QUERY_RESULT_COLUMN_METADATA));
        }
        return this.getTableMetadata(handle.getSchema(), handle.getIndex());
    }

    private ConnectorTableMetadata getTableMetadata(String schemaName, String tableName) {
        InternalTableMetadata internalTableMetadata = this.makeInternalTableMetadata(schemaName, tableName);
        return new ConnectorTableMetadata(new SchemaTableName(schemaName, tableName), internalTableMetadata.getColumnMetadata());
    }

    private InternalTableMetadata makeInternalTableMetadata(ConnectorTableHandle table) {
        ElasticsearchTableHandle handle = (ElasticsearchTableHandle)table;
        return this.makeInternalTableMetadata(handle.getSchema(), handle.getIndex());
    }

    private InternalTableMetadata makeInternalTableMetadata(String schema, String tableName) {
        IndexMetadata metadata = this.client.getIndexMetadata(tableName);
        List<IndexMetadata.Field> fields = this.getColumnFields(metadata);
        return new InternalTableMetadata(new SchemaTableName(schema, tableName), this.makeColumnMetadata(fields), this.makeColumnHandles(fields));
    }

    private List<IndexMetadata.Field> getColumnFields(IndexMetadata metadata) {
        ImmutableList.Builder result = ImmutableList.builder();
        Map<String, Long> counts = metadata.getSchema().getFields().stream().collect(Collectors.groupingBy(f -> f.getName().toLowerCase(Locale.ENGLISH), Collectors.counting()));
        for (IndexMetadata.Field field : metadata.getSchema().getFields()) {
            Type type = this.toTrinoType(field);
            if (type == null || counts.get(field.getName().toLowerCase(Locale.ENGLISH)) > 1L) continue;
            result.add((Object)field);
        }
        return result.build();
    }

    private List<ColumnMetadata> makeColumnMetadata(List<IndexMetadata.Field> fields) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (BuiltinColumns builtinColumn : BuiltinColumns.values()) {
            result.add((Object)builtinColumn.getMetadata());
        }
        for (IndexMetadata.Field field : fields) {
            result.add((Object)ColumnMetadata.builder().setName(field.getName()).setType(this.toTrinoType(field)).build());
        }
        return result.build();
    }

    private Map<String, ColumnHandle> makeColumnHandles(List<IndexMetadata.Field> fields) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (BuiltinColumns builtinColumn : BuiltinColumns.values()) {
            result.put((Object)builtinColumn.getName(), (Object)builtinColumn.getColumnHandle());
        }
        for (IndexMetadata.Field field : fields) {
            result.put((Object)field.getName(), (Object)new ElasticsearchColumnHandle(field.getName(), this.toTrinoType(field), ElasticsearchMetadata.supportsPredicates(field.getType())));
        }
        return result.build();
    }

    private static boolean supportsPredicates(IndexMetadata.Type type) {
        if (type instanceof IndexMetadata.DateTimeType) {
            return true;
        }
        if (type instanceof IndexMetadata.PrimitiveType) {
            switch (((IndexMetadata.PrimitiveType)type).getName().toLowerCase(Locale.ENGLISH)) {
                case "boolean": 
                case "byte": 
                case "short": 
                case "integer": 
                case "long": 
                case "double": 
                case "float": 
                case "keyword": {
                    return true;
                }
            }
        }
        return false;
    }

    private Type toTrinoType(IndexMetadata.Field metaDataField) {
        return this.toTrinoType(metaDataField, metaDataField.isArray());
    }

    private Type toTrinoType(IndexMetadata.Field metaDataField, boolean isArray) {
        IndexMetadata.Type type = metaDataField.getType();
        if (isArray) {
            Type elementType = this.toTrinoType(metaDataField, false);
            return new ArrayType(elementType);
        }
        if (type instanceof IndexMetadata.PrimitiveType) {
            switch (((IndexMetadata.PrimitiveType)type).getName()) {
                case "float": {
                    return RealType.REAL;
                }
                case "double": {
                    return DoubleType.DOUBLE;
                }
                case "byte": {
                    return TinyintType.TINYINT;
                }
                case "short": {
                    return SmallintType.SMALLINT;
                }
                case "integer": {
                    return IntegerType.INTEGER;
                }
                case "long": {
                    return BigintType.BIGINT;
                }
                case "text": 
                case "keyword": {
                    return VarcharType.VARCHAR;
                }
                case "ip": {
                    return this.ipAddressType;
                }
                case "boolean": {
                    return BooleanType.BOOLEAN;
                }
                case "binary": {
                    return VarbinaryType.VARBINARY;
                }
            }
        } else if (type instanceof IndexMetadata.DateTimeType) {
            if (((IndexMetadata.DateTimeType)type).getFormats().isEmpty()) {
                return TimestampType.TIMESTAMP_MILLIS;
            }
        } else if (type instanceof IndexMetadata.ObjectType) {
            IndexMetadata.ObjectType objectType = (IndexMetadata.ObjectType)type;
            ImmutableList.Builder builder = ImmutableList.builder();
            for (IndexMetadata.Field field : objectType.getFields()) {
                Type trinoType = this.toTrinoType(field);
                if (trinoType == null) continue;
                builder.add((Object)RowType.field((String)field.getName(), (Type)trinoType));
            }
            ImmutableList fields = builder.build();
            if (!fields.isEmpty()) {
                return RowType.from((List)fields);
            }
        }
        return null;
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        if (schemaName.isPresent() && !schemaName.get().equals(this.schemaName)) {
            return ImmutableList.of();
        }
        ImmutableList.Builder result = ImmutableList.builder();
        ImmutableSet indexes = ImmutableSet.copyOf(this.client.getIndexes());
        indexes.stream().map(index -> new SchemaTableName(this.schemaName, index)).forEach(arg_0 -> ((ImmutableList.Builder)result).add(arg_0));
        this.client.getAliases().entrySet().stream().filter(arg_0 -> ElasticsearchMetadata.lambda$listTables$2((Set)indexes, arg_0)).flatMap(entry -> ((List)entry.getValue()).stream().map(alias -> new SchemaTableName(this.schemaName, alias))).forEach(arg_0 -> ((ImmutableList.Builder)result).add(arg_0));
        return result.build();
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        ElasticsearchTableHandle table = (ElasticsearchTableHandle)tableHandle;
        if (ElasticsearchMetadata.isPassthroughQuery(table)) {
            return PASSTHROUGH_QUERY_COLUMNS;
        }
        InternalTableMetadata tableMetadata = this.makeInternalTableMetadata(tableHandle);
        return tableMetadata.getColumnHandles();
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        ElasticsearchTableHandle table = (ElasticsearchTableHandle)tableHandle;
        ElasticsearchColumnHandle column = (ElasticsearchColumnHandle)columnHandle;
        if (ElasticsearchMetadata.isPassthroughQuery(table)) {
            if (column.getName().equals(PASSTHROUGH_QUERY_RESULT_COLUMN_METADATA.getName())) {
                return PASSTHROUGH_QUERY_RESULT_COLUMN_METADATA;
            }
            throw new IllegalArgumentException(String.format("Unexpected column for table '%s$query': %s", table.getIndex(), column.getName()));
        }
        return BuiltinColumns.of(column.getName()).map(BuiltinColumns::getMetadata).orElse(ColumnMetadata.builder().setName(column.getName()).setType(column.getType()).build());
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        if (prefix.getSchema().isPresent() && !((String)prefix.getSchema().get()).equals(this.schemaName)) {
            return ImmutableMap.of();
        }
        if (prefix.getSchema().isPresent() && prefix.getTable().isPresent()) {
            ConnectorTableMetadata metadata = this.getTableMetadata((String)prefix.getSchema().get(), (String)prefix.getTable().get());
            return ImmutableMap.of((Object)metadata.getTable(), (Object)metadata.getColumns());
        }
        return (Map)this.listTables(session, prefix.getSchema()).stream().map(name -> this.getTableMetadata(name.getSchemaName(), name.getTableName())).collect(ImmutableMap.toImmutableMap(ConnectorTableMetadata::getTable, ConnectorTableMetadata::getColumns));
    }

    public boolean usesLegacyTableLayouts() {
        return false;
    }

    public ConnectorTableProperties getTableProperties(ConnectorSession session, ConnectorTableHandle table) {
        ElasticsearchTableHandle handle = (ElasticsearchTableHandle)table;
        return new ConnectorTableProperties(handle.getConstraint(), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of());
    }

    public Optional<LimitApplicationResult<ConnectorTableHandle>> applyLimit(ConnectorSession session, ConnectorTableHandle table, long limit) {
        ElasticsearchTableHandle handle = (ElasticsearchTableHandle)table;
        if (ElasticsearchMetadata.isPassthroughQuery(handle)) {
            return Optional.empty();
        }
        if (handle.getLimit().isPresent() && handle.getLimit().getAsLong() <= limit) {
            return Optional.empty();
        }
        handle = new ElasticsearchTableHandle(handle.getType(), handle.getSchema(), handle.getIndex(), handle.getConstraint(), handle.getQuery(), OptionalLong.of(limit));
        return Optional.of(new LimitApplicationResult((Object)handle, false));
    }

    public Optional<ConstraintApplicationResult<ConnectorTableHandle>> applyFilter(ConnectorSession session, ConnectorTableHandle table, Constraint constraint) {
        TupleDomain newDomain;
        TupleDomain<ColumnHandle> oldDomain;
        ElasticsearchTableHandle handle = (ElasticsearchTableHandle)table;
        if (ElasticsearchMetadata.isPassthroughQuery(handle)) {
            return Optional.empty();
        }
        HashMap<ElasticsearchColumnHandle, Domain> supported = new HashMap<ElasticsearchColumnHandle, Domain>();
        HashMap<ElasticsearchColumnHandle, Domain> unsupported = new HashMap<ElasticsearchColumnHandle, Domain>();
        if (constraint.getSummary().getDomains().isPresent()) {
            for (Map.Entry entry : ((Map)constraint.getSummary().getDomains().get()).entrySet()) {
                ElasticsearchColumnHandle column = (ElasticsearchColumnHandle)entry.getKey();
                if (column.isSupportsPredicates()) {
                    supported.put(column, (Domain)entry.getValue());
                    continue;
                }
                unsupported.put(column, (Domain)entry.getValue());
            }
        }
        if ((oldDomain = handle.getConstraint()).equals((Object)(newDomain = oldDomain.intersect(TupleDomain.withColumnDomains(supported))))) {
            return Optional.empty();
        }
        handle = new ElasticsearchTableHandle(handle.getType(), handle.getSchema(), handle.getIndex(), (TupleDomain<ColumnHandle>)newDomain, handle.getQuery(), handle.getLimit());
        return Optional.of(new ConstraintApplicationResult((Object)handle, TupleDomain.withColumnDomains(unsupported)));
    }

    private static boolean isPassthroughQuery(ElasticsearchTableHandle table) {
        return table.getType().equals((Object)ElasticsearchTableHandle.Type.QUERY);
    }

    private static /* synthetic */ boolean lambda$listTables$2(Set indexes, Map.Entry entry) {
        return indexes.contains(entry.getKey());
    }

    private static class InternalTableMetadata {
        private final SchemaTableName tableName;
        private final List<ColumnMetadata> columnMetadata;
        private final Map<String, ColumnHandle> columnHandles;

        public InternalTableMetadata(SchemaTableName tableName, List<ColumnMetadata> columnMetadata, Map<String, ColumnHandle> columnHandles) {
            this.tableName = tableName;
            this.columnMetadata = columnMetadata;
            this.columnHandles = columnHandles;
        }

        public SchemaTableName getTableName() {
            return this.tableName;
        }

        public List<ColumnMetadata> getColumnMetadata() {
            return this.columnMetadata;
        }

        public Map<String, ColumnHandle> getColumnHandles() {
            return this.columnHandles;
        }
    }
}

