/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.elasticsearch;

import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import com.google.inject.Binder;
import com.google.inject.Scopes;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.airlift.configuration.ConfigBinder;
import io.airlift.json.JsonBinder;
import io.trino.plugin.elasticsearch.AwsSecurityConfig;
import io.trino.plugin.elasticsearch.ElasticsearchConfig;
import io.trino.plugin.elasticsearch.ElasticsearchConnector;
import io.trino.plugin.elasticsearch.ElasticsearchMetadata;
import io.trino.plugin.elasticsearch.ElasticsearchPageSourceProvider;
import io.trino.plugin.elasticsearch.ElasticsearchSplitManager;
import io.trino.plugin.elasticsearch.NodesSystemTable;
import io.trino.plugin.elasticsearch.PasswordConfig;
import io.trino.plugin.elasticsearch.client.ElasticsearchClient;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeId;
import io.trino.spi.type.TypeManager;
import java.util.Objects;
import java.util.function.Predicate;
import javax.inject.Inject;
import org.weakref.jmx.guice.ExportBinder;

public class ElasticsearchConnectorModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        binder.bind(ElasticsearchConnector.class).in(Scopes.SINGLETON);
        binder.bind(ElasticsearchMetadata.class).in(Scopes.SINGLETON);
        binder.bind(ElasticsearchSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(ElasticsearchPageSourceProvider.class).in(Scopes.SINGLETON);
        binder.bind(ElasticsearchClient.class).in(Scopes.SINGLETON);
        binder.bind(NodesSystemTable.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(ElasticsearchClient.class).withGeneratedName();
        ConfigBinder.configBinder((Binder)binder).bindConfig(ElasticsearchConfig.class);
        JsonBinder.jsonBinder((Binder)binder).addDeserializerBinding(Type.class).to(TypeDeserializer.class);
        OptionalBinder.newOptionalBinder((Binder)binder, AwsSecurityConfig.class);
        OptionalBinder.newOptionalBinder((Binder)binder, PasswordConfig.class);
        this.install(ConditionalModule.installModuleIf(ElasticsearchConfig.class, config -> config.getSecurity().filter(Predicate.isEqual((Object)ElasticsearchConfig.Security.AWS)).isPresent(), conditionalBinder -> ConfigBinder.configBinder((Binder)conditionalBinder).bindConfig(AwsSecurityConfig.class)));
        this.install(ConditionalModule.installModuleIf(ElasticsearchConfig.class, config -> config.getSecurity().filter(Predicate.isEqual((Object)ElasticsearchConfig.Security.PASSWORD)).isPresent(), conditionalBinder -> ConfigBinder.configBinder((Binder)conditionalBinder).bindConfig(PasswordConfig.class)));
    }

    private static final class TypeDeserializer
    extends FromStringDeserializer<Type> {
        private static final long serialVersionUID = 1L;
        private final TypeManager typeManager;

        @Inject
        public TypeDeserializer(TypeManager typeManager) {
            super(Type.class);
            this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        }

        protected Type _deserialize(String value, DeserializationContext context) {
            return this.typeManager.getType(TypeId.of((String)value));
        }
    }
}

