/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.elasticsearch;

import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.json.JsonModule;
import io.trino.plugin.base.jmx.ConnectorObjectNameGeneratorModule;
import io.trino.plugin.base.jmx.MBeanServerModule;
import io.trino.plugin.elasticsearch.ElasticsearchConnector;
import io.trino.plugin.elasticsearch.ElasticsearchConnectorModule;
import io.trino.plugin.elasticsearch.ElasticsearchHandleResolver;
import io.trino.spi.NodeManager;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.ConnectorHandleResolver;
import io.trino.spi.type.TypeManager;
import java.util.Map;
import java.util.Objects;
import org.weakref.jmx.guice.MBeanModule;

public class ElasticsearchConnectorFactory
implements ConnectorFactory {
    ElasticsearchConnectorFactory() {
    }

    public String getName() {
        return "elasticsearch";
    }

    public ConnectorHandleResolver getHandleResolver() {
        return new ElasticsearchHandleResolver();
    }

    public Connector create(String catalogName, Map<String, String> config, ConnectorContext context) {
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(config, "config is null");
        Bootstrap app = new Bootstrap(new Module[]{new MBeanModule(), new MBeanServerModule(), new ConnectorObjectNameGeneratorModule(catalogName, "io.trino.plugin.elasticsearch", "trino.plugin.elasticsearch"), new JsonModule(), new ElasticsearchConnectorModule(), binder -> {
            binder.bind(TypeManager.class).toInstance((Object)context.getTypeManager());
            binder.bind(NodeManager.class).toInstance((Object)context.getNodeManager());
        }});
        Injector injector = app.strictConfig().doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
        return (Connector)injector.getInstance(ElasticsearchConnector.class);
    }
}

