/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.elasticsearch;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.type.Type;
import java.util.Objects;

public final class ElasticsearchColumnHandle
implements ColumnHandle {
    private final String name;
    private final Type type;
    private final boolean supportsPredicates;

    @JsonCreator
    public ElasticsearchColumnHandle(@JsonProperty(value="name") String name, @JsonProperty(value="type") Type type, @JsonProperty(value="supportsPredicates") boolean supportsPredicates) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.type = Objects.requireNonNull(type, "type is null");
        this.supportsPredicates = supportsPredicates;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public Type getType() {
        return this.type;
    }

    @JsonProperty
    public boolean isSupportsPredicates() {
        return this.supportsPredicates;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.supportsPredicates);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ElasticsearchColumnHandle other = (ElasticsearchColumnHandle)obj;
        return this.supportsPredicates == other.supportsPredicates && Objects.equals(this.getName(), other.getName()) && Objects.equals(this.getType(), other.getType());
    }

    public String toString() {
        return this.getName() + "::" + this.getType();
    }
}

