/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.elasticsearch;

import io.trino.plugin.elasticsearch.ElasticsearchColumnHandle;
import io.trino.plugin.elasticsearch.ElasticsearchQueryBuilder;
import io.trino.plugin.elasticsearch.ElasticsearchSplit;
import io.trino.plugin.elasticsearch.ElasticsearchTableHandle;
import io.trino.plugin.elasticsearch.client.ElasticsearchClient;
import io.trino.spi.Page;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.predicate.TupleDomain;
import java.util.Objects;

class CountQueryPageSource
implements ConnectorPageSource {
    private static final int BATCH_SIZE = 10000;
    private final long readTimeNanos;
    private long remaining;

    public CountQueryPageSource(ElasticsearchClient client, ElasticsearchTableHandle table, ElasticsearchSplit split) {
        Objects.requireNonNull(client, "client is null");
        Objects.requireNonNull(table, "table is null");
        Objects.requireNonNull(split, "split is null");
        long start = System.nanoTime();
        long count = client.count(split.getIndex(), split.getShard(), ElasticsearchQueryBuilder.buildSearchQuery((TupleDomain<ElasticsearchColumnHandle>)table.getConstraint().transform(ElasticsearchColumnHandle.class::cast), table.getQuery()));
        this.readTimeNanos = System.nanoTime() - start;
        if (table.getLimit().isPresent()) {
            count = Math.min(table.getLimit().getAsLong(), count);
        }
        this.remaining = count;
    }

    public boolean isFinished() {
        return this.remaining == 0L;
    }

    public Page getNextPage() {
        int batch = Math.toIntExact(Math.min(10000L, this.remaining));
        this.remaining -= (long)batch;
        return new Page(batch);
    }

    public long getReadTimeNanos() {
        return this.readTimeNanos;
    }

    public long getCompletedBytes() {
        return 0L;
    }

    public long getSystemMemoryUsage() {
        return 0L;
    }

    public void close() {
    }
}

