/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.elasticsearch;

import com.google.common.collect.ImmutableMap;
import io.trino.plugin.elasticsearch.ElasticsearchColumnHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.type.RealType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

enum BuiltinColumns {
    ID("_id", (Type)VarcharType.VARCHAR, true),
    SOURCE("_source", (Type)VarcharType.VARCHAR, false),
    SCORE("_score", (Type)RealType.REAL, false);

    private static final Map<String, BuiltinColumns> COLUMNS_BY_NAME;
    private final String name;
    private final Type type;
    private final boolean supportsPredicates;

    private BuiltinColumns(String name, Type type, boolean supportsPredicates) {
        this.name = name;
        this.type = type;
        this.supportsPredicates = supportsPredicates;
    }

    public static Optional<BuiltinColumns> of(String name) {
        return Optional.ofNullable(COLUMNS_BY_NAME.get(name));
    }

    public static boolean isBuiltinColumn(String name) {
        return COLUMNS_BY_NAME.containsKey(name);
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public ColumnMetadata getMetadata() {
        return ColumnMetadata.builder().setName(this.name).setType(this.type).setHidden(true).build();
    }

    public ColumnHandle getColumnHandle() {
        return new ElasticsearchColumnHandle(this.name, this.type, this.supportsPredicates);
    }

    static {
        COLUMNS_BY_NAME = (Map)Arrays.stream(BuiltinColumns.values()).collect(ImmutableMap.toImmutableMap(BuiltinColumns::getName, Function.identity()));
    }
}

