/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cli;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.net.HostAndPort;
import io.airlift.units.Duration;
import io.trino.cli.TerminalUtils;
import io.trino.client.ClientSession;
import io.trino.client.KerberosUtil;
import io.trino.client.auth.external.ExternalRedirectStrategy;
import io.trino.client.uri.LoggingLevel;
import io.trino.client.uri.PropertyName;
import io.trino.client.uri.RestrictedPropertyException;
import io.trino.client.uri.TrinoUri;
import java.io.Console;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import picocli.CommandLine;

public class ClientOptions {
    private static final Splitter NAME_VALUE_SPLITTER = Splitter.on((char)'=').limit(2);
    private static final CharMatcher PRINTABLE_ASCII = CharMatcher.inRange((char)'!', (char)'~');
    private static final String DEFAULT_VALUE = "(default: ${DEFAULT-VALUE})";
    private static final String SERVER_DEFAULT = "localhost:8080";
    private static final String SOURCE_DEFAULT = "trino-cli";
    static final String DEBUG_OPTION_NAME = "--debug";
    @CommandLine.Parameters(paramLabel="URL", description={"Trino server URL"}, arity="0..1")
    public Optional<String> url;
    @CommandLine.Option(names={"--server"}, paramLabel="<server>", description={"Trino server location (default: localhost:8080)"})
    public Optional<String> server;
    @PropertyMapping(value=PropertyName.KERBEROS_SERVICE_PRINCIPAL_PATTERN)
    @CommandLine.Option(names={"--krb5-service-principal-pattern"}, paramLabel="<pattern>", defaultValue="$${SERVICE}@$${HOST}", description={"Remote kerberos service principal pattern (default: ${DEFAULT-VALUE})"})
    public Optional<String> krb5ServicePrincipalPattern;
    @PropertyMapping(value=PropertyName.KERBEROS_REMOTE_SERVICE_NAME)
    @CommandLine.Option(names={"--krb5-remote-service-name"}, paramLabel="<name>", description={"Remote peer's kerberos service name"})
    public Optional<String> krb5RemoteServiceName;
    @PropertyMapping(value=PropertyName.KERBEROS_CONFIG_PATH)
    @CommandLine.Option(names={"--krb5-config-path"}, paramLabel="<path>", defaultValue="/etc/krb5.conf", description={"Kerberos config file path (default: ${DEFAULT-VALUE})"})
    public Optional<String> krb5ConfigPath;
    @PropertyMapping(value=PropertyName.KERBEROS_KEYTAB_PATH)
    @CommandLine.Option(names={"--krb5-keytab-path"}, paramLabel="<path>", defaultValue="/etc/krb5.keytab", description={"Kerberos key table path (default: ${DEFAULT-VALUE})"})
    public Optional<String> krb5KeytabPath;
    @PropertyMapping(value=PropertyName.KERBEROS_CREDENTIAL_CACHE_PATH)
    @CommandLine.Option(names={"--krb5-credential-cache-path"}, paramLabel="<path>", description={"Kerberos credential cache path"})
    public Optional<String> krb5CredentialCachePath = KerberosUtil.defaultCredentialCachePath();
    @PropertyMapping(value=PropertyName.KERBEROS_PRINCIPAL)
    @CommandLine.Option(names={"--krb5-principal"}, paramLabel="<principal>", description={"Kerberos principal to be used"})
    public Optional<String> krb5Principal;
    @PropertyMapping(value=PropertyName.KERBEROS_USE_CANONICAL_HOSTNAME)
    @CommandLine.Option(names={"--krb5-disable-remote-service-hostname-canonicalization"}, description={"Disable service hostname canonicalization using the DNS reverse lookup"})
    public boolean krb5DisableRemoteServiceHostnameCanonicalization;
    @PropertyMapping(value=PropertyName.SSL_KEY_STORE_PATH)
    @CommandLine.Option(names={"--keystore-path"}, paramLabel="<path>", description={"Keystore path"})
    public Optional<String> keystorePath;
    @PropertyMapping(value=PropertyName.SSL_KEY_STORE_PASSWORD)
    @CommandLine.Option(names={"--keystore-password"}, paramLabel="<password>", description={"Keystore password"})
    public Optional<String> keystorePassword;
    @PropertyMapping(value=PropertyName.SSL_KEY_STORE_TYPE)
    @CommandLine.Option(names={"--keystore-type"}, paramLabel="<type>", description={"Keystore type"})
    public Optional<String> keystoreType;
    @PropertyMapping(value=PropertyName.SSL_USE_SYSTEM_KEY_STORE)
    @CommandLine.Option(names={"--use-system-keystore"}, description={"Use default operating system keystore"})
    public boolean useSystemKeystore;
    @PropertyMapping(value=PropertyName.SSL_TRUST_STORE_PATH)
    @CommandLine.Option(names={"--truststore-path"}, paramLabel="<path>", description={"Truststore path"})
    public Optional<String> truststorePath;
    @PropertyMapping(value=PropertyName.SSL_TRUST_STORE_PASSWORD)
    @CommandLine.Option(names={"--truststore-password"}, paramLabel="<password>", description={"Truststore password"})
    public Optional<String> truststorePassword;
    @PropertyMapping(value=PropertyName.SSL_TRUST_STORE_TYPE)
    @CommandLine.Option(names={"--truststore-type"}, paramLabel="<type>", description={"Truststore type"})
    public Optional<String> truststoreType;
    @PropertyMapping(value=PropertyName.SSL_USE_SYSTEM_TRUST_STORE)
    @CommandLine.Option(names={"--use-system-truststore"}, description={"Use default system (OS) truststore"})
    public boolean useSystemTruststore;
    @PropertyMapping(value=PropertyName.SSL_VERIFICATION)
    @CommandLine.Option(names={"--insecure"}, description={"Skip validation of HTTP server certificates (should only be used for debugging)"})
    public boolean insecure;
    @PropertyMapping(value=PropertyName.ACCESS_TOKEN)
    @CommandLine.Option(names={"--access-token"}, paramLabel="<token>", description={"Access token"})
    public Optional<String> accessToken;
    @PropertyMapping(value=PropertyName.USER)
    @CommandLine.Option(names={"--user"}, paramLabel="<user>", defaultValue="${sys:user.name}", description={"Username (default: ${DEFAULT-VALUE})"})
    public Optional<String> user;
    @PropertyMapping(value=PropertyName.PASSWORD)
    @CommandLine.Option(names={"--password"}, paramLabel="<password>", description={"Prompt for password"})
    public boolean password;
    @PropertyMapping(value=PropertyName.EXTERNAL_AUTHENTICATION)
    @CommandLine.Option(names={"--external-authentication"}, paramLabel="<externalAuthentication>", description={"Enable external authentication"})
    public boolean externalAuthentication;
    @PropertyMapping(value=PropertyName.EXTERNAL_AUTHENTICATION_REDIRECT_HANDLERS)
    @CommandLine.Option(names={"--external-authentication-redirect-handler"}, paramLabel="<externalAuthenticationRedirectHandler>", description={"External authentication redirect handlers: ${COMPLETION-CANDIDATES} (default: ${DEFAULT-VALUE})"}, defaultValue="ALL")
    public List<ExternalRedirectStrategy> externalAuthenticationRedirectHandler = new ArrayList<ExternalRedirectStrategy>();
    @PropertyMapping(value=PropertyName.SOURCE)
    @CommandLine.Option(names={"--source"}, paramLabel="<source>", description={"Name of the client to use as source that submits the query (default: trino-cli)"})
    public Optional<String> source;
    @PropertyMapping(value=PropertyName.CLIENT_INFO)
    @CommandLine.Option(names={"--client-info"}, paramLabel="<info>", description={"Extra information about client making query"})
    public Optional<String> clientInfo;
    @PropertyMapping(value=PropertyName.CLIENT_TAGS)
    @CommandLine.Option(names={"--client-tags"}, paramLabel="<tags>", description={"Client tags"}, converter={ClientTagsConverter.class})
    public Optional<Set<String>> clientTags;
    @PropertyMapping(value=PropertyName.TRACE_TOKEN)
    @CommandLine.Option(names={"--trace-token"}, paramLabel="<token>", description={"Trace token"})
    public Optional<String> traceToken;
    @PropertyMapping(value=PropertyName.CATALOG)
    @CommandLine.Option(names={"--catalog"}, paramLabel="<catalog>", description={"Default catalog"})
    public Optional<String> catalog;
    @PropertyMapping(value=PropertyName.SCHEMA)
    @CommandLine.Option(names={"--schema"}, paramLabel="<schema>", description={"Default schema"})
    public Optional<String> schema;
    @PropertyMapping(value=PropertyName.SQL_PATH)
    @CommandLine.Option(names={"--path"}, paramLabel="<catalog.schema>", description={"Default SQL path"}, arity="0..*")
    public List<String> path = ImmutableList.of();
    @CommandLine.Option(names={"-f", "--file"}, paramLabel="<file>", description={"Execute statements from file and exit"})
    public String file;
    @CommandLine.Option(names={"--debug"}, paramLabel="<debug>", description={"Enable debug information"})
    public boolean debug;
    @CommandLine.Option(names={"--history-file"}, paramLabel="<historyFile>", defaultValue="${env:TRINO_HISTORY_FILE:-${sys:user.home}/.trino_history}", description={"Path to the history file (default: ${DEFAULT-VALUE})"})
    public String historyFile;
    @PropertyMapping(value=PropertyName.HTTP_LOGGING_LEVEL)
    @CommandLine.Option(names={"--network-logging"}, paramLabel="<level>", defaultValue="NONE", description={"Network logging level [${COMPLETION-CANDIDATES}] (default: ${DEFAULT-VALUE})"})
    public Optional<LoggingLevel> networkLogging;
    @CommandLine.Option(names={"--progress"}, paramLabel="<progress>", description={"Show query progress"}, negatable=true)
    public Optional<Boolean> progress;
    @CommandLine.Option(names={"--execute"}, paramLabel="<execute>", description={"Execute specified statements and exit"})
    public String execute;
    @CommandLine.Option(names={"--output-format"}, paramLabel="<format>", defaultValue="CSV", description={"Output format for batch mode [${COMPLETION-CANDIDATES}] (default: ${DEFAULT-VALUE})"})
    public OutputFormat outputFormat;
    @CommandLine.Option(names={"--output-format-interactive"}, paramLabel="<format>", defaultValue="ALIGNED", description={"Output format for interactive mode [${COMPLETION-CANDIDATES}] (default: ${DEFAULT-VALUE})"})
    public OutputFormat outputFormatInteractive;
    @CommandLine.Option(names={"--pager"}, paramLabel="<pager>", defaultValue="${env:TRINO_PAGER}", description={"Path to the pager program used to display the query results"})
    public Optional<String> pager;
    @PropertyMapping(value=PropertyName.RESOURCE_ESTIMATES)
    @CommandLine.Option(names={"--resource-estimate"}, paramLabel="<estimate>", description={"Resource estimate (property can be used multiple times; format is key=value)"})
    public final List<ClientResourceEstimate> resourceEstimates = new ArrayList<ClientResourceEstimate>();
    @PropertyMapping(value=PropertyName.SESSION_PROPERTIES)
    @CommandLine.Option(names={"--session"}, paramLabel="<session>", description={"Session property (property can be used multiple times; format is key=value; use 'SHOW SESSION' to see available properties)"})
    public final List<ClientSessionProperty> sessionProperties = new ArrayList<ClientSessionProperty>();
    @PropertyMapping(value=PropertyName.SESSION_USER)
    @CommandLine.Option(names={"--session-user"}, paramLabel="<user>", description={"Username to impersonate"})
    public Optional<String> sessionUser;
    @PropertyMapping(value=PropertyName.EXTRA_CREDENTIALS)
    @CommandLine.Option(names={"--extra-credential"}, paramLabel="<credential>", description={"Extra credentials (property can be used multiple times; format is key=value)"})
    public final List<ClientExtraCredential> extraCredentials = new ArrayList<ClientExtraCredential>();
    @PropertyMapping(value=PropertyName.SOCKS_PROXY)
    @CommandLine.Option(names={"--socks-proxy"}, paramLabel="<proxy>", description={"SOCKS proxy to use for server connections"})
    public Optional<HostAndPort> socksProxy;
    @PropertyMapping(value=PropertyName.HTTP_PROXY)
    @CommandLine.Option(names={"--http-proxy"}, paramLabel="<proxy>", description={"HTTP proxy to use for server connections"})
    public Optional<HostAndPort> httpProxy;
    @PropertyMapping(value=PropertyName.TIMEOUT)
    @CommandLine.Option(names={"--client-request-timeout"}, paramLabel="<timeout>", defaultValue="2m", description={"Client request timeout (default: ${DEFAULT-VALUE})"})
    public Duration clientRequestTimeout;
    @CommandLine.Option(names={"--ignore-errors"}, description={"Continue processing in batch mode when an error occurs (default is to exit immediately)"})
    public boolean ignoreErrors;
    @PropertyMapping(value=PropertyName.TIMEZONE)
    @CommandLine.Option(names={"--timezone"}, paramLabel="<timezone>", description={"Session time zone (default: ${DEFAULT-VALUE})"})
    public ZoneId timeZone = ZoneId.systemDefault();
    @PropertyMapping(value=PropertyName.DISABLE_COMPRESSION)
    @CommandLine.Option(names={"--disable-compression"}, description={"Disable compression of query results"})
    public boolean disableCompression;
    @CommandLine.Option(names={"--editing-mode"}, paramLabel="<editing-mode>", defaultValue="EMACS", description={"Editing mode [${COMPLETION-CANDIDATES}] (default: ${DEFAULT-VALUE})"})
    public EditingMode editingMode;
    @CommandLine.Option(names={"--disable-auto-suggestion"}, description={"Disable auto suggestion"})
    public boolean disableAutoSuggestion;

    public ClientSession toClientSession(TrinoUri uri) {
        return uri.toClientSessionBuilder().source(uri.getSource().orElse(SOURCE_DEFAULT)).build();
    }

    public TrinoUri getTrinoUri() {
        return this.getTrinoUri((Map<PropertyName, String>)ImmutableMap.of());
    }

    public TrinoUri getTrinoUri(Map<PropertyName, String> restrictedProperties) {
        URI uri;
        if (this.url.isPresent()) {
            if (this.server.isPresent()) {
                throw new IllegalArgumentException("Using both the URL parameter and the --server option is not allowed");
            }
            uri = ClientOptions.parseServer(this.url.get());
        } else {
            uri = ClientOptions.parseServer(this.server.orElse(SERVER_DEFAULT));
        }
        ImmutableList bannedProperties = ImmutableList.builder().addAll(restrictedProperties.keySet()).add((Object)PropertyName.PASSWORD).build();
        TrinoUri.Builder builder = TrinoUri.builder().setUri(uri).setRestrictedProperties((List)bannedProperties);
        this.catalog.ifPresent(arg_0 -> ((TrinoUri.Builder)builder).setCatalog(arg_0));
        this.schema.ifPresent(arg_0 -> ((TrinoUri.Builder)builder).setSchema(arg_0));
        this.user.ifPresent(arg_0 -> ((TrinoUri.Builder)builder).setUser(arg_0));
        this.sessionUser.ifPresent(arg_0 -> ((TrinoUri.Builder)builder).setSessionUser(arg_0));
        if (!this.path.isEmpty()) {
            builder.setPath(this.path);
        }
        if (this.password) {
            builder.setPassword(this.getPassword());
        }
        this.krb5RemoteServiceName.ifPresent(arg_0 -> ((TrinoUri.Builder)builder).setKerberosRemoteServiceName(arg_0));
        this.krb5ServicePrincipalPattern.ifPresent(arg_0 -> ((TrinoUri.Builder)builder).setKerberosServicePrincipalPattern(arg_0));
        if (this.krb5RemoteServiceName.isPresent()) {
            this.krb5ConfigPath.ifPresent(arg_0 -> ((TrinoUri.Builder)builder).setKerberosConfigPath(arg_0));
            this.krb5KeytabPath.ifPresent(arg_0 -> ((TrinoUri.Builder)builder).setKerberosKeytabPath(arg_0));
        }
        this.krb5CredentialCachePath.ifPresent(arg_0 -> ((TrinoUri.Builder)builder).setKerberosCredentialCachePath(arg_0));
        this.krb5Principal.ifPresent(arg_0 -> ((TrinoUri.Builder)builder).setKerberosPrincipal(arg_0));
        if (this.krb5DisableRemoteServiceHostnameCanonicalization) {
            builder.setKerberosUseCanonicalHostname(Boolean.valueOf(false));
        }
        if (this.insecure) {
            builder.setSslVerificationNone();
        }
        this.keystorePath.ifPresent(arg_0 -> ((TrinoUri.Builder)builder).setSslKeyStorePath(arg_0));
        this.keystorePassword.ifPresent(arg_0 -> ((TrinoUri.Builder)builder).setSslKeyStorePassword(arg_0));
        this.keystoreType.ifPresent(arg_0 -> ((TrinoUri.Builder)builder).setSslKeyStoreType(arg_0));
        if (this.useSystemKeystore) {
            builder.setSslUseSystemKeyStore(true);
        }
        this.truststorePath.ifPresent(arg_0 -> ((TrinoUri.Builder)builder).setSslTrustStorePath(arg_0));
        this.truststorePassword.ifPresent(arg_0 -> ((TrinoUri.Builder)builder).setSslTrustStorePassword(arg_0));
        this.truststoreType.ifPresent(arg_0 -> ((TrinoUri.Builder)builder).setSslTrustStoreType(arg_0));
        if (this.useSystemTruststore) {
            builder.setSslUseSystemTrustStore(Boolean.valueOf(true));
        }
        this.accessToken.ifPresent(arg_0 -> ((TrinoUri.Builder)builder).setAccessToken(arg_0));
        if (!this.extraCredentials.isEmpty()) {
            builder.setExtraCredentials(ClientOptions.toExtraCredentials(this.extraCredentials));
        }
        if (!this.sessionProperties.isEmpty()) {
            builder.setSessionProperties(ClientOptions.toProperties(this.sessionProperties));
        }
        if (!this.resourceEstimates.isEmpty()) {
            builder.setResourceEstimates(ClientOptions.toResourceEstimates(this.resourceEstimates));
        }
        builder.setExternalAuthentication(Boolean.valueOf(this.externalAuthentication));
        if (!this.externalAuthenticationRedirectHandler.isEmpty()) {
            builder.setExternalAuthenticationRedirectHandlers(this.externalAuthenticationRedirectHandler);
        }
        this.source.ifPresent(arg_0 -> ((TrinoUri.Builder)builder).setSource(arg_0));
        this.clientInfo.ifPresent(arg_0 -> ((TrinoUri.Builder)builder).setClientInfo(arg_0));
        this.clientTags.ifPresent(arg_0 -> ((TrinoUri.Builder)builder).setClientTags(arg_0));
        this.traceToken.ifPresent(arg_0 -> ((TrinoUri.Builder)builder).setTraceToken(arg_0));
        this.socksProxy.ifPresent(arg_0 -> ((TrinoUri.Builder)builder).setSocksProxy(arg_0));
        this.httpProxy.ifPresent(arg_0 -> ((TrinoUri.Builder)builder).setHttpProxy(arg_0));
        builder.setTimeZone(this.timeZone);
        builder.setDisableCompression(Boolean.valueOf(this.disableCompression));
        builder.setTimeout(this.clientRequestTimeout);
        this.networkLogging.ifPresent(arg_0 -> ((TrinoUri.Builder)builder).setHttpLoggingLevel(arg_0));
        if (!this.resourceEstimates.isEmpty()) {
            builder.setResourceEstimates(ClientOptions.toResourceEstimates(this.resourceEstimates));
        }
        try {
            return builder.build();
        }
        catch (RestrictedPropertyException e) {
            if (e.getPropertyName() == PropertyName.PASSWORD) {
                throw new IllegalArgumentException("Setting the password in the URL parameter is not allowed, use the `--password` option or the `TRINO_PASSWORD` environment variable");
            }
            throw new IllegalArgumentException(String.format("Connection property '%s' cannot be set in the URL when option '%s' is set", e.getPropertyName(), restrictedProperties.get(e.getPropertyName())), e);
        }
    }

    private String getPassword() {
        Preconditions.checkState((this.user.isPresent() && !this.user.get().isEmpty() ? 1 : 0) != 0, (Object)"Both username and password must be specified");
        String defaultPassword = System.getenv("TRINO_PASSWORD");
        if (defaultPassword != null) {
            return defaultPassword;
        }
        Console console = System.console();
        if (console != null) {
            char[] password = console.readPassword("Password: ", new Object[0]);
            if (password != null) {
                return new String(password);
            }
            return "";
        }
        LineReader reader = LineReaderBuilder.builder().terminal(TerminalUtils.getTerminal()).build();
        return reader.readLine("Password: ", Character.valueOf('\u0000'));
    }

    public static URI parseServer(String server) {
        String lowerServer = server.toLowerCase(Locale.ENGLISH);
        if (lowerServer.startsWith("http://") || lowerServer.startsWith("https://") || lowerServer.startsWith("trino://")) {
            return URI.create(server);
        }
        HostAndPort host = HostAndPort.fromString((String)server);
        try {
            int port = host.getPortOrDefault(80);
            String scheme = port == 443 ? "https" : "http";
            return new URI(scheme, null, host.getHost(), port, null, null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static Map<String, String> toProperties(List<ClientSessionProperty> sessionProperties) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ClientSessionProperty sessionProperty : sessionProperties) {
            String name = sessionProperty.getName();
            if (sessionProperty.getCatalog().isPresent()) {
                name = sessionProperty.getCatalog().get() + "." + name;
            }
            builder.put((Object)name, (Object)sessionProperty.getValue());
        }
        return builder.buildOrThrow();
    }

    public static Map<String, String> toResourceEstimates(List<ClientResourceEstimate> estimates) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ClientResourceEstimate estimate : estimates) {
            builder.put((Object)estimate.getResource(), (Object)estimate.getEstimate());
        }
        return builder.buildOrThrow();
    }

    public static Map<String, String> toExtraCredentials(List<ClientExtraCredential> extraCredentials) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ClientExtraCredential credential : extraCredentials) {
            builder.put((Object)credential.getName(), (Object)credential.getValue());
        }
        return builder.buildOrThrow();
    }

    public static final class ClientSessionProperty {
        private static final Splitter NAME_SPLITTER = Splitter.on((char)'.');
        private final Optional<String> catalog;
        private final String name;
        private final String value;

        public ClientSessionProperty(String property) {
            List nameValue = NAME_VALUE_SPLITTER.splitToList((CharSequence)property);
            Preconditions.checkArgument((nameValue.size() == 2 ? 1 : 0) != 0, (String)"Session property: %s", (Object)property);
            List nameParts = NAME_SPLITTER.splitToList((CharSequence)nameValue.get(0));
            Preconditions.checkArgument((nameParts.size() == 1 || nameParts.size() == 2 ? 1 : 0) != 0, (String)"Invalid session property: %s", (Object)property);
            if (nameParts.size() == 1) {
                this.catalog = Optional.empty();
                this.name = (String)nameParts.get(0);
            } else {
                this.catalog = Optional.of((String)nameParts.get(0));
                this.name = (String)nameParts.get(1);
            }
            this.value = (String)nameValue.get(1);
            ClientSessionProperty.verifyProperty(this.catalog, this.name, this.value);
        }

        public ClientSessionProperty(Optional<String> catalog, String name, String value) {
            this.catalog = Objects.requireNonNull(catalog, "catalog is null");
            this.name = Objects.requireNonNull(name, "name is null");
            this.value = Objects.requireNonNull(value, "value is null");
            ClientSessionProperty.verifyProperty(catalog, name, value);
        }

        private static void verifyProperty(Optional<String> catalog, String name, String value) {
            Preconditions.checkArgument((!catalog.isPresent() || !catalog.get().isEmpty() ? 1 : 0) != 0, (String)"Invalid session property: %s.%s:%s", catalog, (Object)name, (Object)value);
            Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"Session property name is empty");
            Preconditions.checkArgument((catalog.orElse("").indexOf(61) < 0 ? 1 : 0) != 0, (String)"Session property catalog must not contain '=': %s", (Object)name);
            Preconditions.checkArgument((boolean)PRINTABLE_ASCII.matchesAllOf((CharSequence)catalog.orElse("")), (String)"Session property catalog contains spaces or is not ASCII: %s", (Object)name);
            Preconditions.checkArgument((name.indexOf(61) < 0 ? 1 : 0) != 0, (String)"Session property name must not contain '=': %s", (Object)name);
            Preconditions.checkArgument((boolean)PRINTABLE_ASCII.matchesAllOf((CharSequence)name), (String)"Session property name contains spaces or is not ASCII: %s", (Object)name);
            Preconditions.checkArgument((boolean)PRINTABLE_ASCII.matchesAllOf((CharSequence)value), (String)"Session property value contains spaces or is not ASCII: %s", (Object)value);
        }

        public Optional<String> getCatalog() {
            return this.catalog;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return (this.catalog.isPresent() ? this.catalog.get() + '.' : "") + this.name + '=' + this.value;
        }

        public int hashCode() {
            return Objects.hash(this.catalog, this.name, this.value);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ClientSessionProperty other = (ClientSessionProperty)obj;
            return Objects.equals(this.catalog, other.catalog) && Objects.equals(this.name, other.name) && Objects.equals(this.value, other.value);
        }
    }

    public static final class ClientResourceEstimate {
        private final String resource;
        private final String estimate;

        public ClientResourceEstimate(String resourceEstimate) {
            List nameValue = NAME_VALUE_SPLITTER.splitToList((CharSequence)resourceEstimate);
            Preconditions.checkArgument((nameValue.size() == 2 ? 1 : 0) != 0, (String)"Resource estimate: %s", (Object)resourceEstimate);
            this.resource = (String)nameValue.get(0);
            this.estimate = (String)nameValue.get(1);
            Preconditions.checkArgument((!this.resource.isEmpty() ? 1 : 0) != 0, (Object)"Resource name is empty");
            Preconditions.checkArgument((!this.estimate.isEmpty() ? 1 : 0) != 0, (Object)"Resource estimate is empty");
            Preconditions.checkArgument((boolean)PRINTABLE_ASCII.matchesAllOf((CharSequence)this.resource), (String)"Resource contains spaces or is not ASCII: %s", (Object)this.resource);
            Preconditions.checkArgument((this.resource.indexOf(61) < 0 ? 1 : 0) != 0, (String)"Resource must not contain '=': %s", (Object)this.resource);
            Preconditions.checkArgument((boolean)PRINTABLE_ASCII.matchesAllOf((CharSequence)this.estimate), (String)"Resource estimate contains spaces or is not ASCII: %s", (Object)this.resource);
        }

        @VisibleForTesting
        public ClientResourceEstimate(String resource, String estimate) {
            this.resource = Objects.requireNonNull(resource, "resource is null");
            this.estimate = estimate;
        }

        public String getResource() {
            return this.resource;
        }

        public String getEstimate() {
            return this.estimate;
        }

        public String toString() {
            return this.resource + '=' + this.estimate;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClientResourceEstimate other = (ClientResourceEstimate)o;
            return Objects.equals(this.resource, other.resource) && Objects.equals(this.estimate, other.estimate);
        }

        public int hashCode() {
            return Objects.hash(this.resource, this.estimate);
        }
    }

    public static final class ClientExtraCredential {
        private final String name;
        private final String value;

        public ClientExtraCredential(String extraCredential) {
            List nameValue = NAME_VALUE_SPLITTER.splitToList((CharSequence)extraCredential);
            Preconditions.checkArgument((nameValue.size() == 2 ? 1 : 0) != 0, (String)"Extra credential: %s", (Object)extraCredential);
            this.name = (String)nameValue.get(0);
            this.value = (String)nameValue.get(1);
            Preconditions.checkArgument((!this.name.isEmpty() ? 1 : 0) != 0, (Object)"Credential name is empty");
            Preconditions.checkArgument((!this.value.isEmpty() ? 1 : 0) != 0, (Object)"Credential value is empty");
            Preconditions.checkArgument((boolean)PRINTABLE_ASCII.matchesAllOf((CharSequence)this.name), (String)"Credential name contains spaces or is not ASCII: %s", (Object)this.name);
            Preconditions.checkArgument((this.name.indexOf(61) < 0 ? 1 : 0) != 0, (String)"Credential name must not contain '=': %s", (Object)this.name);
            Preconditions.checkArgument((boolean)PRINTABLE_ASCII.matchesAllOf((CharSequence)this.value), (String)"Credential value contains space or is not ASCII: %s", (Object)this.name);
        }

        public ClientExtraCredential(String name, String value) {
            this.name = Objects.requireNonNull(name, "name is null");
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.name + '=' + this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClientExtraCredential other = (ClientExtraCredential)o;
            return Objects.equals(this.name, other.name) && Objects.equals(this.value, other.value);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.value);
        }
    }

    private static class ClientTagsConverter
    implements CommandLine.ITypeConverter<Set<String>> {
        private ClientTagsConverter() {
        }

        public Set<String> convert(String clientTagsString) {
            Splitter splitter = Splitter.on((char)',').trimResults().omitEmptyStrings();
            return ImmutableSet.copyOf((Iterable)splitter.split((CharSequence)Strings.nullToEmpty((String)clientTagsString)));
        }
    }

    public static enum EditingMode {
        EMACS("emacs"),
        VI("viins");

        private final String keyMap;

        private EditingMode(String keyMap) {
            this.keyMap = keyMap;
        }

        public String getKeyMap() {
            return this.keyMap;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface PropertyMapping {
        public PropertyName value();
    }

    public static enum OutputFormat {
        AUTO,
        ALIGNED,
        VERTICAL,
        TSV,
        TSV_HEADER,
        CSV,
        CSV_HEADER,
        CSV_UNQUOTED,
        CSV_HEADER_UNQUOTED,
        JSON,
        MARKDOWN,
        NULL;

    }
}

