/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cli;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.StandardSystemProperty;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.google.common.util.concurrent.Uninterruptibles;
import io.airlift.units.Duration;
import io.trino.cli.ClientOptions;
import io.trino.cli.Completion;
import io.trino.cli.Help;
import io.trino.cli.InputReader;
import io.trino.cli.Query;
import io.trino.cli.QueryPreprocessor;
import io.trino.cli.QueryPreprocessorException;
import io.trino.cli.QueryRunner;
import io.trino.cli.TableNameCompleter;
import io.trino.cli.TerminalUtils;
import io.trino.cli.ThreadInterruptor;
import io.trino.cli.Trino;
import io.trino.client.ClientSelectedRole;
import io.trino.client.ClientSession;
import io.trino.sql.parser.StatementSplitter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jline.reader.EndOfFileException;
import org.jline.reader.History;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.UserInterruptException;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.jline.utils.InfoCmp;
import picocli.CommandLine;

@CommandLine.Command(name="trino", header={"Trino command line interface"}, synopsisHeading="%nUSAGE:%n%n", optionListHeading="%nOPTIONS:%n", usageHelpAutoWidth=true, versionProvider=Trino.VersionProvider.class)
public class Console
implements Callable<Integer> {
    public static final Set<String> STATEMENT_DELIMITERS = ImmutableSet.of((Object)";", (Object)"\\G");
    private static final String PROMPT_NAME = "trino";
    private static final Duration EXIT_DELAY = new Duration(3.0, TimeUnit.SECONDS);
    @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, description={"Show this help message and exit"})
    public boolean usageHelpRequested;
    @CommandLine.Option(names={"--version"}, versionHelp=true, description={"Print version information and exit"})
    public boolean versionInfoRequested;
    @CommandLine.Mixin
    public ClientOptions clientOptions;

    @Override
    public Integer call() {
        return this.run() ? 0 : 1;
    }

    public boolean run() {
        ClientSession session = this.clientOptions.toClientSession();
        boolean hasQuery = this.clientOptions.execute != null;
        boolean isFromFile = !Strings.isNullOrEmpty((String)this.clientOptions.file);
        String query = this.clientOptions.execute;
        if (hasQuery) {
            query = query + ";";
        }
        if (isFromFile) {
            if (hasQuery) {
                throw new RuntimeException("both --execute and --file specified");
            }
            try {
                query = Files.asCharSource((File)new File(this.clientOptions.file), (Charset)StandardCharsets.UTF_8).read();
                hasQuery = true;
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Error reading from file %s: %s", this.clientOptions.file, e.getMessage()));
            }
        }
        if (!hasQuery && !TerminalUtils.isRealTerminal()) {
            try {
                if (System.in.available() > 0 && (query = new String(ByteStreams.toByteArray((InputStream)System.in), TerminalUtils.terminalEncoding()) + ";").length() > 1) {
                    hasQuery = true;
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        AtomicBoolean exiting = new AtomicBoolean();
        ThreadInterruptor interruptor = new ThreadInterruptor();
        CountDownLatch exited = new CountDownLatch(1);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            exiting.set(true);
            interruptor.interrupt();
            Uninterruptibles.awaitUninterruptibly((CountDownLatch)exited, (long)EXIT_DELAY.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS);
            TerminalUtils.closeTerminal();
        }));
        try {
            QueryRunner queryRunner;
            block19: {
                queryRunner = new QueryRunner(session, this.clientOptions.debug, this.clientOptions.networkLogging, this.clientOptions.socksProxy, this.clientOptions.httpProxy, this.clientOptions.keystorePath, this.clientOptions.keystorePassword, this.clientOptions.keystoreType, this.clientOptions.truststorePath, this.clientOptions.truststorePassword, this.clientOptions.truststoreType, this.clientOptions.useSystemTruststore, this.clientOptions.insecure, this.clientOptions.accessToken, this.clientOptions.user, this.clientOptions.password ? Optional.of(this.getPassword()) : Optional.empty(), this.clientOptions.krb5Principal, this.clientOptions.krb5ServicePrincipalPattern, this.clientOptions.krb5RemoteServiceName, this.clientOptions.krb5ConfigPath, this.clientOptions.krb5KeytabPath, this.clientOptions.krb5CredentialCachePath, !this.clientOptions.krb5DisableRemoteServiceHostnameCanonicalization, false, this.clientOptions.externalAuthentication, this.clientOptions.externalAuthenticationRedirectHandler);
                try {
                    if (!hasQuery) break block19;
                    boolean bl = Console.executeCommand(queryRunner, exiting, query, this.clientOptions.outputFormat, this.clientOptions.ignoreErrors, this.clientOptions.progress);
                    queryRunner.close();
                    return bl;
                }
                catch (Throwable throwable) {
                    try {
                        queryRunner.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            Console.runConsole(queryRunner, exiting, this.clientOptions.editingMode);
            boolean bl = true;
            queryRunner.close();
            return bl;
        }
        finally {
            exited.countDown();
            interruptor.close();
        }
    }

    private String getPassword() {
        Preconditions.checkState((boolean)this.clientOptions.user.isPresent(), (Object)"Username must be specified along with password");
        String defaultPassword = System.getenv("TRINO_PASSWORD");
        if (defaultPassword != null) {
            return defaultPassword;
        }
        java.io.Console console = System.console();
        if (console != null) {
            char[] password = console.readPassword("Password: ", new Object[0]);
            if (password != null) {
                return new String(password);
            }
            return "";
        }
        LineReader reader = LineReaderBuilder.builder().terminal(TerminalUtils.getTerminal()).build();
        return reader.readLine("Password: ", Character.valueOf('\u0000'));
    }

    private static void runConsole(QueryRunner queryRunner, AtomicBoolean exiting, ClientOptions.EditingMode editingMode) {
        try {
            TableNameCompleter tableNameCompleter = new TableNameCompleter(queryRunner);
            try (InputReader reader = new InputReader(editingMode, Console.getHistoryFile(), Completion.commandCompleter(), tableNameCompleter);){
                tableNameCompleter.populateCache();
                String remaining = "";
                block32: while (!exiting.get()) {
                    String line;
                    String prompt = PROMPT_NAME;
                    String schema = queryRunner.getSession().getSchema();
                    if (schema != null) {
                        prompt = prompt + ":" + schema.replace("%", "%%");
                    }
                    String commandPrompt = prompt + "> ";
                    try {
                        line = reader.readLine(commandPrompt, remaining);
                    }
                    catch (UserInterruptException e) {
                        if (!e.getPartialLine().isEmpty()) {
                            reader.getHistory().add(e.getPartialLine());
                        }
                        remaining = "";
                        continue;
                    }
                    catch (EndOfFileException e) {
                        System.out.println();
                        reader.close();
                        tableNameCompleter.close();
                        return;
                    }
                    String command = CharMatcher.is((char)';').or(CharMatcher.whitespace()).trimTrailingFrom((CharSequence)line);
                    switch (command.toLowerCase(Locale.ENGLISH)) {
                        case "exit": 
                        case "quit": {
                            return;
                        }
                        case "clear": {
                            Terminal terminal = reader.getTerminal();
                            terminal.puts(InfoCmp.Capability.clear_screen, new Object[0]);
                            terminal.flush();
                            continue block32;
                        }
                        case "history": {
                            for (History.Entry entry : reader.getHistory()) {
                                System.out.println(new AttributedStringBuilder().style(AttributedStyle.DEFAULT.foreground(6)).append((CharSequence)String.format("%5d", entry.index() + 1)).style(AttributedStyle.DEFAULT).append((CharSequence)"  ").append((CharSequence)entry.line()).toAnsi(reader.getTerminal()));
                            }
                            continue block32;
                        }
                        case "help": {
                            System.out.println();
                            System.out.println(Help.getHelpText());
                            continue block32;
                        }
                    }
                    StatementSplitter splitter = new StatementSplitter(line, STATEMENT_DELIMITERS);
                    for (StatementSplitter.Statement split : splitter.getCompleteStatements()) {
                        ClientOptions.OutputFormat outputFormat = ClientOptions.OutputFormat.ALIGNED;
                        if (split.terminator().equals("\\G")) {
                            outputFormat = ClientOptions.OutputFormat.VERTICAL;
                        }
                        Console.process(queryRunner, split.statement(), outputFormat, tableNameCompleter::populateCache, true, true, reader.getTerminal(), System.out, System.out);
                    }
                    remaining = CharMatcher.whitespace().trimTrailingFrom((CharSequence)splitter.getPartialStatement());
                }
            }
            finally {
                try {
                    tableNameCompleter.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
    }

    private static boolean executeCommand(QueryRunner queryRunner, AtomicBoolean exiting, String query, ClientOptions.OutputFormat outputFormat, boolean ignoreErrors, boolean showProgress) {
        boolean success = true;
        StatementSplitter splitter = new StatementSplitter(query);
        for (StatementSplitter.Statement split : splitter.getCompleteStatements()) {
            if (!StatementSplitter.isEmptyStatement((String)split.statement()) && !Console.process(queryRunner, split.statement(), outputFormat, () -> {}, false, showProgress, TerminalUtils.getTerminal(), System.out, System.err)) {
                if (!ignoreErrors) {
                    return false;
                }
                success = false;
            }
            if (!exiting.get()) continue;
            return success;
        }
        if (!StatementSplitter.isEmptyStatement((String)splitter.getPartialStatement())) {
            System.err.println("Non-terminated statement: " + splitter.getPartialStatement());
            return false;
        }
        return success;
    }

    private static boolean process(QueryRunner queryRunner, String sql, ClientOptions.OutputFormat outputFormat, Runnable schemaChanged, boolean usePager, boolean showProgress, Terminal terminal, PrintStream out, PrintStream errorChannel) {
        String finalSql;
        try {
            finalSql = QueryPreprocessor.preprocessQuery(terminal, Optional.ofNullable(queryRunner.getSession().getCatalog()), Optional.ofNullable(queryRunner.getSession().getSchema()), sql);
        }
        catch (QueryPreprocessorException e) {
            System.err.println(e.getMessage());
            if (queryRunner.isDebug()) {
                e.printStackTrace(System.err);
            }
            return false;
        }
        Query query = queryRunner.startQuery(finalSql);
        try {
            boolean success = query.renderOutput(terminal, out, errorChannel, outputFormat, usePager, showProgress);
            ClientSession session = queryRunner.getSession();
            if (query.getSetCatalog().isPresent() || query.getSetSchema().isPresent()) {
                session = ClientSession.builder((ClientSession)session).withCatalog(query.getSetCatalog().orElse(session.getCatalog())).withSchema(query.getSetSchema().orElse(session.getSchema())).build();
            }
            if (query.isClearTransactionId()) {
                session = ClientSession.stripTransactionId((ClientSession)session);
            }
            ClientSession.Builder builder = ClientSession.builder((ClientSession)session);
            if (query.getStartedTransactionId() != null) {
                builder = builder.withTransactionId(query.getStartedTransactionId());
            }
            if (query.getSetPath().isPresent()) {
                builder = builder.withPath(query.getSetPath().get());
            }
            if (!query.getSetSessionProperties().isEmpty() || !query.getResetSessionProperties().isEmpty()) {
                HashMap<String, String> sessionProperties = new HashMap<String, String>(session.getProperties());
                sessionProperties.putAll(query.getSetSessionProperties());
                sessionProperties.keySet().removeAll(query.getResetSessionProperties());
                builder = builder.withProperties(sessionProperties);
            }
            if (!query.getSetRoles().isEmpty()) {
                HashMap<String, ClientSelectedRole> roles = new HashMap<String, ClientSelectedRole>(session.getRoles());
                roles.putAll(query.getSetRoles());
                builder = builder.withRoles(roles);
            }
            if (!query.getAddedPreparedStatements().isEmpty() || !query.getDeallocatedPreparedStatements().isEmpty()) {
                HashMap<String, String> preparedStatements = new HashMap<String, String>(session.getPreparedStatements());
                preparedStatements.putAll(query.getAddedPreparedStatements());
                preparedStatements.keySet().removeAll(query.getDeallocatedPreparedStatements());
                builder = builder.withPreparedStatements(preparedStatements);
            }
            session = builder.build();
            queryRunner.setSession(session);
            if (query.getSetCatalog().isPresent() || query.getSetSchema().isPresent()) {
                schemaChanged.run();
            }
            boolean bl = success;
            if (query != null) {
                query.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (query != null) {
                    try {
                        query.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RuntimeException e) {
                System.err.println("Error running command: " + e.getMessage());
                if (queryRunner.isDebug()) {
                    e.printStackTrace(System.err);
                }
                return false;
            }
        }
    }

    private static Path getHistoryFile() {
        String path = System.getenv("TRINO_HISTORY_FILE");
        if (!Strings.isNullOrEmpty((String)path)) {
            return Paths.get(path, new String[0]);
        }
        return Paths.get(Strings.nullToEmpty((String)StandardSystemProperty.USER_HOME.value()), ".trino_history");
    }
}

