/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cli;

import com.google.common.base.Preconditions;
import com.google.common.net.HostAndPort;
import io.airlift.log.Logger;
import io.trino.cli.Query;
import io.trino.client.ClientSession;
import io.trino.client.OkHttpUtil;
import io.trino.client.StatementClient;
import io.trino.client.StatementClientFactory;
import io.trino.client.auth.external.ExternalAuthenticator;
import io.trino.client.auth.external.HttpTokenPoller;
import io.trino.client.auth.external.RedirectHandler;
import io.trino.client.auth.external.TokenPoller;
import java.io.Closeable;
import java.io.File;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import okhttp3.Authenticator;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public class QueryRunner
implements Closeable {
    private static final Logger log = Logger.get(QueryRunner.class);
    private final AtomicReference<ClientSession> session;
    private final boolean debug;
    private final OkHttpClient httpClient;
    private final Consumer<OkHttpClient.Builder> sslSetup;

    public QueryRunner(ClientSession session, boolean debug, Optional<HostAndPort> socksProxy, Optional<HostAndPort> httpProxy, Optional<String> keystorePath, Optional<String> keystorePassword, Optional<String> keystoreType, Optional<String> truststorePath, Optional<String> truststorePassword, Optional<String> truststoreType, boolean insecureSsl, Optional<String> accessToken, Optional<String> user, Optional<String> password, Optional<String> kerberosPrincipal, Optional<String> krb5ServicePrincipalPattern, Optional<String> kerberosRemoteServiceName, Optional<String> kerberosConfigPath, Optional<String> kerberosKeytabPath, Optional<String> kerberosCredentialCachePath, boolean kerberosUseCanonicalHostname, boolean externalAuthentication) {
        this.session = new AtomicReference<ClientSession>(Objects.requireNonNull(session, "session is null"));
        this.debug = debug;
        this.sslSetup = insecureSsl ? OkHttpUtil::setupInsecureSsl : builder -> OkHttpUtil.setupSsl((OkHttpClient.Builder)builder, (Optional)keystorePath, (Optional)keystorePassword, (Optional)keystoreType, (Optional)truststorePath, (Optional)truststorePassword, (Optional)truststoreType);
        OkHttpClient.Builder builder2 = new OkHttpClient.Builder();
        OkHttpUtil.setupTimeouts((OkHttpClient.Builder)builder2, (int)30, (TimeUnit)TimeUnit.SECONDS);
        OkHttpUtil.setupCookieJar((OkHttpClient.Builder)builder2);
        OkHttpUtil.setupSocksProxy((OkHttpClient.Builder)builder2, socksProxy);
        OkHttpUtil.setupHttpProxy((OkHttpClient.Builder)builder2, httpProxy);
        QueryRunner.setupBasicAuth(builder2, session, user, password);
        QueryRunner.setupTokenAuth(builder2, session, accessToken);
        QueryRunner.setupExternalAuth(builder2, session, externalAuthentication, this.sslSetup);
        QueryRunner.setupNetworkLogging(builder2);
        if (kerberosRemoteServiceName.isPresent()) {
            Preconditions.checkArgument((boolean)session.getServer().getScheme().equalsIgnoreCase("https"), (Object)"Authentication using Kerberos requires HTTPS to be enabled");
            OkHttpUtil.setupKerberos((OkHttpClient.Builder)builder2, (String)krb5ServicePrincipalPattern.get(), (String)kerberosRemoteServiceName.get(), (boolean)kerberosUseCanonicalHostname, kerberosPrincipal, kerberosConfigPath.map(File::new), kerberosKeytabPath.map(File::new), kerberosCredentialCachePath.map(File::new));
        }
        this.httpClient = builder2.build();
    }

    public ClientSession getSession() {
        return this.session.get();
    }

    public void setSession(ClientSession session) {
        this.session.set(Objects.requireNonNull(session, "session is null"));
    }

    public boolean isDebug() {
        return this.debug;
    }

    public Query startQuery(String query) {
        return new Query(this.startInternalQuery(this.session.get(), query), this.debug);
    }

    public StatementClient startInternalQuery(String query) {
        return this.startInternalQuery(ClientSession.stripTransactionId((ClientSession)this.session.get()), query);
    }

    private StatementClient startInternalQuery(ClientSession session, String query) {
        OkHttpClient.Builder builder = this.httpClient.newBuilder();
        this.sslSetup.accept(builder);
        OkHttpClient client = builder.build();
        return StatementClientFactory.newStatementClient((OkHttpClient)client, (ClientSession)session, (String)query);
    }

    @Override
    public void close() {
        this.httpClient.dispatcher().executorService().shutdown();
        this.httpClient.connectionPool().evictAll();
    }

    private static void setupBasicAuth(OkHttpClient.Builder clientBuilder, ClientSession session, Optional<String> user, Optional<String> password) {
        if (user.isPresent() && password.isPresent()) {
            Preconditions.checkArgument((boolean)session.getServer().getScheme().equalsIgnoreCase("https"), (Object)"Authentication using username/password requires HTTPS to be enabled");
            clientBuilder.addInterceptor(OkHttpUtil.basicAuth((String)user.get(), (String)password.get()));
        }
    }

    private static void setupExternalAuth(OkHttpClient.Builder builder, ClientSession session, boolean enabled, Consumer<OkHttpClient.Builder> sslSetup) {
        if (!enabled) {
            return;
        }
        Preconditions.checkArgument((boolean)session.getServer().getScheme().equalsIgnoreCase("https"), (Object)"Authentication using externalAuthentication requires HTTPS to be enabled");
        RedirectHandler redirectHandler = uri -> {
            System.out.println("External authentication required. Please go to:");
            System.out.println(uri.toString());
        };
        HttpTokenPoller poller = new HttpTokenPoller(builder.build(), sslSetup);
        ExternalAuthenticator authenticator = new ExternalAuthenticator(redirectHandler, (TokenPoller)poller, Duration.ofMinutes(10L));
        builder.authenticator((Authenticator)authenticator);
        builder.addInterceptor((Interceptor)authenticator);
    }

    private static void setupTokenAuth(OkHttpClient.Builder clientBuilder, ClientSession session, Optional<String> accessToken) {
        if (accessToken.isPresent()) {
            Preconditions.checkArgument((boolean)session.getServer().getScheme().equalsIgnoreCase("https"), (Object)"Authentication using an access token requires HTTPS to be enabled");
            clientBuilder.addInterceptor(OkHttpUtil.tokenAuth((String)accessToken.get()));
        }
    }

    private static void setupNetworkLogging(OkHttpClient.Builder clientBuilder) {
        clientBuilder.addNetworkInterceptor(OkHttpUtil.interceptRequest(request -> log.debug("Sending %s request to %s", new Object[]{request.method(), request.url().uri()})));
    }
}

