/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.blackhole;

import com.google.common.collect.ImmutableList;
import io.airlift.units.Duration;
import io.trino.plugin.blackhole.BlackHoleColumnHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.SchemaTableName;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public record BlackHoleTableHandle(String schemaName, String tableName, List<BlackHoleColumnHandle> columnHandles, int splitCount, int pagesPerSplit, int rowsPerPage, int fieldsLength, Duration pageProcessingDelay) implements ConnectorTableHandle
{
    public BlackHoleTableHandle {
        Objects.requireNonNull(schemaName, "schemaName is null");
        Objects.requireNonNull(tableName, "tableName is null");
        columnHandles = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnHandles, "columnHandles is null"));
        Objects.requireNonNull(pageProcessingDelay, "pageProcessingDelay is null");
    }

    public BlackHoleTableHandle withColumnHandles(List<BlackHoleColumnHandle> columnHandles) {
        return new BlackHoleTableHandle(this.schemaName, this.tableName, (List<BlackHoleColumnHandle>)ImmutableList.copyOf(columnHandles), this.splitCount, this.pagesPerSplit, this.rowsPerPage, this.fieldsLength, this.pageProcessingDelay);
    }

    public ConnectorTableMetadata toTableMetadata() {
        return new ConnectorTableMetadata(this.toSchemaTableName(), this.columnHandles.stream().map(BlackHoleColumnHandle::toColumnMetadata).collect(Collectors.toList()));
    }

    public SchemaTableName toSchemaTableName() {
        return new SchemaTableName(this.schemaName, this.tableName);
    }

    @Override
    public String toString() {
        return this.schemaName + ":" + this.tableName;
    }
}

