/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.blackhole;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.airlift.slice.Slice;
import io.airlift.units.Duration;
import io.trino.plugin.blackhole.BlackHoleColumnHandle;
import io.trino.plugin.blackhole.BlackHoleInsertTableHandle;
import io.trino.plugin.blackhole.BlackHoleMergeTableHandle;
import io.trino.plugin.blackhole.BlackHoleOutputTableHandle;
import io.trino.plugin.blackhole.BlackHolePageSourceProvider;
import io.trino.plugin.blackhole.BlackHolePartitioningHandle;
import io.trino.plugin.blackhole.BlackHoleTableHandle;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorAnalyzeMetadata;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.ConnectorMergeTableHandle;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorOutputMetadata;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.ConnectorPartitioningHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableLayout;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTableVersion;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.spi.connector.RetryMode;
import io.trino.spi.connector.RowChangeParadigm;
import io.trino.spi.connector.SchemaNotFoundException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SchemaTablePrefix;
import io.trino.spi.connector.TableColumnsMetadata;
import io.trino.spi.connector.ViewNotFoundException;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.statistics.ColumnStatistics;
import io.trino.spi.statistics.ComputedStatistics;
import io.trino.spi.statistics.DoubleRange;
import io.trino.spi.statistics.Estimate;
import io.trino.spi.statistics.TableStatistics;
import io.trino.spi.statistics.TableStatisticsMetadata;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;

public class BlackHoleMetadata
implements ConnectorMetadata {
    private static final String SCHEMA_NAME = "default";
    private final List<String> schemas = new ArrayList<String>();
    private final Map<SchemaTableName, BlackHoleTableHandle> tables = new ConcurrentHashMap<SchemaTableName, BlackHoleTableHandle>();
    private final Map<SchemaTableName, ConnectorViewDefinition> views = new ConcurrentHashMap<SchemaTableName, ConnectorViewDefinition>();

    public BlackHoleMetadata() {
        this.schemas.add(SCHEMA_NAME);
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return ImmutableList.copyOf(this.schemas);
    }

    public synchronized void createSchema(ConnectorSession session, String schemaName, Map<String, Object> properties, TrinoPrincipal owner) {
        if (this.schemas.contains(schemaName)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, String.format("Schema [%s] already exists", schemaName));
        }
        this.schemas.add(schemaName);
    }

    public ConnectorTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName, Optional<ConnectorTableVersion> startVersion, Optional<ConnectorTableVersion> endVersion) {
        if (startVersion.isPresent() || endVersion.isPresent()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support versioned tables");
        }
        return this.tables.get(tableName);
    }

    public ConnectorAnalyzeMetadata getStatisticsCollectionMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, Map<String, Object> analyzeProperties) {
        return new ConnectorAnalyzeMetadata(tableHandle, TableStatisticsMetadata.empty());
    }

    public ConnectorTableHandle beginStatisticsCollection(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return tableHandle;
    }

    public void finishStatisticsCollection(ConnectorSession session, ConnectorTableHandle tableHandle, Collection<ComputedStatistics> computedStatistics) {
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        BlackHoleTableHandle blackHoleTableHandle = (BlackHoleTableHandle)tableHandle;
        return blackHoleTableHandle.toTableMetadata();
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        return ImmutableSet.builder().addAll((Iterable)this.tables.values().stream().filter(table -> schemaName.isEmpty() || table.schemaName().equals(schemaName.get())).map(BlackHoleTableHandle::toSchemaTableName).collect(Collectors.toList())).addAll(this.listViews(session, schemaName)).addAll((Iterable)this.listMaterializedViews(session, schemaName)).build().asList();
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        BlackHoleTableHandle blackHoleTableHandle = (BlackHoleTableHandle)tableHandle;
        return (Map)blackHoleTableHandle.columnHandles().stream().collect(ImmutableMap.toImmutableMap(BlackHoleColumnHandle::name, Function.identity()));
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        BlackHoleColumnHandle blackHoleColumnHandle = (BlackHoleColumnHandle)columnHandle;
        return blackHoleColumnHandle.toColumnMetadata();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        throw new UnsupportedOperationException("The deprecated listTableColumns is not supported because streamTableColumns is implemented instead");
    }

    public Iterator<TableColumnsMetadata> streamTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        return this.tables.values().stream().filter(table -> prefix.matches(table.toSchemaTableName())).map(handle -> TableColumnsMetadata.forTable((SchemaTableName)handle.toSchemaTableName(), (List)handle.toTableMetadata().getColumns())).iterator();
    }

    public void addColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnMetadata column) {
        BlackHoleTableHandle table = (BlackHoleTableHandle)tableHandle;
        ImmutableList columns = ImmutableList.builderWithExpectedSize((int)(table.columnHandles().size() + 1)).addAll(table.columnHandles()).add((Object)new BlackHoleColumnHandle(column.getName(), column.getType())).build();
        this.tables.put(table.toSchemaTableName(), table.withColumnHandles((List<BlackHoleColumnHandle>)columns));
    }

    public void dropColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        BlackHoleTableHandle table = (BlackHoleTableHandle)tableHandle;
        BlackHoleColumnHandle column = (BlackHoleColumnHandle)columnHandle;
        List columns = (List)table.columnHandles().stream().filter(c -> !c.name().equals(column.name())).collect(ImmutableList.toImmutableList());
        this.tables.put(table.toSchemaTableName(), table.withColumnHandles(columns));
    }

    public void renameColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle, String target) {
        BlackHoleTableHandle table = (BlackHoleTableHandle)tableHandle;
        BlackHoleColumnHandle column = (BlackHoleColumnHandle)columnHandle;
        List columns = (List)table.columnHandles().stream().map(c -> c.name().equals(column.name()) ? new BlackHoleColumnHandle(target, c.columnType()) : c).collect(ImmutableList.toImmutableList());
        this.tables.put(table.toSchemaTableName(), table.withColumnHandles(columns));
    }

    public void setColumnType(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle, Type type) {
        BlackHoleTableHandle table = (BlackHoleTableHandle)tableHandle;
        BlackHoleColumnHandle column = (BlackHoleColumnHandle)columnHandle;
        ArrayList<BlackHoleColumnHandle> columns = new ArrayList<BlackHoleColumnHandle>(table.columnHandles());
        columns.set(columns.indexOf(column), new BlackHoleColumnHandle(column.name(), type));
        this.tables.put(table.toSchemaTableName(), table.withColumnHandles((List<BlackHoleColumnHandle>)ImmutableList.copyOf(columns)));
    }

    public TableStatistics getTableStatistics(ConnectorSession session, ConnectorTableHandle tableHandle) {
        BlackHoleTableHandle table = (BlackHoleTableHandle)tableHandle;
        TableStatistics.Builder tableStats = TableStatistics.builder();
        double rows = (double)table.splitCount() * (double)table.pagesPerSplit() * (double)table.rowsPerPage();
        tableStats.setRowCount(Estimate.of((double)rows));
        for (BlackHoleColumnHandle column : table.columnHandles()) {
            ColumnStatistics.Builder stats = ColumnStatistics.builder().setDistinctValuesCount(Estimate.of((double)1.0)).setNullsFraction(Estimate.of((double)0.0));
            if (BlackHolePageSourceProvider.isNumericType(column.columnType())) {
                stats.setRange(new DoubleRange(0.0, 0.0));
            }
            tableStats.setColumnStatistics((ColumnHandle)column, stats.build());
        }
        return tableStats.build();
    }

    public void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        BlackHoleTableHandle blackHoleTableHandle = (BlackHoleTableHandle)tableHandle;
        this.tables.remove(blackHoleTableHandle.toSchemaTableName());
    }

    public void renameTable(ConnectorSession session, ConnectorTableHandle tableHandle, SchemaTableName newTableName) {
        BlackHoleTableHandle oldTableHandle = (BlackHoleTableHandle)tableHandle;
        BlackHoleTableHandle newTableHandle = new BlackHoleTableHandle(oldTableHandle.schemaName(), newTableName.getTableName(), oldTableHandle.columnHandles(), oldTableHandle.splitCount(), oldTableHandle.pagesPerSplit(), oldTableHandle.rowsPerPage(), oldTableHandle.fieldsLength(), oldTableHandle.pageProcessingDelay());
        this.tables.remove(oldTableHandle.toSchemaTableName());
        this.tables.put(newTableName, newTableHandle);
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, boolean ignoreExisting) {
        ConnectorOutputTableHandle outputTableHandle = this.beginCreateTable(session, tableMetadata, Optional.empty(), RetryMode.NO_RETRIES);
        this.finishCreateTable(session, outputTableHandle, (Collection<Slice>)ImmutableList.of(), (Collection<ComputedStatistics>)ImmutableList.of());
    }

    public Optional<ConnectorTableLayout> getNewTableLayout(ConnectorSession connectorSession, ConnectorTableMetadata tableMetadata) {
        List distributeColumns = (List)tableMetadata.getProperties().get("distributed_on");
        if (distributeColumns.isEmpty()) {
            return Optional.empty();
        }
        Sets.SetView undefinedColumns = Sets.difference((Set)ImmutableSet.copyOf((Collection)distributeColumns), tableMetadata.getColumns().stream().map(ColumnMetadata::getName).collect(Collectors.toSet()));
        if (!undefinedColumns.isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "Distribute columns not defined on table: " + String.valueOf(undefinedColumns));
        }
        return Optional.of(new ConnectorTableLayout((ConnectorPartitioningHandle)BlackHolePartitioningHandle.INSTANCE, distributeColumns, true));
    }

    public ConnectorOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorTableLayout> layout, RetryMode retryMode) {
        this.checkSchemaExists(tableMetadata.getTable().getSchemaName());
        int splitCount = (Integer)tableMetadata.getProperties().get("split_count");
        int pagesPerSplit = (Integer)tableMetadata.getProperties().get("pages_per_split");
        int rowsPerPage = (Integer)tableMetadata.getProperties().get("rows_per_page");
        int fieldsLength = (Integer)tableMetadata.getProperties().get("field_length");
        if (splitCount < 0) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "split_count property is negative");
        }
        if (pagesPerSplit < 0) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "pages_per_split property is negative");
        }
        if (rowsPerPage < 0) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "rows_per_page property is negative");
        }
        if (!(splitCount <= 0 && pagesPerSplit <= 0 && rowsPerPage <= 0 || splitCount != 0 && pagesPerSplit != 0 && rowsPerPage != 0)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("All properties [%s, %s, %s] must be set if any are set", "split_count", "pages_per_split", "rows_per_page"));
        }
        Duration pageProcessingDelay = (Duration)tableMetadata.getProperties().get("page_processing_delay");
        BlackHoleTableHandle handle = new BlackHoleTableHandle(tableMetadata.getTable().getSchemaName(), tableMetadata.getTable().getTableName(), tableMetadata.getColumns().stream().map(column -> new BlackHoleColumnHandle(column.getName(), column.getType())).collect(Collectors.toList()), splitCount, pagesPerSplit, rowsPerPage, fieldsLength, pageProcessingDelay);
        return new BlackHoleOutputTableHandle(handle, pageProcessingDelay);
    }

    public Optional<ConnectorOutputMetadata> finishCreateTable(ConnectorSession session, ConnectorOutputTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        BlackHoleOutputTableHandle blackHoleOutputTableHandle = (BlackHoleOutputTableHandle)tableHandle;
        BlackHoleTableHandle table = blackHoleOutputTableHandle.table();
        this.tables.put(table.toSchemaTableName(), table);
        return Optional.empty();
    }

    public ConnectorInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle, List<ColumnHandle> columns, RetryMode retryMode) {
        BlackHoleTableHandle handle = (BlackHoleTableHandle)tableHandle;
        return new BlackHoleInsertTableHandle(handle.pageProcessingDelay());
    }

    public Optional<ConnectorOutputMetadata> finishInsert(ConnectorSession session, ConnectorInsertTableHandle insertHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        return Optional.empty();
    }

    public RowChangeParadigm getRowChangeParadigm(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return RowChangeParadigm.DELETE_ROW_AND_INSERT_ROW;
    }

    public ColumnHandle getMergeRowIdColumnHandle(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return new BlackHoleColumnHandle("row_id", (Type)BigintType.BIGINT);
    }

    public ConnectorMergeTableHandle beginMerge(ConnectorSession session, ConnectorTableHandle tableHandle, RetryMode retryMode) {
        return new BlackHoleMergeTableHandle((BlackHoleTableHandle)tableHandle);
    }

    public void finishMerge(ConnectorSession session, ConnectorMergeTableHandle mergeTableHandle, List<ConnectorTableHandle> sourceTableHandles, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
    }

    public void truncateTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
    }

    public void createView(ConnectorSession session, SchemaTableName viewName, ConnectorViewDefinition definition, boolean replace) {
        this.views.put(viewName, definition);
    }

    public void dropView(ConnectorSession session, SchemaTableName viewName) {
        this.views.remove(viewName);
    }

    public List<SchemaTableName> listViews(ConnectorSession session, Optional<String> schemaName) {
        return ImmutableList.copyOf(this.views.keySet());
    }

    public Map<SchemaTableName, ConnectorViewDefinition> getViews(ConnectorSession session, Optional<String> schemaName) {
        return ImmutableMap.copyOf(this.views);
    }

    public Optional<ConnectorViewDefinition> getView(ConnectorSession session, SchemaTableName viewName) {
        return Optional.ofNullable(this.views.get(viewName));
    }

    private void checkSchemaExists(String schemaName) {
        if (!this.schemas.contains(schemaName)) {
            throw new SchemaNotFoundException(schemaName);
        }
    }

    public void setViewComment(ConnectorSession session, SchemaTableName viewName, Optional<String> comment) {
        ConnectorViewDefinition view = this.getView(session, viewName).orElseThrow(() -> new ViewNotFoundException(viewName));
        this.views.put(viewName, new ConnectorViewDefinition(view.getOriginalSql(), view.getCatalog(), view.getSchema(), view.getColumns(), comment, view.getOwner(), view.isRunAsInvoker(), view.getPath()));
    }

    public void setViewColumnComment(ConnectorSession session, SchemaTableName viewName, String columnName, Optional<String> comment) {
        ConnectorViewDefinition view = this.getView(session, viewName).orElseThrow(() -> new ViewNotFoundException(viewName));
        this.views.put(viewName, new ConnectorViewDefinition(view.getOriginalSql(), view.getCatalog(), view.getSchema(), (List)view.getColumns().stream().map(currentViewColumn -> Objects.equals(columnName, currentViewColumn.getName()) ? new ConnectorViewDefinition.ViewColumn(currentViewColumn.getName(), currentViewColumn.getType(), comment) : currentViewColumn).collect(ImmutableList.toImmutableList()), view.getComment(), view.getOwner(), view.isRunAsInvoker(), view.getPath()));
    }
}

