/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.blackhole;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.airlift.units.Duration;
import io.trino.plugin.blackhole.BlackHoleColumnHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.SchemaTableName;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class BlackHoleTableHandle
implements ConnectorTableHandle {
    private final String schemaName;
    private final String tableName;
    private final List<BlackHoleColumnHandle> columnHandles;
    private final int splitCount;
    private final int pagesPerSplit;
    private final int rowsPerPage;
    private final int fieldsLength;
    private final Duration pageProcessingDelay;

    public BlackHoleTableHandle(ConnectorTableMetadata tableMetadata, int splitCount, int pagesPerSplit, int rowsPerPage, int fieldsLength, Duration pageProcessingDelay) {
        this(tableMetadata.getTable().getSchemaName(), tableMetadata.getTable().getTableName(), tableMetadata.getColumns().stream().map(BlackHoleColumnHandle::new).collect(Collectors.toList()), splitCount, pagesPerSplit, rowsPerPage, fieldsLength, pageProcessingDelay);
    }

    @JsonCreator
    public BlackHoleTableHandle(@JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="columnHandles") List<BlackHoleColumnHandle> columnHandles, @JsonProperty(value="splitCount") int splitCount, @JsonProperty(value="pagesPerSplit") int pagesPerSplit, @JsonProperty(value="rowsPerPage") int rowsPerPage, @JsonProperty(value="fieldsLength") int fieldsLength, @JsonProperty(value="pageProcessingDelay") Duration pageProcessingDelay) {
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.columnHandles = columnHandles;
        this.splitCount = splitCount;
        this.pagesPerSplit = pagesPerSplit;
        this.rowsPerPage = rowsPerPage;
        this.fieldsLength = fieldsLength;
        this.pageProcessingDelay = pageProcessingDelay;
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public List<BlackHoleColumnHandle> getColumnHandles() {
        return this.columnHandles;
    }

    @JsonProperty
    public int getSplitCount() {
        return this.splitCount;
    }

    @JsonProperty
    public int getPagesPerSplit() {
        return this.pagesPerSplit;
    }

    @JsonProperty
    public int getRowsPerPage() {
        return this.rowsPerPage;
    }

    @JsonProperty
    public int getFieldsLength() {
        return this.fieldsLength;
    }

    @JsonProperty
    public Duration getPageProcessingDelay() {
        return this.pageProcessingDelay;
    }

    public ConnectorTableMetadata toTableMetadata() {
        return new ConnectorTableMetadata(this.toSchemaTableName(), this.columnHandles.stream().map(BlackHoleColumnHandle::toColumnMetadata).collect(Collectors.toList()));
    }

    public SchemaTableName toSchemaTableName() {
        return new SchemaTableName(this.schemaName, this.tableName);
    }

    public int hashCode() {
        return Objects.hash(this.schemaName, this.tableName, this.columnHandles, this.splitCount, this.pagesPerSplit, this.rowsPerPage, this.fieldsLength, this.pageProcessingDelay);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BlackHoleTableHandle other = (BlackHoleTableHandle)obj;
        return Objects.equals(this.schemaName, other.schemaName) && Objects.equals(this.tableName, other.tableName) && Objects.equals(this.columnHandles, other.columnHandles) && this.splitCount == other.splitCount && this.pagesPerSplit == other.pagesPerSplit && this.rowsPerPage == other.rowsPerPage && this.fieldsLength == other.fieldsLength && Objects.equals(this.pageProcessingDelay, other.pageProcessingDelay);
    }

    public String toString() {
        return this.schemaName + ":" + this.tableName;
    }
}

