/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.mapreduce;

import io.trino.hive.$internal.com.google.common.collect.Maps;
import io.trino.hive.$internal.org.slf4j.Logger;
import io.trino.hive.$internal.org.slf4j.LoggerFactory;
import io.trino.hive.orc.OrcConf;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.RCFileOutputFormat;
import org.apache.hadoop.hive.ql.io.avro.AvroContainerOutputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat;
import org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat;
import org.apache.hadoop.hive.ql.io.parquet.convert.HiveSchemaConverter;
import org.apache.hadoop.hive.ql.io.parquet.serde.ParquetTableUtils;
import org.apache.hadoop.hive.serde2.avro.AvroSerDe;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeUtils;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hive.hcatalog.data.schema.HCatFieldSchema;
import org.apache.hive.hcatalog.mapreduce.HCatTableInfo;
import org.apache.hive.hcatalog.mapreduce.OutputJobInfo;

public class SpecialCases {
    private static final Logger LOG = LoggerFactory.getLogger(SpecialCases.class);

    public static void addSpecialCasesParametersToOutputJobProperties(Map<String, String> jobProperties, OutputJobInfo jobInfo, Class<? extends OutputFormat> ofclass) {
        if (ofclass == RCFileOutputFormat.class) {
            jobProperties.put(HiveConf.ConfVars.HIVE_RCFILE_COLUMN_NUMBER_CONF.varname, Integer.toOctalString(jobInfo.getOutputSchema().getFields().size()));
        } else if (ofclass == OrcOutputFormat.class) {
            Map<String, String> tableProps = jobInfo.getTableInfo().getTable().getParameters();
            for (OrcConf property : OrcConf.values()) {
                String propName = property.getAttribute();
                if (!tableProps.containsKey(propName)) continue;
                jobProperties.put(propName, tableProps.get(propName));
            }
        } else if (ofclass == AvroContainerOutputFormat.class) {
            Map<String, String> tableProps = jobInfo.getTableInfo().getTable().getParameters();
            for (Object property : AvroSerdeUtils.AvroTableProperties.values()) {
                String propName = property.getPropName();
                if (!tableProps.containsKey(propName)) continue;
                String propVal = tableProps.get(propName);
                jobProperties.put(propName, tableProps.get(propName));
            }
            Properties properties = new Properties();
            properties.put("name", jobInfo.getTableName());
            List<String> colNames = jobInfo.getOutputSchema().getFieldNames();
            ArrayList<TypeInfo> colTypes = new ArrayList<TypeInfo>();
            for (HCatFieldSchema field : jobInfo.getOutputSchema().getFields()) {
                colTypes.add(TypeInfoUtils.getTypeInfoFromTypeString(field.getTypeString()));
            }
            if (jobProperties.get(AvroSerdeUtils.AvroTableProperties.SCHEMA_LITERAL.getPropName()) == null || jobProperties.get(AvroSerdeUtils.AvroTableProperties.SCHEMA_LITERAL.getPropName()).isEmpty()) {
                jobProperties.put(AvroSerdeUtils.AvroTableProperties.SCHEMA_LITERAL.getPropName(), AvroSerDe.getSchemaFromCols(properties, colNames, colTypes, null).toString());
            }
        } else if (ofclass == MapredParquetOutputFormat.class) {
            Properties tblProperties = new Properties();
            Map<String, String> tableProps = jobInfo.getTableInfo().getTable().getParameters();
            for (String key : tableProps.keySet()) {
                if (!ParquetTableUtils.isParquetProperty(key)) continue;
                tblProperties.put(key, tableProps.get(key));
            }
            List<String> colNames = jobInfo.getOutputSchema().getFieldNames();
            ArrayList<TypeInfo> colTypes = new ArrayList<TypeInfo>();
            for (HCatFieldSchema field : jobInfo.getOutputSchema().getFields()) {
                colTypes.add(TypeInfoUtils.getTypeInfoFromTypeString(field.getTypeString()));
            }
            String parquetSchema = HiveSchemaConverter.convert(colNames, colTypes).toString();
            jobProperties.put("parquet.hive.schema", parquetSchema);
            jobProperties.putAll(Maps.fromProperties(tblProperties));
        }
    }

    public static void addSpecialCasesParametersForHCatLoader(Configuration conf, HCatTableInfo tableInfo) {
        if (tableInfo == null || tableInfo.getStorerInfo() == null) {
            return;
        }
        String shClass = tableInfo.getStorerInfo().getStorageHandlerClass();
        if (shClass != null && shClass.equals("org.apache.hadoop.hive.hbase.HBaseStorageHandler")) {
            conf.set("pig.noSplitCombination", "true");
        }
    }
}

