/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.mapreduce;

import io.trino.hive.$internal.com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hive.hcatalog.common.HCatUtil;
import org.apache.hive.hcatalog.data.schema.HCatSchema;
import org.apache.hive.hcatalog.mapreduce.HCatBaseInputFormat;
import org.apache.hive.hcatalog.mapreduce.InitializeInput;
import org.apache.hive.hcatalog.mapreduce.InputJobInfo;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class HCatInputFormat
extends HCatBaseInputFormat {
    private Configuration conf;
    private InputJobInfo inputJobInfo;

    public static HCatInputFormat setInput(Job job, String dbName, String tableName) throws IOException {
        return HCatInputFormat.setInput(job.getConfiguration(), dbName, tableName, null);
    }

    public static HCatInputFormat setInput(Job job, String dbName, String tableName, String filter) throws IOException {
        return HCatInputFormat.setInput(job.getConfiguration(), dbName, tableName, filter);
    }

    public static HCatInputFormat setInput(Configuration conf, String dbName, String tableName) throws IOException {
        return HCatInputFormat.setInput(conf, dbName, tableName, null);
    }

    public static HCatInputFormat setInput(Configuration conf, String dbName, String tableName, String filter) throws IOException {
        Preconditions.checkNotNull(conf, "required argument 'conf' is null");
        Preconditions.checkNotNull(tableName, "required argument 'tableName' is null");
        HCatInputFormat hCatInputFormat = new HCatInputFormat();
        hCatInputFormat.conf = conf;
        hCatInputFormat.inputJobInfo = InputJobInfo.create(dbName, tableName, filter, null);
        try {
            InitializeInput.setInput(conf, hCatInputFormat.inputJobInfo);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return hCatInputFormat;
    }

    @Deprecated
    public HCatInputFormat setFilter(String filter) throws IOException {
        if (filter != null) {
            this.inputJobInfo = InputJobInfo.create(this.inputJobInfo.getDatabaseName(), this.inputJobInfo.getTableName(), filter, this.inputJobInfo.getProperties());
            try {
                InitializeInput.setInput(this.conf, this.inputJobInfo);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        return this;
    }

    public HCatInputFormat setProperties(Properties properties) throws IOException {
        Preconditions.checkNotNull(properties, "required argument 'properties' is null");
        this.inputJobInfo = InputJobInfo.create(this.inputJobInfo.getDatabaseName(), this.inputJobInfo.getTableName(), this.inputJobInfo.getFilter(), properties);
        try {
            InitializeInput.setInput(this.conf, this.inputJobInfo);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return this;
    }

    public static HCatSchema getPartitionColumns(Configuration conf) throws IOException {
        InputJobInfo inputInfo = (InputJobInfo)HCatUtil.deserialize(conf.get("mapreduce.lib.hcat.job.info"));
        Preconditions.checkNotNull(inputInfo, "inputJobInfo is null, setInput has not yet been called to save job into conf supplied.");
        return inputInfo.getTableInfo().getPartitionColumns();
    }

    public static HCatSchema getDataColumns(Configuration conf) throws IOException {
        InputJobInfo inputInfo = (InputJobInfo)HCatUtil.deserialize(conf.get("mapreduce.lib.hcat.job.info"));
        Preconditions.checkNotNull(inputInfo, "inputJobInfo is null, setInput has not yet been called to save job into conf supplied.");
        return inputInfo.getTableInfo().getDataColumns();
    }
}

