/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import io.trino.hive.$internal.org.codehaus.jackson.JsonFactory;
import io.trino.hive.$internal.org.codehaus.jackson.JsonParser;
import io.trino.hive.$internal.org.codehaus.jackson.map.ObjectMapper;
import io.trino.hive.$internal.org.codehaus.jackson.map.type.TypeFactory;
import io.trino.hive.$internal.org.codehaus.jackson.type.JavaType;
import io.trino.hive.$internal.org.slf4j.Logger;
import io.trino.hive.$internal.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.io.Text;

@Description(name="json_tuple", value="_FUNC_(jsonStr, p1, p2, ..., pn) - like get_json_object, but it takes multiple names and return a tuple. All the input parameters and output column types are string.")
public class GenericUDTFJSONTuple
extends GenericUDTF {
    private static final Logger LOG = LoggerFactory.getLogger(GenericUDTFJSONTuple.class.getName());
    private static final JsonFactory JSON_FACTORY = new JsonFactory();
    private static final ObjectMapper MAPPER;
    private static final JavaType MAP_TYPE;
    int numCols;
    String[] paths;
    private transient Text[] retCols;
    private transient Text[] cols;
    private transient Object[] nullCols;
    private transient ObjectInspector[] inputOIs;
    boolean pathParsed = false;
    boolean seenErrors = false;
    private transient Map<String, Object> jsonObjectCache;

    @Override
    public void close() throws HiveException {
    }

    @Override
    public StructObjectInspector initialize(ObjectInspector[] args) throws UDFArgumentException {
        int i;
        this.inputOIs = args;
        this.numCols = args.length - 1;
        this.jsonObjectCache = new HashCache<String, Object>();
        if (this.numCols < 1) {
            throw new UDFArgumentException("json_tuple() takes at least two arguments: the json string and a path expression");
        }
        for (i = 0; i < args.length; ++i) {
            if (args[i].getCategory() == ObjectInspector.Category.PRIMITIVE && args[i].getTypeName().equals("string")) continue;
            throw new UDFArgumentException("json_tuple()'s arguments have to be string type");
        }
        this.seenErrors = false;
        this.pathParsed = false;
        this.paths = new String[this.numCols];
        this.cols = new Text[this.numCols];
        this.retCols = new Text[this.numCols];
        this.nullCols = new Object[this.numCols];
        for (i = 0; i < this.numCols; ++i) {
            this.cols[i] = new Text();
            this.retCols[i] = this.cols[i];
            this.nullCols[i] = null;
        }
        ArrayList<String> fieldNames = new ArrayList<String>(this.numCols);
        ArrayList<ObjectInspector> fieldOIs = new ArrayList<ObjectInspector>(this.numCols);
        for (int i2 = 0; i2 < this.numCols; ++i2) {
            fieldNames.add("c" + i2);
            fieldOIs.add(PrimitiveObjectInspectorFactory.writableStringObjectInspector);
        }
        return ObjectInspectorFactory.getStandardStructObjectInspector(fieldNames, fieldOIs);
    }

    @Override
    public void process(Object[] o) throws HiveException {
        String jsonStr;
        if (o[0] == null) {
            this.forward(this.nullCols);
            return;
        }
        if (!this.pathParsed) {
            for (int i = 0; i < this.numCols; ++i) {
                this.paths[i] = ((StringObjectInspector)this.inputOIs[i + 1]).getPrimitiveJavaObject(o[i + 1]);
            }
            this.pathParsed = true;
        }
        if ((jsonStr = ((StringObjectInspector)this.inputOIs[0]).getPrimitiveJavaObject(o[0])) == null) {
            this.forward(this.nullCols);
            return;
        }
        try {
            Object jsonObj = this.jsonObjectCache.get(jsonStr);
            if (jsonObj == null) {
                try {
                    jsonObj = MAPPER.readValue(jsonStr, MAP_TYPE);
                }
                catch (Exception e) {
                    this.reportInvalidJson(jsonStr);
                    this.forward(this.nullCols);
                    return;
                }
                this.jsonObjectCache.put(jsonStr, jsonObj);
            }
            if (!(jsonObj instanceof Map)) {
                this.reportInvalidJson(jsonStr);
                this.forward(this.nullCols);
                return;
            }
            for (int i = 0; i < this.numCols; ++i) {
                Object extractObject;
                if (this.retCols[i] == null) {
                    this.retCols[i] = this.cols[i];
                }
                if ((extractObject = ((Map)jsonObj).get(this.paths[i])) instanceof Map || extractObject instanceof List) {
                    this.retCols[i].set(MAPPER.writeValueAsString(extractObject));
                    continue;
                }
                if (extractObject != null) {
                    this.retCols[i].set(extractObject.toString());
                    continue;
                }
                this.retCols[i] = null;
            }
            this.forward(this.retCols);
            return;
        }
        catch (Throwable e) {
            LOG.error("JSON parsing/evaluation exception" + e);
            this.forward(this.nullCols);
            return;
        }
    }

    public String toString() {
        return "json_tuple";
    }

    private void reportInvalidJson(String jsonStr) {
        if (!this.seenErrors) {
            LOG.error("The input is not a valid JSON string: " + jsonStr + ". Skipping such error messages in the future.");
            this.seenErrors = true;
        }
    }

    static {
        JSON_FACTORY.enable(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS);
        JSON_FACTORY.enable(JsonParser.Feature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER);
        MAPPER = new ObjectMapper(JSON_FACTORY);
        MAP_TYPE = TypeFactory.fromClass(Map.class);
    }

    static class HashCache<K, V>
    extends LinkedHashMap<K, V> {
        private static final int CACHE_SIZE = 16;
        private static final int INIT_SIZE = 32;
        private static final float LOAD_FACTOR = 0.6f;
        private static final long serialVersionUID = 1L;

        HashCache() {
            super(32, 0.6f);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > 16;
        }
    }
}

