/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite;

import io.trino.hive.$internal.com.google.common.collect.ImmutableList;
import org.apache.calcite.rel.metadata.ChainedRelMetadataProvider;
import org.apache.calcite.rel.metadata.DefaultRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.optimizer.calcite.cost.HiveCostModel;
import org.apache.hadoop.hive.ql.optimizer.calcite.cost.HiveDefaultCostModel;
import org.apache.hadoop.hive.ql.optimizer.calcite.cost.HiveOnTezCostModel;
import org.apache.hadoop.hive.ql.optimizer.calcite.cost.HiveRelMdCost;
import org.apache.hadoop.hive.ql.optimizer.calcite.stats.HiveRelMdCollation;
import org.apache.hadoop.hive.ql.optimizer.calcite.stats.HiveRelMdDistinctRowCount;
import org.apache.hadoop.hive.ql.optimizer.calcite.stats.HiveRelMdDistribution;
import org.apache.hadoop.hive.ql.optimizer.calcite.stats.HiveRelMdMemory;
import org.apache.hadoop.hive.ql.optimizer.calcite.stats.HiveRelMdParallelism;
import org.apache.hadoop.hive.ql.optimizer.calcite.stats.HiveRelMdPredicates;
import org.apache.hadoop.hive.ql.optimizer.calcite.stats.HiveRelMdRowCount;
import org.apache.hadoop.hive.ql.optimizer.calcite.stats.HiveRelMdSelectivity;
import org.apache.hadoop.hive.ql.optimizer.calcite.stats.HiveRelMdSize;
import org.apache.hadoop.hive.ql.optimizer.calcite.stats.HiveRelMdUniqueKeys;

public class HiveDefaultRelMetadataProvider {
    private final HiveConf hiveConf;

    public HiveDefaultRelMetadataProvider(HiveConf hiveConf) {
        this.hiveConf = hiveConf;
    }

    public RelMetadataProvider getMetadataProvider() {
        HiveCostModel cm = HiveConf.getVar(this.hiveConf, HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("tez") && HiveConf.getBoolVar(this.hiveConf, HiveConf.ConfVars.HIVE_CBO_EXTENDED_COST_MODEL) ? HiveOnTezCostModel.getCostModel(this.hiveConf) : HiveDefaultCostModel.getCostModel();
        Double maxSplitSize = HiveConf.getLongVar(this.hiveConf, HiveConf.ConfVars.MAPREDMAXSPLITSIZE);
        return ChainedRelMetadataProvider.of(ImmutableList.of(HiveRelMdDistinctRowCount.SOURCE, new HiveRelMdCost(cm).getMetadataProvider(), HiveRelMdSelectivity.SOURCE, HiveRelMdRowCount.SOURCE, HiveRelMdUniqueKeys.SOURCE, HiveRelMdSize.SOURCE, HiveRelMdMemory.SOURCE, new HiveRelMdParallelism(maxSplitSize).getMetadataProvider(), HiveRelMdDistribution.SOURCE, HiveRelMdCollation.SOURCE, HiveRelMdPredicates.SOURCE, DefaultRelMetadataProvider.INSTANCE, new RelMetadataProvider[0]));
    }
}

