/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import io.trino.hive.$internal.com.google.common.annotations.VisibleForTesting;
import io.trino.hive.$internal.org.slf4j.Logger;
import io.trino.hive.$internal.org.slf4j.LoggerFactory;
import io.trino.hive.orc.OrcUtils;
import io.trino.hive.orc.Reader;
import io.trino.hive.orc.StripeInformation;
import io.trino.hive.orc.TypeDescription;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.ql.io.AcidInputFormat;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.BucketCodec;
import org.apache.hadoop.hive.ql.io.RecordIdentifier;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcRecordUpdater;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.RecordReader;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;

public class OrcRawRecordMerger
implements AcidInputFormat.RawReader<OrcStruct> {
    private static final Logger LOG = LoggerFactory.getLogger(OrcRawRecordMerger.class);
    private final boolean collapse;
    private final RecordReader baseReader;
    private final ObjectInspector objectInspector;
    private final long offset;
    private final long length;
    private final ValidWriteIdList validWriteIdList;
    private final int columns;
    private final ReaderKey prevKey = new ReaderKey();
    private final RecordIdentifier minKey;
    private final RecordIdentifier maxKey;
    private OrcStruct extraValue;
    private final TreeMap<ReaderKey, ReaderPair> readers = new TreeMap();
    private ReaderPair primary;
    private ReaderKey secondaryKey = null;

    static int encodeBucketId(Configuration conf, int bucketId, int statementId) {
        return BucketCodec.V1.encode(new AcidOutputFormat.Options(conf).bucket(bucketId).statementId(statementId));
    }

    private KeyInterval discoverOriginalKeyBounds(Reader reader, int bucket, Reader.Options options, Configuration conf, Options mergerOptions) throws IOException {
        long rowLength = 0L;
        long rowOffset = 0L;
        long offset = options.getOffset();
        long maxOffset = options.getMaxOffset();
        boolean isTail = true;
        RecordIdentifier minKey = null;
        RecordIdentifier maxKey = null;
        TransactionMetaData tfp = TransactionMetaData.findWriteIDForSynthetcRowIDs(mergerOptions.getBucketPath(), mergerOptions.getRootPath(), conf);
        int bucketProperty = OrcRawRecordMerger.encodeBucketId(conf, bucket, tfp.statementId);
        for (StripeInformation stripe : reader.getStripes()) {
            if (offset > stripe.getOffset()) {
                rowOffset += stripe.getNumberOfRows();
                continue;
            }
            if (maxOffset > stripe.getOffset()) {
                rowLength += stripe.getNumberOfRows();
                continue;
            }
            isTail = false;
            break;
        }
        if (rowOffset > 0L) {
            minKey = new RecordIdentifier(0L, bucketProperty, rowOffset - 1L);
        }
        if (!isTail) {
            maxKey = new RecordIdentifier(0L, bucketProperty, rowOffset + rowLength - 1L);
        }
        return new KeyInterval(minKey, maxKey);
    }

    private KeyInterval discoverKeyBounds(Reader reader, Reader.Options options) throws IOException {
        RecordIdentifier[] keyIndex = OrcRecordUpdater.parseKeyIndex(reader);
        long offset = options.getOffset();
        long maxOffset = options.getMaxOffset();
        int firstStripe = 0;
        int stripeCount = 0;
        boolean isTail = true;
        RecordIdentifier minKey = null;
        RecordIdentifier maxKey = null;
        List<StripeInformation> stripes = reader.getStripes();
        for (StripeInformation stripe : stripes) {
            if (offset > stripe.getOffset()) {
                ++firstStripe;
                continue;
            }
            if (maxOffset > stripe.getOffset()) {
                ++stripeCount;
                continue;
            }
            isTail = false;
            break;
        }
        if (firstStripe != 0) {
            minKey = keyIndex[firstStripe - 1];
        }
        if (!isTail) {
            maxKey = keyIndex[firstStripe + stripeCount - 1];
        }
        return new KeyInterval(minKey, maxKey);
    }

    static Reader.Options createEventOptions(Reader.Options options, TypeDescription rowSchema) {
        Reader.Options result = options.clone();
        result.include(options.getInclude());
        if (options.getColumnNames() != null) {
            String[] orig = options.getColumnNames();
            String[] cols = new String[orig.length + 6];
            for (int i = 0; i < orig.length; ++i) {
                cols[i + 6] = orig[i];
            }
            result.searchArgument(options.getSearchArgument(), cols);
        }
        result.schema(rowSchema);
        return result;
    }

    OrcRawRecordMerger(Configuration conf, boolean collapseEvents, Reader reader, boolean isOriginal, int bucket, ValidWriteIdList validWriteIdList, Reader.Options options, Path[] deltaDirectory, Options mergerOptions) throws IOException {
        boolean isMajorNoBase;
        this.collapse = collapseEvents;
        this.offset = options.getOffset();
        this.length = options.getLength();
        this.validWriteIdList = validWriteIdList;
        boolean isBucketed = conf.getInt("bucket_count", 0) > 0;
        TypeDescription typeDescr = OrcInputFormat.getDesiredRowTypeDescr(conf, true, Integer.MAX_VALUE);
        this.objectInspector = OrcRecordUpdater.createEventObjectInspector(OrcStruct.createObjectInspector(0, OrcUtils.getOrcTypes(typeDescr)));
        assert (!mergerOptions.isCompacting() || reader == null) : "don't need a reader for compaction";
        Reader.Options eventOptions = OrcRawRecordMerger.createEventOptions(options, typeDescr);
        boolean bl = isMajorNoBase = mergerOptions.isCompacting() && mergerOptions.isMajorCompaction() && mergerOptions.getBaseDir() == null;
        if (mergerOptions.isCompacting() && mergerOptions.isMinorCompaction() || mergerOptions.isDeleteReader() || isMajorNoBase) {
            this.baseReader = null;
            this.maxKey = null;
            this.minKey = null;
            assert (reader == null) : "unexpected input reader during minor compaction: " + mergerOptions.getRootPath();
        } else {
            KeyInterval keyInterval;
            if (mergerOptions.isCompacting()) {
                assert (mergerOptions.isMajorCompaction());
                keyInterval = new KeyInterval(null, null);
            } else {
                keyInterval = isOriginal ? this.discoverOriginalKeyBounds(reader, bucket, options, conf, mergerOptions) : this.discoverKeyBounds(reader, options);
            }
            LOG.info("min key = " + keyInterval.getMinKey() + ", max key = " + keyInterval.getMaxKey());
            ReaderPair pair = null;
            ReaderKey baseKey = new ReaderKey();
            if (isOriginal) {
                Options readerPairOptions;
                options = options.clone();
                if (mergerOptions.isCompacting()) {
                    assert (mergerOptions.isMajorCompaction());
                    readerPairOptions = mergerOptions;
                    if (mergerOptions.getBaseDir().getName().startsWith("base_")) {
                        readerPairOptions = this.modifyForNonAcidSchemaRead(mergerOptions, AcidUtils.parseBase(mergerOptions.getBaseDir()), mergerOptions.getBaseDir());
                    }
                    pair = new OriginalReaderPairToCompact(baseKey, bucket, options, readerPairOptions, conf, validWriteIdList, 0);
                } else {
                    assert (mergerOptions.getBucketPath() != null) : " since this is not compaction: " + mergerOptions.getRootPath();
                    readerPairOptions = mergerOptions;
                    TransactionMetaData tfp = TransactionMetaData.findWriteIDForSynthetcRowIDs(mergerOptions.getBucketPath(), mergerOptions.getRootPath(), conf);
                    if (tfp.syntheticWriteId > 0L) {
                        readerPairOptions = this.modifyForNonAcidSchemaRead(mergerOptions, tfp.syntheticWriteId, tfp.folder);
                    }
                    pair = new OriginalReaderPairToRead(baseKey, reader, bucket, keyInterval.getMinKey(), keyInterval.getMaxKey(), options, readerPairOptions, conf, validWriteIdList, tfp.statementId);
                }
            } else if (mergerOptions.isCompacting()) {
                Path bucketPath;
                assert (mergerOptions.isMajorCompaction()) : "expected major compaction: " + mergerOptions.getBaseDir() + ":" + bucket;
                assert (mergerOptions.getBaseDir() != null) : "no baseDir?: " + mergerOptions.getRootPath();
                FileSystem fs = mergerOptions.getBaseDir().getFileSystem(conf);
                if (fs.exists(bucketPath = AcidUtils.createBucketFile(mergerOptions.getBaseDir(), bucket)) && fs.getFileStatus(bucketPath).getLen() > 0L) {
                    reader = OrcFile.createReader(bucketPath, OrcFile.readerOptions(conf));
                    pair = new ReaderPairAcid(baseKey, reader, keyInterval.getMinKey(), keyInterval.getMaxKey(), eventOptions, conf);
                } else {
                    pair = new EmptyReaderPair();
                    LOG.info("No non-empty " + bucketPath + " was found for Major compaction");
                }
            } else {
                assert (reader != null) : "no reader? " + mergerOptions.getRootPath();
                pair = new ReaderPairAcid(baseKey, reader, keyInterval.getMinKey(), keyInterval.getMaxKey(), eventOptions, conf);
            }
            this.minKey = pair.getMinKey();
            this.maxKey = pair.getMaxKey();
            LOG.info("updated min key = " + keyInterval.getMinKey() + ", max key = " + keyInterval.getMaxKey());
            if (pair.nextRecord() != null) {
                this.ensurePutReader(baseKey, pair);
                baseKey = null;
            }
            this.baseReader = pair.getRecordReader();
        }
        if (deltaDirectory != null && deltaDirectory.length > 0) {
            Reader.Options deltaEventOptions = eventOptions.clone().searchArgument(null, null).range(0L, Long.MAX_VALUE);
            for (Path delta : deltaDirectory) {
                if (!mergerOptions.isCompacting() && !AcidUtils.isDeleteDelta(delta)) {
                    throw new IllegalStateException(delta + " is not delete delta and is not compacting.");
                }
                ReaderKey key = new ReaderKey();
                AcidUtils.ParsedDelta deltaDir = AcidUtils.parsedDelta(delta, delta.getFileSystem(conf));
                if (deltaDir.isRawFormat()) {
                    assert (!deltaDir.isDeleteDelta()) : delta.toString();
                    assert (mergerOptions.isCompacting()) : "during regular read anything which is not a delete_delta is treated like base: " + delta;
                    Options rawCompactOptions = this.modifyForNonAcidSchemaRead(mergerOptions, deltaDir.getMinWriteId(), delta);
                    OriginalReaderPairToCompact deltaPair = new OriginalReaderPairToCompact(key, bucket, options, rawCompactOptions, conf, validWriteIdList, deltaDir.getStatementId());
                    if (deltaPair.nextRecord() == null) continue;
                    this.ensurePutReader(key, deltaPair);
                    key = new ReaderKey();
                    continue;
                }
                for (Path deltaFile : OrcRawRecordMerger.getDeltaFiles(delta, bucket, conf, mergerOptions, isBucketed)) {
                    FileSystem fs = deltaFile.getFileSystem(conf);
                    if (!fs.exists(deltaFile)) continue;
                    LOG.debug("Looking at delta file {}", (Object)deltaFile);
                    if (deltaDir.isDeleteDelta()) {
                        Reader deltaReader = OrcFile.createReader(deltaFile, OrcFile.readerOptions(conf));
                        ReaderPairAcid deltaPair = new ReaderPairAcid(key, deltaReader, this.minKey, this.maxKey, deltaEventOptions, conf);
                        if (deltaPair.nextRecord() == null) continue;
                        this.ensurePutReader(key, deltaPair);
                        key = new ReaderKey();
                        continue;
                    }
                    assert (mergerOptions.isCompacting()) : "not compacting and not delete delta : " + delta;
                    long length = AcidUtils.getLogicalLength(fs, fs.getFileStatus(deltaFile));
                    assert (length >= 0L);
                    Reader deltaReader = OrcFile.createReader(deltaFile, OrcFile.readerOptions(conf).maxLength(length));
                    ReaderPairAcid deltaPair = new ReaderPairAcid(key, deltaReader, this.minKey, this.maxKey, deltaEventOptions, conf);
                    if (deltaPair.nextRecord() == null) continue;
                    this.ensurePutReader(key, deltaPair);
                    key = new ReaderKey();
                }
            }
        }
        LOG.debug("Final reader map {}", (Object)this.readers);
        Map.Entry<ReaderKey, ReaderPair> entry = this.readers.pollFirstEntry();
        if (entry == null) {
            this.columns = 0;
            this.primary = null;
        } else {
            this.primary = entry.getValue();
            this.secondaryKey = this.readers.isEmpty() ? null : this.readers.firstKey();
            this.columns = this.primary.getColumns();
        }
    }

    private void ensurePutReader(ReaderKey key, ReaderPair deltaPair) throws IOException {
        ReaderPair oldPair = this.readers.put(key, deltaPair);
        if (oldPair == null) {
            return;
        }
        String error = "Two readers for " + key + ": new " + deltaPair + ", old " + oldPair;
        LOG.error(error);
        throw new IOException(error);
    }

    private Options modifyForNonAcidSchemaRead(Options baseOptions, long writeId, Path rootPath) {
        return baseOptions.clone().writeId(writeId).rootPath(rootPath);
    }

    static Path[] getDeltaFiles(Path deltaDirectory, int bucket, Configuration conf, Options mergerOptions, boolean isBucketed) throws IOException {
        if (isBucketed) {
            assert (!mergerOptions.isCompacting && deltaDirectory.getName().startsWith("delete_delta_") || mergerOptions.isCompacting) : "Unexpected delta: " + deltaDirectory;
            Path deltaFile = AcidUtils.createBucketFile(deltaDirectory, bucket);
            return new Path[]{deltaFile};
        }
        if (deltaDirectory.getName().startsWith("delete_delta_")) {
            FileSystem fs = deltaDirectory.getFileSystem(conf);
            FileStatus[] dataFiles = fs.listStatus(deltaDirectory, AcidUtils.bucketFileFilter);
            Path[] deltaFiles = new Path[dataFiles.length];
            int i = 0;
            for (FileStatus stat : dataFiles) {
                deltaFiles[i++] = stat.getPath();
            }
            return deltaFiles;
        }
        assert (mergerOptions.isCompacting()) : "Expected to be called as part of compaction";
        Path deltaFile = AcidUtils.createBucketFile(deltaDirectory, bucket);
        return new Path[]{deltaFile};
    }

    @VisibleForTesting
    RecordIdentifier getMinKey() {
        return this.minKey;
    }

    @VisibleForTesting
    RecordIdentifier getMaxKey() {
        return this.maxKey;
    }

    @VisibleForTesting
    ReaderPair getCurrentReader() {
        return this.primary;
    }

    @VisibleForTesting
    Map<ReaderKey, ReaderPair> getOtherReaders() {
        return this.readers;
    }

    public boolean next(RecordIdentifier recordIdentifier, OrcStruct prev) throws IOException {
        boolean keysSame = true;
        while (keysSame && this.primary != null) {
            OrcStruct current = this.primary.nextRecord();
            recordIdentifier.set(this.primary.getKey());
            this.primary.next(this.extraValue);
            this.extraValue = current;
            if (this.primary.nextRecord() == null || this.primary.getKey().compareTo(this.secondaryKey) > 0) {
                Map.Entry<ReaderKey, ReaderPair> entry;
                if (this.primary.nextRecord() != null) {
                    this.readers.put(this.primary.getKey(), this.primary);
                }
                if ((entry = this.readers.pollFirstEntry()) != null) {
                    this.primary = entry.getValue();
                    this.secondaryKey = this.readers.isEmpty() ? null : this.readers.firstKey();
                } else {
                    this.primary = null;
                }
            }
            if (!this.validWriteIdList.isWriteIdValid(((ReaderKey)recordIdentifier).getCurrentWriteId())) continue;
            boolean isSameRow = this.prevKey.isSameRow((ReaderKey)recordIdentifier);
            if (this.collapse || isSameRow) {
                boolean bl = keysSame = this.collapse && this.prevKey.compareRow(recordIdentifier) == 0 || isSameRow;
                if (!keysSame) {
                    this.prevKey.set(recordIdentifier);
                }
            } else {
                keysSame = false;
            }
            prev.linkFields(current);
        }
        return !keysSame;
    }

    public RecordIdentifier createKey() {
        return new ReaderKey();
    }

    public OrcStruct createValue() {
        return new OrcStruct(6);
    }

    public long getPos() throws IOException {
        return this.offset + (long)(this.getProgress() * (float)this.length);
    }

    public void close() throws IOException {
        if (this.primary != null) {
            this.primary.getRecordReader().close();
        }
        for (ReaderPair pair : this.readers.values()) {
            pair.getRecordReader().close();
        }
    }

    public float getProgress() throws IOException {
        return this.baseReader == null ? 1.0f : this.baseReader.getProgress();
    }

    @Override
    public ObjectInspector getObjectInspector() {
        return this.objectInspector;
    }

    @Override
    public boolean isDelete(OrcStruct value) {
        return OrcRecordUpdater.getOperation(value) == 2;
    }

    public int getColumns() {
        return this.columns;
    }

    static final class TransactionMetaData {
        final long syntheticWriteId;
        final Path folder;
        final int statementId;

        TransactionMetaData(long syntheticWriteId, Path folder) {
            this(syntheticWriteId, folder, 0);
        }

        TransactionMetaData(long syntheticWriteId, Path folder, int statementId) {
            this.syntheticWriteId = syntheticWriteId;
            this.folder = folder;
            this.statementId = statementId;
        }

        static TransactionMetaData findWriteIDForSynthetcRowIDs(Path splitPath, Path rootPath, Configuration conf) throws IOException {
            Path parent = splitPath.getParent();
            if (rootPath.equals((Object)parent)) {
                return new TransactionMetaData(0L, parent);
            }
            while (parent != null && !rootPath.equals((Object)parent)) {
                boolean isBase = parent.getName().startsWith("base_");
                boolean isDelta = parent.getName().startsWith("delta_");
                if (isBase || isDelta) {
                    if (isBase) {
                        return new TransactionMetaData(AcidUtils.parseBase(parent), parent);
                    }
                    AcidUtils.ParsedDelta pd = AcidUtils.parsedDelta(parent, "delta_", parent.getFileSystem(conf));
                    assert (pd.getMinWriteId() == pd.getMaxWriteId()) : "This a delta with raw non acid schema, must be result of single write, no compaction: " + splitPath;
                    return new TransactionMetaData(pd.getMinWriteId(), parent, pd.getStatementId());
                }
                parent = parent.getParent();
            }
            if (parent == null) {
                throw new IllegalStateException("Cannot determine write id for original file " + splitPath + " in " + rootPath);
            }
            return new TransactionMetaData(0L, rootPath);
        }
    }

    static class Options
    implements Cloneable {
        private int copyIndex = 0;
        private boolean isCompacting = false;
        private Path bucketPath;
        private Path rootPath;
        private Path baseDir;
        private boolean isMajorCompaction = false;
        private boolean isDeleteReader = false;
        private long writeId = 0L;

        Options() {
        }

        Options copyIndex(int copyIndex) {
            assert (copyIndex >= 0);
            this.copyIndex = copyIndex;
            return this;
        }

        Options isCompacting(boolean isCompacting) {
            this.isCompacting = isCompacting;
            assert (!this.isDeleteReader);
            return this;
        }

        Options bucketPath(Path bucketPath) {
            this.bucketPath = bucketPath;
            return this;
        }

        Options rootPath(Path rootPath) {
            this.rootPath = rootPath;
            return this;
        }

        Options isMajorCompaction(boolean isMajor) {
            this.isMajorCompaction = isMajor;
            assert (!this.isDeleteReader);
            return this;
        }

        Options isDeleteReader(boolean isDeleteReader) {
            this.isDeleteReader = isDeleteReader;
            assert (!this.isCompacting);
            return this;
        }

        Options writeId(long writeId) {
            this.writeId = writeId;
            return this;
        }

        Options baseDir(Path baseDir) {
            this.baseDir = baseDir;
            return this;
        }

        int getCopyIndex() {
            return this.copyIndex;
        }

        boolean isCompacting() {
            return this.isCompacting;
        }

        Path getBucketPath() {
            return this.bucketPath;
        }

        Path getRootPath() {
            return this.rootPath;
        }

        boolean isMajorCompaction() {
            return this.isMajorCompaction && this.isCompacting;
        }

        boolean isMinorCompaction() {
            return !this.isMajorCompaction && this.isCompacting;
        }

        boolean isDeleteReader() {
            return this.isDeleteReader;
        }

        long getWriteId() {
            return this.writeId;
        }

        Path getBaseDir() {
            return this.baseDir;
        }

        public Options clone() {
            try {
                return (Options)super.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new AssertionError();
            }
        }
    }

    private static final class KeyInterval {
        private final RecordIdentifier minKey;
        private final RecordIdentifier maxKey;

        private KeyInterval(RecordIdentifier minKey, RecordIdentifier maxKey) {
            this.minKey = minKey;
            this.maxKey = maxKey;
        }

        private RecordIdentifier getMinKey() {
            return this.minKey;
        }

        private RecordIdentifier getMaxKey() {
            return this.maxKey;
        }
    }

    @VisibleForTesting
    static final class OriginalReaderPairToCompact
    extends OriginalReaderPair {
        private final List<HadoopShims.HdfsFileStatusWithId> originalFiles;
        private int nextFileIndex = 0;
        private Reader reader;
        private RecordReader recordReader = null;
        private final Configuration conf;
        private final Reader.Options options;
        private long rowIdOffset = 0L;

        OriginalReaderPairToCompact(ReaderKey key, int bucketId, Reader.Options options, Options mergerOptions, Configuration conf, ValidWriteIdList validWriteIdList, int statementId) throws IOException {
            super(key, bucketId, conf, mergerOptions, statementId);
            assert (mergerOptions.isCompacting()) : "Should only be used for Compaction";
            this.conf = conf;
            this.options = options;
            assert (mergerOptions.getRootPath() != null) : "Since we have original files";
            assert (this.bucketId >= 0) : "don't support non-bucketed tables yet";
            assert (options.getOffset() == 0L);
            assert (options.getMaxOffset() == Long.MAX_VALUE);
            AcidUtils.Directory directoryState = AcidUtils.getAcidState(mergerOptions.getRootPath(), conf, validWriteIdList, false, true);
            this.originalFiles = directoryState.getOriginalFiles();
            assert (this.originalFiles.size() > 0);
            this.reader = this.advanceToNextFile();
            if (this.reader == null) {
                throw new IllegalStateException("No 'original' files found for bucketId=" + this.bucketId + " in " + mergerOptions.getRootPath());
            }
            this.recordReader = this.getReader().rowsOptions(options, conf);
            this.next(this.nextRecord());
        }

        @Override
        public RecordReader getRecordReader() {
            return this.recordReader;
        }

        @Override
        public Reader getReader() {
            return this.reader;
        }

        @Override
        public RecordIdentifier getMinKey() {
            return null;
        }

        @Override
        public RecordIdentifier getMaxKey() {
            return null;
        }

        @Override
        public long getRowIdOffset() {
            return this.rowIdOffset;
        }

        @Override
        public void next(OrcStruct next) throws IOException {
            while (!this.nextFromCurrentFile(next)) {
                if (this.originalFiles.size() <= this.nextFileIndex) {
                    this.nextRecord = null;
                    this.recordReader.close();
                    return;
                }
                this.rowIdOffset += this.reader.getNumberOfRows();
                this.recordReader.close();
                this.reader = this.advanceToNextFile();
                if (this.reader == null) {
                    this.nextRecord = null;
                    return;
                }
                this.recordReader = this.reader.rowsOptions(this.options, this.conf);
            }
            return;
        }

        private Reader advanceToNextFile() throws IOException {
            int bucketIdFromPath;
            while (this.nextFileIndex < this.originalFiles.size() && (bucketIdFromPath = AcidUtils.parseBucketId(this.originalFiles.get(this.nextFileIndex).getFileStatus().getPath())) != this.bucketId) {
                ++this.nextFileIndex;
            }
            if (this.originalFiles.size() <= this.nextFileIndex) {
                return null;
            }
            return OrcFile.createReader(this.originalFiles.get(this.nextFileIndex++).getFileStatus().getPath(), OrcFile.readerOptions(this.conf));
        }
    }

    @VisibleForTesting
    static final class OriginalReaderPairToRead
    extends OriginalReaderPair {
        private final long rowIdOffset;
        private final Reader reader;
        private final RecordReader recordReader;
        private final RecordIdentifier minKey;
        private final RecordIdentifier maxKey;

        OriginalReaderPairToRead(ReaderKey key, Reader reader, int bucketId, RecordIdentifier minKey, RecordIdentifier maxKey, Reader.Options options, Options mergerOptions, Configuration conf, ValidWriteIdList validWriteIdList, int statementId) throws IOException {
            super(key, bucketId, conf, mergerOptions, statementId);
            this.reader = reader;
            assert (!mergerOptions.isCompacting());
            assert (mergerOptions.getRootPath() != null) : "Since we have original files";
            RecordIdentifier newMinKey = minKey;
            RecordIdentifier newMaxKey = maxKey;
            this.recordReader = reader.rowsOptions(options, conf);
            boolean isLastFileForThisBucket = true;
            boolean haveSeenCurrentFile = false;
            long rowIdOffsetTmp = 0L;
            AcidUtils.Directory directoryState = AcidUtils.getAcidState(mergerOptions.getRootPath(), conf, validWriteIdList, false, true);
            for (HadoopShims.HdfsFileStatusWithId f : directoryState.getOriginalFiles()) {
                int bucketIdFromPath = AcidUtils.parseBucketId(f.getFileStatus().getPath());
                if (bucketIdFromPath != bucketId) continue;
                if (haveSeenCurrentFile) {
                    isLastFileForThisBucket = false;
                    break;
                }
                if (f.getFileStatus().getPath().equals((Object)mergerOptions.getBucketPath())) {
                    haveSeenCurrentFile = true;
                    isLastFileForThisBucket = true;
                    continue;
                }
                Reader copyReader = OrcFile.createReader(f.getFileStatus().getPath(), OrcFile.readerOptions(conf));
                rowIdOffsetTmp += copyReader.getNumberOfRows();
            }
            this.rowIdOffset = rowIdOffsetTmp;
            if (this.rowIdOffset > 0L) {
                if (minKey != null) {
                    minKey.setRowId(minKey.getRowId() + this.rowIdOffset);
                } else {
                    newMinKey = new RecordIdentifier(this.writeId, this.bucketProperty, this.rowIdOffset - 1L);
                }
                if (maxKey != null) {
                    maxKey.setRowId(maxKey.getRowId() + this.rowIdOffset);
                }
            }
            if (!isLastFileForThisBucket && maxKey == null) {
                newMaxKey = new RecordIdentifier(this.writeId, this.bucketProperty, this.rowIdOffset + reader.getNumberOfRows() - 1L);
            }
            this.minKey = newMinKey;
            this.maxKey = newMaxKey;
            do {
                this.next(this.nextRecord());
            } while (this.nextRecord() != null && this.getMinKey() != null && this.getKey().compareRow(this.getMinKey()) <= 0);
        }

        @Override
        public RecordReader getRecordReader() {
            return this.recordReader;
        }

        @Override
        public Reader getReader() {
            return this.reader;
        }

        @Override
        public RecordIdentifier getMinKey() {
            return this.minKey;
        }

        @Override
        public RecordIdentifier getMaxKey() {
            return this.maxKey;
        }

        @Override
        public long getRowIdOffset() {
            return this.rowIdOffset;
        }

        @Override
        public void next(OrcStruct next) throws IOException {
            if (!this.nextFromCurrentFile(next)) {
                this.nextRecord = null;
                this.getRecordReader().close();
            }
        }
    }

    private static abstract class OriginalReaderPair
    implements ReaderPair {
        OrcStruct nextRecord;
        private final ReaderKey key;
        final int bucketId;
        final int bucketProperty;
        final long writeId;

        OriginalReaderPair(ReaderKey key, int bucketId, Configuration conf, Options mergeOptions, int statementId) throws IOException {
            this.key = key;
            this.bucketId = bucketId;
            assert (bucketId >= 0) : "don't support non-bucketed tables yet";
            this.bucketProperty = OrcRawRecordMerger.encodeBucketId(conf, bucketId, statementId);
            this.writeId = mergeOptions.getWriteId();
        }

        @Override
        public final OrcStruct nextRecord() {
            return this.nextRecord;
        }

        @Override
        public int getColumns() {
            return this.getReader().getTypes().get(0).getSubtypesCount();
        }

        @Override
        public final ReaderKey getKey() {
            return this.key;
        }

        abstract long getRowIdOffset();

        final boolean nextFromCurrentFile(OrcStruct next) throws IOException {
            if (this.getRecordReader().hasNext()) {
                long nextRowId = this.getRecordReader().getRowNumber() + this.getRowIdOffset();
                if (next == null) {
                    this.nextRecord = new OrcStruct(6);
                    IntWritable operation = new IntWritable(0);
                    this.nextRecord().setFieldValue(0, operation);
                    this.nextRecord().setFieldValue(4, new LongWritable(this.writeId));
                    this.nextRecord().setFieldValue(1, new LongWritable(this.writeId));
                    this.nextRecord().setFieldValue(2, new IntWritable(this.bucketProperty));
                    this.nextRecord().setFieldValue(3, new LongWritable(nextRowId));
                    this.nextRecord().setFieldValue(5, this.getRecordReader().next(null));
                } else {
                    this.nextRecord = next;
                    ((IntWritable)next.getFieldValue(0)).set(0);
                    ((LongWritable)next.getFieldValue(1)).set(this.writeId);
                    ((IntWritable)next.getFieldValue(2)).set(this.bucketProperty);
                    ((LongWritable)next.getFieldValue(4)).set(this.writeId);
                    ((LongWritable)next.getFieldValue(3)).set(nextRowId);
                    this.nextRecord().setFieldValue(5, this.getRecordReader().next(OrcRecordUpdater.getRow(next)));
                }
                this.key.setValues(this.writeId, this.bucketProperty, nextRowId, this.writeId, false);
                if (this.getMaxKey() != null && this.key.compareRow(this.getMaxKey()) > 0) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("key " + this.key + " > maxkey " + this.getMaxKey());
                    }
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    @VisibleForTesting
    static final class ReaderPairAcid
    implements ReaderPair {
        private OrcStruct nextRecord;
        private final Reader reader;
        private final RecordReader recordReader;
        private final ReaderKey key;
        private final RecordIdentifier minKey;
        private final RecordIdentifier maxKey;

        @VisibleForTesting
        ReaderPairAcid(ReaderKey key, Reader reader, RecordIdentifier minKey, RecordIdentifier maxKey, Reader.Options options, Configuration conf) throws IOException {
            this.reader = reader;
            this.key = key;
            this.recordReader = reader.rowsOptions(options, conf);
            this.minKey = minKey;
            this.maxKey = maxKey;
            do {
                this.next(this.nextRecord());
            } while (this.nextRecord() != null && minKey != null && key.compareRow(this.getMinKey()) <= 0);
        }

        public String toString() {
            return "[key=" + this.key + ", nextRecord=" + this.nextRecord + ", reader=" + this.reader + "]";
        }

        @Override
        public final OrcStruct nextRecord() {
            return this.nextRecord;
        }

        @Override
        public final int getColumns() {
            return this.getReader().getTypes().get(6).getSubtypesCount();
        }

        @Override
        public RecordReader getRecordReader() {
            return this.recordReader;
        }

        @Override
        public Reader getReader() {
            return this.reader;
        }

        @Override
        public RecordIdentifier getMinKey() {
            return this.minKey;
        }

        @Override
        public RecordIdentifier getMaxKey() {
            return this.maxKey;
        }

        @Override
        public ReaderKey getKey() {
            return this.key;
        }

        @Override
        public void next(OrcStruct next) throws IOException {
            if (this.getRecordReader().hasNext()) {
                this.nextRecord = (OrcStruct)this.getRecordReader().next(next);
                this.getKey().setValues(OrcRecordUpdater.getOriginalTransaction(this.nextRecord()), OrcRecordUpdater.getBucket(this.nextRecord()), OrcRecordUpdater.getRowId(this.nextRecord()), OrcRecordUpdater.getCurrentTransaction(this.nextRecord()), OrcRecordUpdater.getOperation(this.nextRecord()) == 2);
                if (this.getMaxKey() != null && this.getKey().compareRow(this.getMaxKey()) > 0) {
                    LOG.debug("key " + this.getKey() + " > maxkey " + this.getMaxKey());
                    this.nextRecord = null;
                    this.getRecordReader().close();
                }
            } else {
                this.nextRecord = null;
                this.getRecordReader().close();
            }
        }
    }

    private class EmptyReaderPair
    implements ReaderPair {
        private EmptyReaderPair() {
        }

        @Override
        public OrcStruct nextRecord() {
            return null;
        }

        @Override
        public int getColumns() {
            return 0;
        }

        @Override
        public RecordReader getRecordReader() {
            return null;
        }

        @Override
        public Reader getReader() {
            return null;
        }

        @Override
        public RecordIdentifier getMinKey() {
            return null;
        }

        @Override
        public RecordIdentifier getMaxKey() {
            return null;
        }

        @Override
        public ReaderKey getKey() {
            return null;
        }

        @Override
        public void next(OrcStruct next) throws IOException {
        }
    }

    static interface ReaderPair {
        public OrcStruct nextRecord();

        public int getColumns();

        public RecordReader getRecordReader();

        public Reader getReader();

        public RecordIdentifier getMinKey();

        public RecordIdentifier getMaxKey();

        public ReaderKey getKey();

        public void next(OrcStruct var1) throws IOException;
    }

    @VisibleForTesting
    public static final class ReaderKey
    extends RecordIdentifier {
        private long currentWriteId;
        private boolean isDeleteEvent = false;

        ReaderKey() {
            this(-1L, -1, -1L, -1L);
        }

        public ReaderKey(long originalWriteId, int bucket, long rowId, long currentWriteId) {
            super(originalWriteId, bucket, rowId);
            this.currentWriteId = currentWriteId;
        }

        @Override
        public void set(RecordIdentifier other) {
            super.set(other);
            this.currentWriteId = ((ReaderKey)other).currentWriteId;
            this.isDeleteEvent = ((ReaderKey)other).isDeleteEvent;
        }

        public void setValues(long originalWriteId, int bucket, long rowId, long currentWriteId, boolean isDelete) {
            this.setValues(originalWriteId, bucket, rowId);
            this.currentWriteId = currentWriteId;
            this.isDeleteEvent = isDelete;
        }

        @Override
        public boolean equals(Object other) {
            return super.equals(other) && this.currentWriteId == ((ReaderKey)other).currentWriteId;
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (int)(this.currentWriteId ^ this.currentWriteId >>> 32);
            return result;
        }

        @Override
        public int compareTo(RecordIdentifier other) {
            int sup = this.compareToInternal(other);
            if (sup == 0) {
                if (other.getClass() == ReaderKey.class) {
                    ReaderKey oth = (ReaderKey)other;
                    if (this.currentWriteId != oth.currentWriteId) {
                        return this.currentWriteId < oth.currentWriteId ? 1 : -1;
                    }
                    if (this.isDeleteEvent != oth.isDeleteEvent) {
                        return this.isDeleteEvent ? -1 : 1;
                    }
                } else {
                    return -1;
                }
            }
            return sup;
        }

        private boolean isSameRow(ReaderKey other) {
            return this.compareRow(other) == 0 && this.currentWriteId == other.currentWriteId;
        }

        long getCurrentWriteId() {
            return this.currentWriteId;
        }

        int compareRow(RecordIdentifier other) {
            return this.compareToInternal(other);
        }

        @Override
        public String toString() {
            return "{originalWriteId: " + this.getWriteId() + ", " + this.bucketToString() + ", row: " + this.getRowId() + ", currentWriteId " + this.currentWriteId + "}";
        }
    }
}

